<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('recruitments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employer_id')->nullable()->constrained('users');
            $table->foreignId('candidate_id')->nullable()->constrained('users');
            $table->foreignId('job_id')->constrained('job_vacancies');
            $table->timestamp('selected_date')->nullable();
            $table->string('mobile_number')->nullable();
            $table->text('msg_to_candidate')->nullable();
            $table->integer('is_active')->length(1)->default(1);
            $table->integer('recruitment_status')->nullable()->default(1);
            $table->integer('if_selected')->nullable();
            $table->foreignId('created_by')->constrained('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('recruitments');
    }
};
