<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reset_password_requests', function (Blueprint $table) {
            $table->id();
            $table->longText('requested_client_ip_address')->nullable();
            $table->foreignId('user_id')->constrained('users')->nullable();
            $table->string('otp', 10);
            $table->dateTime('requested_at');
            $table->longText('history')->nullable();
            $table->string('email', 100);
            $table->integer('status')->length(2)->default(1);
            $table->string('request_status', 50);
            $table->dateTime('valid_upto');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reset_password_requests');
    }
};
