<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->id();
            $table->string('training_name');
            $table->text('description');
            $table->foreignId('sector_id')->nullable()->constrained('sectors');
            $table->foreignId('pia_id')->nullable()->constrained('program_implementation_agencies');
            $table->foreignId('district_id')->nullable()->constrained('districts');
            $table->foreignId('block_id')->nullable()->constrained('blocks');
            $table->foreignId('localbody_id')->nullable()->constrained('localbodies');
            $table->foreignId('localbodytype_id')->nullable()->constrained('localbodytypes'); 
            $table->date('start_date');
            $table->date('end_date');
            $table->string('venue')->nullable();
            $table->string('duration')->nullable();
            $table->integer('general_seats')->default(0)->nullable();
            $table->integer('scst_seats')->default(0)->nullable();
            $table->integer('minority_seats')->default(0)->nullable();
            $table->integer('no_of_seats')->default(0)->nullable();
            $table->string('Remarks')->nullable();
            $table->string('future_possibilities')->nullable();
            $table->integer('course_status')->default(0)->nullable();
            $table->foreignId('coursemaster_id')->nullable()->constrained('course_masters'); 
            $table->integer('is_active')->length(1)->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('courses');
    }
};
