<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('course_masters', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sector_id')->constrained('sectors');
            $table->string('tradename');
            $table->string('tradecode')->nullable();
            $table->string('duration')->nullable();
            $table->integer('is_active')->length(1)->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('course_masters');
    }
};
