<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('candidate_interests', function (Blueprint $table) {
            $table->id();
            $table->string('name');                        
            $table->string('email')->unique();
            $table->string('mobile_Number',10)->nullable();
            $table->string('phone_Number',12)->nullable();
            $table->date('dob')->nullable();
            $table->string('highest_qualification')->nullable();
            $table->string('additional_certificates')->nullable();
            $table->string('building_name')->nullable();
            $table->string('landmark')->nullable();
            $table->string('postOffice')->nullable(); 
            $table->string('pincode',6)->nullable();  
            $table->foreignId('district_id')->nullable()->constrained('districts');
            $table->foreignId('block_id')->nullable()->constrained('blocks');
            $table->foreignId('localbodyid')->nullable()->constrained('localbodies');
            $table->foreignId('lbtypeid')->nullable()->constrained('localbodytypes');
            $table->string('religion')->nullable();
            $table->string('category')->nullable();
            $table->string('pwd')->nullable();
            $table->string('rationcardtype')->nullable();    
            $table->string('MGNREGA')->nullable();  
            $table->string('gender')->nullable();
            $table->string('willingTojoin')->nullable();
            $table->string('kudumbashree_member')->nullable();  
            $table->string('training_program_id')->nullable();            
            $table->integer('status')->nullable()->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('candidate_interests');
    }
};
