<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('program_implementation_agencies', function (Blueprint $table) {
            $table->id();
            $table->string('agency_name');
            $table->string('building_number');
            $table->string('street_name');
            $table->foreignId('district_id')->constrained('districts');
            $table->foreignId('state_id')->constrained('states');
            $table->string('post_office');
            $table->string('pincode',6);
            $table->string('mobile_number');
            $table->string('phone_number');
            $table->string('pan_number');
            $table->string('email');
            $table->integer('is_active')->length(1)->default(1);
            $table->foreignId('user_id')->constrained('users');
            $table->string('attachment')->nullable();
            $table->foreignId('created_by')->constrained('users');
            $table->foreignId('updated_by')->constrained('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('program_implementation_agencies');
    }
};
