<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->foreignId('user_role_id')->nullable()->constrained('user_roles');
            $table->foreignId('country_id')->nullable()->constrained('countries');
            $table->foreignId('state_id')->nullable()->constrained('states');
            $table->foreignId('district_id')->nullable()->constrained('districts');
            $table->foreignId('block_id')->nullable()->constrained('blocks');
            $table->foreignId('localbody_id')->nullable()->constrained('localbodies');
            $table->foreignId('lbTypeid')->nullable()->constrained('localbodytypes');          
            $table->string('email')->unique();
            $table->string('password');
            $table->date('dob')->nullable();
            $table->string('mobile_number',10)->nullable();
            $table->string('phone_number',12)->nullable();
            $table->string('building_name')->nullable();
            $table->string('landmark')->nullable();
            $table->string('postOffice')->nullable(); 
            $table->integer('pincode')->nullable()->unsigned();  
            $table->foreignId('sector_id')->nullable()->constrained('sectors');
            $table->string('pan_number')->nullable();
            $table->string('document_upload')->nullable();
            $table->string('license_id')->nullable();
            $table->integer('profile_status')->nullable()->default(1);
            $table->integer('status')->nullable()->default(1);
            $table->rememberToken();
           
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
