<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('localbodies', function (Blueprint $table) {
            $table->id();
            $table->string('name_eng');
            $table->foreignId('lb_type_id')->constrained('localbodytypes');
            $table->foreignId('district_id')->constrained('districts');
            $table->foreignId('block_id')->constrained('blocks')->nullable();
            $table->integer('is_active')->length(10)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('localbodies');
    }
};
