<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\User>
 */
class UserFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'name' => fake()->name(),
            'user_role_id' => 1,
            'Country_id' => 1,
            'state_id' => 1,
            'district_id' => 1,
            'block_id' => 1,
            'email' => fake()->unique()->safeEmail(),
            'password' => Hash::make('Password*2024#'),
            'Mobile_Number' => rand(9999999999, 8000000000),
            'Phone_Number' => rand(9999999999, 8000000000),
            'remember_token' => Str::random(10),
        ];
    }

    /**
     * Indicate that the model's email address should be unverified.
     *
     * @return static
     */
    public function unverified()
    {
        return $this->state(fn(array $attributes) => [
            'email_verified_at' => null,
        ]);
    }
}
