<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ProgramImplementationAgency>
 */
class ProgramImplementationAgencyFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'agency_name' => fake()->unique()->name(),
            'address_line_1' => fake()->name(),
            'address_line_2' => fake()->name(),
            'block_id' => 1,
            'district_id' => 1,
            'state_id' => 32,
            'country_id' => 1,
            'sector_id' => 1,
            'phone_number' => rand(9999999999, 1111100000),
            'mobile_number' => rand(9999999999, 1111100000),
            'pan_number' => 'FLNP895623',
            'email' => 'pia@project.com',
            'pincode' => rand(999999, 111111),
            'user_id' => 4,
        ];
    }
}
