<?php

namespace App;

use App\Models\Recruitment;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'user_type',
        'email',
        'password',
        'mobile_number',
        'gender',
        'initial_login_status',
        'mobile_verified_status',
        'email_verified_status',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    public function UserProfile()
    {
        return $this->hasOne('App\UserProfile', 'user_id');
    }


    public function UserAddress()
    {
        return $this->hasMany('App\UserAddress', 'user_id')->where('active_address', 1);
    }


    public function PermenentUserAddress()
    {
        return $this->hasOne('App\UserAddress', 'user_id')->whereAddressType(1);
    }

    public function LatestPermanentAddress()
    {
        return $this->hasOne('App\UserAddress', 'user_id')->whereAddressType(1)->whereActiveAddress(1)->orderByDesc('id');
    }

    public function LatestCommunicationAddress()
    {
        return $this->hasOne('App\UserAddress', 'user_id')->whereAddressType(2)->whereActiveAddress(1)->orderByDesc('id');
    }

    public function LatestProfessionalAddress()
    {
        return $this->hasOne('App\UserAddress', 'user_id')->whereAddressType(3)->whereActiveAddress(1)->orderByDesc('id');
    }

    public function LastPermenentUserAddress()
    {
        return $this->hasOne('App\UserAddress', 'user_id')->whereAddressType(1)->whereActiveAddress(1)->orderByDesc('id');
    }



    public function LastCommunicationUserAddress()
    {
        return $this->hasOne('App\UserAddress', 'user_id')->whereAddressType(2)->orderByDesc('id');
    }
    public function ActiveProfessionalAddress()
    {
        return $this->hasOne('App\UserAddress', 'user_id')->whereAddressType(3)->whereActiveAddress(1);
    }
    public function Applications()
    {
        return $this->hasMany('App\ApplicationMaster', 'user_id')->where('status', '!=', 9)->where('status', '!=', 8)->where('status', '!=', 10);
    }
    public function ProvisionalApplication()
    {
        return $this->hasOne('App\ApplicationMaster', 'user_id')->where('application_type', '=', 1)->orderBy('id');
    }
    public function ActiveProvisionalApplication()
    {
        return $this->hasOne('App\ApplicationMaster', 'user_id')->where('application_type', '=', 1)->whereNotNull('provisional_certificate_no')->orderBy('id');
    }

    public function LastApprovedPermanentApplication()
    {
        return $this->hasOne('App\ApplicationMaster', 'user_id')->whereIn('application_type', [2, 3, 4, 6, 8])->whereStatus(6)->latest();
    }

    public function LastApprovedApplication()
    {
        return $this->hasOne('App\ApplicationMaster', 'user_id')->whereStatus(6)->latest();
    }
    public function UserQualifications()
    {
        return $this->hasMany('App\UserQualifications', 'user_id')->orderByDesc('id');
    }
    public function ApprovedUserQualifications()
    {

        return $this->hasMany('App\UserQualifications', 'user_id')->where('status', 7)->orderByDesc('id');
    }

    public function UserVeterinaryQualifications()
    {
        return $this->hasMany('App\UserQualifications', 'user_id')->where('qualification_type', '!=', 0)->orderByDesc('id');
    }
    public function UserOtherQualifications()
    {
        return $this->hasMany('App\UserQualifications', 'user_id')->where('qualification_type', '=', 0)->orderByDesc('id');
    }
    public function ElectionUserSettings()
    {
        return $this->hasMany('App\ElectionUserSettings', 'user_id');
    }
    public function UserType()
    {
        return $this->belongsTo('App\UserType', 'user_type');
    }
    public function PollingStation()
    {
        return $this->belongsTo('App\PollingStation');
    }
    public function Notifications()
    {
        return $this->hasMany('App\Notifications', 'user_id');
    }
    public function UserRoles()
    {
        return $this->hasMany('App\User_Role', 'user_id');
    }
    public function Roles()
    {
        return $this->belongsToMany('App\Roles', 'user_role', 'user_id', 'role_id');
    }
    public function VeterinaryMaster()
    {
        return $this->hasOne('App\VeterinaryMaster', 'user_id')->where('is_active', 1);
    }
    public function VeterinaryRegister()
    {
        return $this->hasOne('App\VeterinaryRegister', 'user_id');
    }
    public function ApprovedUserTrainees()
    {
        return $this->hasOne('App\UserTrainings', 'user_id')->where('training_user_status', '=', 2);
    }

    public function ShortlistedJobs()
    {
        return $this->hasMany(Recruitment::class, 'candidate_id');
    }
}
