<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasFactory;
    public function Block()
    {
        return $this->belongsTo(Block::class, 'block_id');
    }

    public function ProfileStatus()
    {
        return $this->belongsTo(Status::class, 'profile_status');
    }

    public function CourseCompletionStatus()
    {
        return $this->belongsTo(Status::class, 'course_completion_status');
    }

    public function Sector()
    {
        return $this->belongsTo(Sector::class, 'sector_id');
    }

    public function EmployerJobApplications()
    {
        return $this->hasManyThrough(JobApplication::class, JobVacancy::class);
    }

    public function District()
    {
        return $this->belongsTo(District::class, 'district_id');
    }

    public function Country()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }

    public function State()
    {
        return $this->belongsTo(State::class, 'state_id');
    }

    public function Piaid()
    {
        return $this->hasOne(ProgramImplementationAgency::class, 'user_id');
    }

    public function Training()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }
    public function CourseMasterName()
    {
        return $this->belongsTo(CourseMaster::class, 'course_master_id');
    }
    public function LocalBodyGet()
    {
        return $this->belongsTo(Localbody::class, 'localbody_id');
    }

    public function localbodytypes()
    {
        return $this->belongsTo(Localbodytype::class, 'lbTypeid');
    }

    public function JobApplications()
    {
        return $this->hasMany(JobApplication::class, 'candidate_id');
    }

    public function CandidateCount()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }

    public function Recruitment()
    {
        return $this->hasOne(Recruitment::class, 'candidate_id');
    }

    public function ShortlistedJobs()
    {
        return $this->hasMany(Recruitment::class, 'candidate_id');
    }

}
