<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProgramImplementationAgency extends Model
{
    use HasFactory;

    public function Block()
    {
        return $this->belongsTo(Block::class, 'block_id');
    }

    public function District()
    {
        return $this->belongsTo(District::class, 'district_id');
    }
   

    public function State()
    {
        return $this->belongsTo(State::class, 'state_id');
    }

    public function Country()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }

    public function User()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function Courses()
    {
        return $this->hasMany(Course::class, 'pia_id');
    }

    public function Sectors()
    {
        return $this->hasMany(PiaSector::class, 'program_implementation_agency_id');
    }
    public function Sector_names()
    {
        $sector_list = [];
        foreach ($this->Sectors as $sector_each) {
            $sector_list[] = $sector_each->sector->name;
        }
        return implode(", ", $sector_list);
    }
    
    public function trades()
    {
        return $this->hasMany(PiaTrade::class, 'pia_id'); 
    }
    public function assignedCourses()
    {
        return $this->belongsToMany(CourseMaster::class, 'pia_trades', 'pia_id', 'trade_id');
    }
    public function Trade_names()
    {
        $trade_list = [];
        
        
        foreach ($this->trades as $trade_each) {
          
            if ($trade_each->courseMaster) {
                $trade_list[] = $trade_each->courseMaster->tradename;
            }
        }
        
        return implode(", ", $trade_list);
    }
    

}
