<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PiaTrade extends Model
{
    use HasFactory;

    protected $fillable = ['pia_id', 'sector_id', 'trade_id'];

    // Relationships
    public function pia()
    {
        return $this->belongsTo(ProgramImplementationAgency::class,'pia_id');
    }

    public function sector()
    {
        return $this->belongsTo(Sector::class,'sector_id');
    }

    public function courseMaster()
    {
        return $this->belongsTo(CourseMaster::class, 'trade_id');
    }
    

}