<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobApplication extends Model
{
    use HasFactory;

    public function Job()
    {
        return $this->belongsTo(JobVacancy::class, 'job_id');
    }

    public function Candidate()
    {
        return $this->belongsTo(User::class, 'candidate_id');
    }

    public function EmployerNotification()
    {
        return $this->hasMany(Notification::class)->where('user_type', 5);
    }

    public function CandidateNotification()
    {
        return $this->hasMany(Notification::class)->where('user_type', 6);
    }
}
