<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;
use App\Models\Country;
use App\Models\State;
use App\Models\District;

class EmployerDetailsUpdationRequest extends Model
{
    use HasFactory;

    public function Employer()
    {
        return $this->belongsTo(User::class, 'employer_id');
    }

    public function Pia()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function Country()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }

    public function State()
    {
        return $this->belongsTo(State::class, 'state_id');
    }

    public function District()
    {
        return $this->belongsTo(District::class, 'district_id');
    }


}
