<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CourseMaster extends Model
{
    use HasFactory;

    public static function getCourseById($courseId)
    {
        return self::where('id', $courseId)->first();
    }
    public function Sector()
    {
        return $this->belongsTo(Sector::class, 'sector_id');
    }
    public function Candidates()
    {
        return $this->belongsToMany(CandidateInterest::class, 'canadidate_interest_course_masters', 'course_master_id', 'candidate_interest_id');
    }

    public static function samplePaginate($perPage = 10)
    {
        return self::paginate($perPage);
    }

    public function Courses()
    {
        return $this->hasMany(Course::class, 'coursemaster_id');
    }
    public function trades()
    {
        return $this->hasMany(PiaTrade::class,  'trade_id');
    }
}
