<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Course extends Model
{
    use HasFactory;

    public static function getTrainingById($trainingId)
    {
    return self::where('id', $trainingId)->first();
    }

    public function GetSector()
    {
        return $this->belongsTo(Sector::class, 'sector_id');
    }

    public function GetPIA()
    {
        return $this->belongsTo(ProgramImplementationAgency::class, 'PIA_id');
    }

    public function Pia()
    {
        return $this->belongsTo(ProgramImplementationAgency::class, 'pia_id');
    }

    public function GetDistrict()
    {
        return $this->belongsTo(District::class, 'district_id');
    }

    public function GetLocalBody()
    {
        return $this->belongsTo(Localbody::class, 'localbody_id');
    }

    public function GetBlock()
    {
        return $this->belongsTo(Block::class, 'block_id');
    }

    public function GetCourseMaster()
    {
        return $this->belongsTo(CourseMaster::class, 'coursemaster_id');
    }

    public function SkillList()
    {
        return $this->hasMany(CourseSkillMapping::class,'course_id');
    }
    
    public function Skils()
    {
        return $this->belongsTo(Skill::class, 'id');
    } 
    public function District()
    {
        return $this->belongsTo(District::class, 'id');
    }
    public function Sector()
    {
        return $this->belongsTo(Sector::class, 'id');
    }
     public function ProgramImplementationAgency()
    {
        return $this->belongsTo(ProgramImplementationAgency::class, 'pia_id');
    }
    

   

  
}