<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CandidateInterest extends Model
{
    use HasFactory;
    protected $fillable = [
       'training_program_id', 'name', 'email','dob','gender','additional_certificates','religion','category','pwd','rationcardtype','MGNREGA','kudumbashree_member','district_id','status','willingTojoin','block_id','localbodyid','lbtypeid','mobile_Number','highest_qualification','building_name','landmark','postOffice','pincode' // Add other fields here
    ];
    public function Courses()
    {
        return $this->belongsToMany(CourseMaster::class, 'canadidate_interest_course_masters', 'candidate_interest_id', 'course_master_id');
    }

    public function CandidateInterests()
    {
        return $this->hasMany(CanadidateInterestCourseMaster::class, 'candidate_interest_id');
    }


    public function District()
    {
        return $this->belongsTo(District::class, 'district_id');
    }

    public function Block()
    {
        return $this->belongsTo(Block::class, 'block_id');
    }
    public function LocalBType()
    {
        return $this->belongsTo(Localbodytype::class, 'lbtypeid');
    }
    public function Localbody()
    {
        return $this->belongsTo(Localbody::class, 'localbodyid');
    }

}
