<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class CandidateJobNotification extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */

     public $candidate_name; 

     public $employer;

     public $emp_addr;

     public $emp_mail;

     public $emp_phone;

     public $job;

     public $job_loc;

     public $salary;

     public $qualification;

     public $job_desc;

     public $msg_to_can;

     
     

    public function __construct($candidate_name, $employer, $emp_addr, $emp_mail, $emp_phone, $job, $job_loc, $salary, $qualification, $job_desc, $msg_to_can )
    {
        $this->candidate_name = $candidate_name;
        $this->employer = $employer;
        $this->emp_addr = $emp_addr;
        $this->emp_mail = $emp_mail;
        $this->emp_phone = $emp_phone;
        $this->job = $job;
        $this->job_loc = $job_loc;
        $this->salary = $salary;
        $this->qualification = $qualification;
        $this->job_desc = $job_desc;
        $this->msg_to_can = $msg_to_can;

    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */
    public function envelope()
    {
        return new Envelope(
            subject: 'Job Opportunity via Talento Connect',
        );
    }

    /**
     * Get the message content definition.
     *
     * @return \Illuminate\Mail\Mailables\Content
     */
    public function content()
    {
        return new Content(
            view: 'mails.job_notification',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array
     */
    public function attachments()
    {
        return [];
    }
}
