<?php

namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Database\QueryException;
use Carbon\Carbon;
use App\Models\District;
use App\Models\CourseMaster;
use App\Models\Block;
use App\Models\Localbody;
use App\Models\Localbodytype;
use App\Models\CandidateInterest;
use App\Models\CanadidateInterestCourseMaster;
use App\Rules\ReCaptcha;
use App\Models\Course;
use App\Mail\CandidateInterestNotificationToPia;
use Illuminate\Support\Facades\Mail;

class RequestInterest extends Controller
{
    //
    /* public function showForm()
     {
         return view('Public_site.pages.CourseDetList');
     }*/

    public function ViewRequestForm(Request $request)
    {

        if ($request->session()->has('course_masters')) {
            $selected_course_masters = $request->session()->get('course_masters');
        } else {

            $selected_course_masters = array();
        }

        // $course = $request->input('arrayValue');dd($request->input('arrayValue',));
        $course = $selected_course_masters;
        $defaultDate = Carbon::now()->subYears(18);
        $formattedDefaultDate = $defaultDate->format('d-m-Y');


        if (count($course) > 3) {


            $validator = "We are not supposed to select more than 3 courses";


            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        } else {

            list($max_day, $max_month, $max_year) = explode("-", $formattedDefaultDate);

            // dd($course);
            $data['course'] = CourseMaster::whereIn('id', $course)->orderByDesc('tradename')->get();
            $data['district'] = District::where('id', '!=', 1000)->get();

            $data['LocalBodyTypes'] = LocalBodyType::where('id', 1)->get();



            return view('Public_site.pages.RequestInterest', compact('data', 'formattedDefaultDate', 'max_year'));
        }
    }
    public function getBlocks(Request $request, $DistrictID)
    {
        $data['block'] = Block::all();
        if ($DistrictID != null) {
            $Districtid = $request->input('DistrictID');
        }
        // dd($Districtid);
        return response()->json([
            'data' => Block::whereDistrictId($Districtid)->orderBy('name')->get()
        ], 200);
    }
    public function getLocalBodyByDistrict(Request $request, $DistrictID)
    {
        // $data['block'] = Block::all();
        if ($DistrictID != null) {
            $Districtid = $request->input('DistrictID');
            $LBTID = $request->input('LBT');
        }
        // dd($Districtid);
        return response()->json([
            'data' => Localbody::where('district_id', $Districtid)->where('lb_type_id', $LBTID)
                ->orderBy('name_eng')
                ->get()
        ], 200);
        //return response()->json(['DistrictID' => $DistrictID, 'LBTID' => $LBTID]);

    }
    public function getLocalBodyByDistrictBlock(Request $request, $DistrictID)
    {
        if ($DistrictID != null) {
            $Districtid = $request->input('DistrictID');
            $LBTID = $request->input('LBT');
            $blockID = $request->input('blockID');
        }
        // dd($Districtid);
        return response()->json([
            'data' => Localbody::where('district_id', $Districtid)
                ->where('lb_type_id', $LBTID)
                ->where('block_id,$blockID')
                ->orderBy('name_eng')
                ->get()
        ], 200);
    }
    public function SubmitInterest(Request $request)
    {

        $input = $request->all();

        if (is_null($input['g-recaptcha-response'])) {
            $response['status'] = "error";
            $response['message'] = "No Captcha";
            $response['developer_message'] = "has";

            return response()->json($response)->setStatusCode(422);
        }






        // $validator=Validator::make($request->all(),['g-recaptcha-response' => 'required','pwd' => 'required',]);
        /*/
        if ($validator->fails()) {
            $response['status'] = "error";
            $response['message'] = implode(",", $validator->errors()->all());
            $response['developer_message'] = implode(",", $validator->errors()->all());
    }*/


        //dd($request->all());
        // Define validation rules
        //print_r($request->all());
        if ($request->ajax()) {
            \Log::info('AJAX Request Data:', $request->all());
        } else {
            \Log::info('Non-AJAX Request Data:', $request->all());
        }

        $rules = [
            'candidatename' => 'required|string|min:1|max:50',
            'email' => 'required|email|max:225|unique:candidate_interests,email|min:1|max:50',
            'mobileNumber' => 'required|regex:/^[0-9]{10}$/|min:1|max:10',
            'dob' => 'required',
            'gender' => 'required',
            'BuildingName' => 'required|string|min:1|max:50',
            'Landmark' => 'required|string|min:1|max:50',
            'PostOffice' => 'required|string|min:1|max:25',
            'category' => 'required',
            'mgnrega' => 'required',
            'district' => 'required',
            'pwd' => 'required',
            'rationCard' => 'required',
            'kudMember' => 'required',
            'courses' => 'required',
            'hQualification' => 'required',
            'PIN_Code' => 'required|regex:/^\d{6}$/',
        ];
        // Define custom error messages
        $messages = [
            'candidatename.required' => 'The name field is required.',
            'email.required' => 'The email field is required.',
            'email.email' => 'Please enter a valid email address.',
            'mobileNumber' => 'Invalid Number',
            'dob' => 'The DOB field is required',
            'hQualification' => 'The Qualification field is required',
            'BuildingName' => 'The building name/number field is required',
            'Landmark' => 'The landmark field is required',
            'PostOffice' => 'The Post office field is required',
            'PIN_Code' => 'The Pincode field is required',
            'gender' => 'The gender field is required',
            'district' => 'The district field is required',
            'mgnrega' => 'The MGNREGA Family status is required',
            'pwd' => 'The pwd field is required',
            'category' => 'The category field is required',
            'rationCard' => 'The rationCard field is required',
            'kudMember' => 'The Kudumbashree Member field is required',
            'courses' => 'The courses field is required',
        ];
        $validator = Validator::make($request->all(), $rules, $messages);
        // $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            $response['status'] = "error";
            $response['message'] = implode(",", $validator->errors()->all());
            $response['developer_message'] = implode(",", $validator->errors()->all());
        }
        if ($request->input('block_list') == '0') {
            $blockValue = 1000;
        } else {
            $blockValue = $request->input('block_list');
        }
        if ($request->input('localbody') == '0') {
            $lbodyvalue = 2000;
        } else {
            $lbodyvalue = $request->input('localbody');
        }
        if ($request->input('lbt') == '0') {
            $lbtypevalue = 1000;
        } else {
            $lbtypevalue = $request->input('lbt');
        }

        $dataToInsert = [
            'name' => $request->input('candidatename'),
            'email' => $request->input('email'),
            'mobile_Number' => $request->input('mobileNumber'),
            'dob' => $request->input('dob'),
            'highest_qualification' => $request->input('hQualification'),
            'gender' => $request->input('gender'),
            'building_name' => $request->input('BuildingName'),
            'landmark' => $request->input('Landmark'),
            'postOffice' => $request->input('PostOffice'),
            'pincode' => $request->input('PIN_Code'),
            'district_id' => $request->input('district'),
            'block_id' => $blockValue,
            'localbodyid' => $lbodyvalue,
            'lbtypeid' => $lbtypevalue,
            'status' => 1,
            'additional_certificates' => $request->input('certificate'),
            'religion' => $request->input('religion'),
            'category' => $request->input('category'),
            'pwd' => $request->input('pwd'),
            'rationcardtype' => $request->input('rationCard'),
            'MGNREGA' => $request->input('mgnrega'),
            'kudumbashree_member' => $request->input('kudMember'),
            'willingTojoin' => $request->input('JoiTocourse'),
            //'coursemaster_id' => $request->input('courses'), // Assuming 'courses' is a field in your model
        ];
        // dd( $dataToInsert);
        //print_r($request->input('courses'));
        $coursemasterid = $request->input('courses');
        \Log::info('Request Data:', $request->all());

        try {

            if ($request->session()->has('training_programs')) {

                $training_programs = $request->session()->get('training_programs');


                if ($training_programs) {

                    foreach ($training_programs as $program) {
                        $training_program = Course::find($program);

                        if ($training_program) {
                            if ($training_program->ProgramImplementationAgency) {

                                $data = [
                                    'name' => $request->input('candidatename'),
                                    'phone' => $request->input('mobileNumber'),
                                    'email' => $request->input('email'),
                                    'training_name' => $training_program->training_name,
                                    'agency' => $training_program->ProgramImplementationAgency
                                ];

                                Mail::to($training_program->ProgramImplementationAgency)->send(new CandidateInterestNotificationToPia((object)$data));
                            }
                        }
                    }
                }


                $dataToInsert['training_program_id'] = json_encode($training_programs);

                $request->session()->forget('training_programs');
            }


            $request->session()->forget('course_masters');
            $candidateInterest = CandidateInterest::create($dataToInsert);
            foreach ($coursemasterid as $CmasterID) {
                $CanadidateInterestCourseMaster = new CanadidateInterestCourseMaster;
                $CanadidateInterestCourseMaster->course_master_id = $CmasterID;
                $CanadidateInterestCourseMaster->candidate_interest_id = $candidateInterest->id;
                $CanadidateInterestCourseMaster->save();
            }
            // $candidateInterest->courses()->attach($coursemasterid);        //dd(candidateInterest);
            $statusValue = "Your request has been submitted successfully! Our PIA will contact you soon. Thank You";
            //return redirect('/CourseRegistration')->with($data);
            //  return view('Public_site.pages.AfterInterest', compact('data'));
            $response['status'] = "success";
            $response['message'] = $statusValue;
            // $response['message'] = $dataToInsert['training_program_id'];
            $response['developer_message'] = "";
            $response['redirect'] = route('CourseList');
            return response()->json($response)->setStatusCode(200);
        } catch (\Illuminate\Database\QueryException $e) {
            // \Log::error('Database error: ' .$e->errorInfo);
            //dd($e->errorInfo);

            if ($e->errorInfo[1] == 1062) {
                // Custom error message for duplicate email
                $customErrorMessage = "The email address is already in use. Please use a different email.";
            } else {
                // Default custom error message
                $customErrorMessage = "The request has not been submitted. Please try after some time." . $e->errorInfo[2];
            }
            //  $customErrorMessage = "The request has not been submitted. Please try after some time.";
            \Log::error($customErrorMessage . " " . json_encode($e->errorInfo));
            // Log the exception for debugging purposes (optional)
            $response['status'] = "error";
            $response['message'] = $customErrorMessage . " ";
            $response['developer_message'] = $e->getMessage();
            $response['error_info'] = $e->errorInfo[2]; // Make sure error_info is set
            return response()->json($response)->setStatusCode(422);
        }
    }
}
