<?php

namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use App\Models\Course;
use App\Models\Localbody;
use App\Models\Sector;
use App\Models\CourseMaster;
use App\Models\Block;
use App\Models\CourseSkillMapping;
use App\Models\Skill;
use App\Models\District;
use App\Models\User;
use App\Models\ProgramImplementationAgency;

class HomeController extends Controller
{
    public function ShowCourse()
    {
       
       $coursestatus = ['1', '23'];
    $data['courses'] = Course::with('GetCourseMaster')  // Eager load the relation
                        ->whereIn('course_status', $coursestatus)
                        ->orderByDesc('created_at')
                        ->limit(9)
                        ->get();

        return view('Public_site.home', compact('data'));
    }
    public function getEmployerListview()
    {
      $data['useres'] = User::where('user_role_id', 5)
                            ->where('status',1)
                            ->orderByDesc('created_at')->get();

        return view('Public_site.pages.employerlist', compact('data'));
    }
    function getEmployerDetails($encryptempID=null)
    {
      
     if (isset($encryptempID)) {
   //   $empID = decrypt($encryptempID);
      $empID = base64_decode($encryptempID);
      $employer = User::find($empID);

      if( $employer)
      {
        return view('Public_site.pages.empoyerDetails', compact('employer'));
      }

      else{

          return redirect()->back();
      }
     
  } else {
    
    return $this->getEmployerListview();
  }

    }
    function getPIAListview()
    {
      $data['pia'] = ProgramImplementationAgency::whereIsActive(1)
                                               ->orderBy('agency_name','asc')->get();

        return view('Public_site.pages.pialist', compact('data'));
    }

    function getpiaDetails($encryptypidID= null)
    {

      
      if (isset($encryptypidID)) {

        //;
     //   $piaID = decrypt($encryptypidID);

        $piaID = base64_decode($encryptypidID);
       
       // $pia = ProgramImplementationAgency::find($piaID);
        $pia = ProgramImplementationAgency::with('trades.courseMaster')->find($piaID);

       

        if($pia)
        {
          return view('Public_site.pages.piaDetails', compact('pia'));
        }

        else{

            return redirect()->back();
        }
       
    } else {
      
      return $this->getPIAListview();
    }

    }
    
}
