<?php


namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;
use App\Models\CourseMaster;
use App\Models\Course;
use App\Models\Skill;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Crypt;

class CourseList extends Controller
{
    ///////////////////Course List/////////////////////////////
    public function CourseListview(Request $request)
    {

        $selected_course_masters_list = array();

        $page = ($request->has('page')) ? $request->page : 0;

        if ($request->session()->has('course_masters')) {

            if (count($request->session()->get('course_masters')) < 3) {
                $course_selectable = true;


            } else {

                $course_selectable = false;




            }

            $selected_course_masters = $request->session()->get('course_masters');

           

            foreach ($selected_course_masters as $scm) {
                $course_master = CourseMaster::find($scm);

                if ($course_master) {
                    array_push($selected_course_masters_list, $course_master);
                }
            }


        } else {

            $course_selectable = true;

            $selected_course_masters = array();


        }
        $Courses = CourseMaster::select(
            'id',
            'tradename',
            'duration',
            'qualification',
            'description'
        )
            ->orderByDesc('id')
            ->where('is_active',1)
            ->get();
        return view('Public_site.pages.CourseList', ['page' => $page, 'Course' => $Courses, 'course_selectable' => $course_selectable, 'selected_course_masters' => $selected_course_masters, 'selected_course_masters_list' => $selected_course_masters_list]);

        /*$Courses = CourseMaster::samplePaginate(10);
         return view('Public_site.pages.CourseList')
         ->with('Course', $Courses);
*/
    }
    ///////////////////Course List/////////////////////////////
    public function CourseDetview(Request $request, $cid = null)
    {

        if (is_null($cid)) {
            return redirect(route('CourseList'));
        }

        $cid = base64_decode($cid);


        if ($request->session()->has('training_programs')) {

            $selected_training_programs = $request->session()->get('training_programs');

        } else {

            $selected_training_programs = [];

        }

        if ($request->session()->has('course_masters')) {

            if (count($request->session()->get('course_masters')) < 3) {

                $training_selectable = true;

            } else {

                $selected_course_masters = $request->session()->get('course_masters');

                if (in_array($cid, $selected_course_masters)) {


                    $training_selectable = true;
                } else {

                    $training_selectable = false;
                }
            }

        } else {

            $training_selectable = true;
        }

        $CourseMaster = CourseMaster::find($cid);

        if (!$CourseMaster) {
            return redirect()->back();
        }


        $Courses = Course::where('coursemaster_id', $cid)->whereIN('course_status',[7,10])->get();


        return view('Public_site.pages.CourseDetails')
            ->with('Course', $Courses)
            ->with('selected_training_programs', $selected_training_programs)
            ->with('training_selectable', $training_selectable)
            ->with('Course_master', $CourseMaster);

    }

    public function addTrainingsToSession(Request $request)
    {


        try {

            $validator = Validator::make($request->all(), ['training_id' => 'required|numeric']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                if ($request->session()->has('training_programs')) {

                    $selected_training_programs = $request->session()->get('training_programs');

                    array_push($selected_training_programs, $request->training_id);

                    $request->session()->put('training_programs', $selected_training_programs);

                    $selected_course_masters = $request->session()->get('course_masters');

                    $training_program = Course::find($request->training_id);

                    if (!in_array($training_program->GetCourseMaster->id, $selected_course_masters)) {

                        array_push($selected_course_masters, $training_program->GetCourseMaster->id);

                    }

                } else {


                    $selected_training_programs = array();
                    array_push($selected_training_programs, $request->training_id);
                    $request->session()->put('training_programs', $selected_training_programs);


                    if ($request->session()->has('course_masters')) {

                        $selected_course_masters = $request->session()->get('course_masters');


                    } else {

                        $selected_course_masters = array();
                    }

                    $training_program = Course::find($request->training_id);

                    if (!in_array($training_program->GetCourseMaster->id, $selected_course_masters)) {

                        array_push($selected_course_masters, $training_program->GetCourseMaster->id);

                    }






                }

                $request->session()->put('course_masters', $selected_course_masters);

                //   $request->session()->put('course_masters',$selected_course_masters);
                //  $request->session()->put('course_masters',$selected_course_masters);
                $response['se'] = $request->session()->get('course_masters');

                $response['status'] = "success";


            }





        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);



    }

    public function removeTrainingsFromSessions(Request $request)
    {

        try {

            $validator = Validator::make($request->all(), ['training_id' => 'required|numeric']);

            if ($validator->fails()) {

                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());

            } else {

                if ($request->session()->has('course_masters')) {
                    $selected_course_masters = $request->session()->get('course_masters');

                } else {

                    $selected_course_masters = [];
                }


                $selected_training_programs = $request->session()->get('training_programs');
                $key = array_search($request->training_id, $selected_training_programs);

                unset($selected_training_programs[$key]);

                $training_program = Course::find($request->training_id);

                $remove_course_master = 1;

                foreach ($training_program->GetCourseMaster->Courses as $training) {

                    if (in_array($training->id, $selected_training_programs)) {
                        $remove_course_master = 0;
                    }

                }

                if ($remove_course_master == 1) {

                    $key = array_search($training_program->GetCourseMaster->id, $selected_course_masters);

                    unset($selected_course_masters[$key]);

                    $request->session()->put('course_masters', $selected_course_masters);

                }

                $request->session()->put('training_programs', $selected_training_programs);

                $response['status'] = "success";


            }


        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage() . " in " . $e->getLine();

        }

        return response()->json($response);



    }

    public function addCourseMasterToSession(Request $request)
    {

        try {

            $validator = Validator::make($request->all(), ['course_master_id' => 'required|numeric']);

            if ($validator->fails()) {

                $response['status'] = "error";
                $response['developer_message'] = implode(",", $validator->errors()->all());

            } else {

                if ($request->session()->has('course_masters')) {
                    $selected_course_masters = $request->session()->get('course_masters');
                } else {

                    $selected_course_masters = array();
                }

                array_push($selected_course_masters, $request->course_master_id);

                $request->session()->put('course_masters', $selected_course_masters);

                $response['status'] = "success";


            }


        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['developer_message'] = $e->getMessage();
            $response['message'] = "Something went wrong";

        }

        return response()->json($response);

    }

    public function removeCourseMasterFromSession(Request $request)
    {

        try {

            $validator = Validator::make($request->all(), ['course_master_id' => 'required|numeric|exists:course_masters,id']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());

            } else {

                $course_master = CourseMaster::find($request->course_master_id);

                if ($request->session()->has('training_programs')) {

                    $selected_training_programs = $request->session()->get('training_programs');
                    foreach ($course_master->Courses as $training) {

                        if (in_array($training->id, $selected_training_programs)) {
                            $key = array_search($training->id, $selected_training_programs);

                            unset($selected_training_programs[$key]);
                        }

                    }

                    $request->session()->put('training_programs', $selected_training_programs);
                }

                $selected_course_masters = $request->session()->get('course_masters');

                $key = array_search($request->course_master_id, $selected_course_masters);

                unset($selected_course_masters[$key]);

                $request->session()->put('course_masters', $selected_course_masters);

                $response['status'] = "success";


            }


        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }


}
