<?php

namespace App\Http\Controllers\Pia;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Course;
use App\Models\ProgramImplementationAgency;
class PiaController extends Controller
{
    public function dashboard(Request $request)
    {
        

      $data['trainigs'] = Course::leftJoin('users', function($join) {
        $join->on('courses.id', '=', 'users.course_id')
             ->where('users.user_role_id', '=', 6)
             ->where('users.profile_status', '=', 2);
    })->leftJoin('program_implementation_agencies', function($join) {
        $join->on('courses.pia_id', '=', 'program_implementation_agencies.id')
             ->where('program_implementation_agencies.is_active', '=', 1);
    })
    ->select(
        'courses.id', 
        'courses.training_name', 
        'courses.end_date', 
        'program_implementation_agencies.user_id', 
        Course::raw('COUNT(users.id) as total_students')
    )
    ->where('program_implementation_agencies.user_id', '=', auth()->user()->id)
    ->where('courses.course_status', '=', 7)
    ->groupBy(
        'courses.id', 
        'courses.training_name', 
        'courses.end_date', 
        'program_implementation_agencies.user_id'
    )
    ->orderBy('courses.id', 'DESC')
    ->get();


        return view("pia.pages.dashboard", ["data"=>$data]);
    }

    public function profile()
    {
      if( ! $pia_agency = ProgramImplementationAgency::where( 'program_implementation_agencies.user_id', '=', auth()->user()->id )->first() ){
        $pia_agency = array();
      }
      return view("pia.pages.profile", compact('pia_agency'));
    }


}
