<?php

namespace App\Http\Controllers\Pia;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\CandidateInterest;
use App\Models\CanadidateInterestCourseMaster;
use App\Models\Course;
use App\Models\Sector;
use App\Models\PiaSector;
use App\Models\User;
use App\Models\CourseMaster;
use App\Models\Country;
use App\Models\ProgramImplementationAgency;
use App\Models\District;
use App\Models\Block;
use App\Models\Localbody;
use App\Models\Localbodytype;
use App\Models\Status;
use App\Models\Recruitment;
use App\Models\Notification;
use App\Models\JobVacancy;
use App\Models\JobApplication;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use App\Mail\CandidateRegistration;
use App\Mail\CandidateCredentials;
use App\Mail\CandidateDiscontinue;
use App\Mail\CandidateCompleted;
use App\Mail\CandidatePlacedbyPia;
use Mail;


class CandidateInterestController extends Controller
{
    public function candidateInterestList()
    {
        $defaultDate = Carbon::now()->subYears(18);
        $formattedDefaultDate = $defaultDate->format('d-m-Y');
        list($max_day, $max_month, $max_year) = explode("-", $defaultDate);
        $distrcitid=    Auth::user()->district_id; 
        $jobs   =   JobVacancy::where('is_active', 1)->get();
       // $candidates =   CandidateInterest::where('status', 1)->get();
       $candidates = CandidateInterest::select('candidate_interests.*', DB::raw('(SELECT GROUP_CONCAT(course_master_id) FROM canadidate_interest_course_masters WHERE candidate_interest_id = candidate_interests.id) as master_ids'))
       ->where('candidate_interests.status', 1)
       ->get();
   

        $training   =   Course::where('pia_id', auth()->user()->Piaid->id)->get();
        $sectors   =   PiaSector::where('program_implementation_agency_id', auth()->user()->Piaid->id)->pluck('sector_id');
        $masters   =   CourseMaster::whereIn('sector_id', $sectors)->where('is_active', true)->pluck('id');
        $piaid= auth()->user()->Piaid->id;
        // $candidates=    CandidateInterest::where('status', 1)->where('district_id',$distrcitid)->get();
        $districts = District::all();
        //   dd($Districts);
        return view('pia.pages.CandidateInterestList')
        ->with('piaid', $piaid)->with('masters', $masters)->with('candidates', $candidates)->with('jobs', $jobs)->with('training', $training)->with('districts', $districts)->with('distrcitid', $distrcitid)->with('formattedDefaultDate', $formattedDefaultDate, 'max_year' );
    }

    public function candidateInterestJoinedList()
    {
        $defaultDate = Carbon::now()->subYears(18)->format('d-m-Y');
        list($max_day, $max_month, $max_year) = explode("-", $defaultDate);
        $distrcitid = Auth::user()->district_id;
        $role = 6;
        $candidates = User::where('profile_status', '!=', 6)->where('user_role_id', $role)->
        where('created_by', auth()->user()->Piaid->id)->get();
        return view('pia.pages.CandidateInterestJoinedList')
            ->with('candidates', $candidates)->with('max_year', $max_year);
    }


    public function candidateInterestJoinedListDet($cid)
    {
        $cid = base64_decode($cid);
        $Candidate = User::find($cid);
      
        $empname="";
        if($Candidate->employer_id){
            $empname =  User::find($Candidate->employer_id);
       }
        $emplist = DB::table('users')->where('user_role_id', 5)->where('status', 1)->orWhere('profile_status', 14)->get();
      // print_r($emplist);
        $statuses = Status::all();
        $jobs=    JobVacancy::where('is_active', 1)->get();
        $data['country'] = Country::all();
        return view('pia.pages.InterestJoinedView', compact('empname','data','jobs','Candidate', 'emplist','statuses'));
    }

    public function candidateInterestListDet($cid)
    {
        $cid = base64_decode($cid);

        $defaultDate = Carbon::now()->subYears(18)->format('d-m-Y');
        list($max_day, $max_month, $max_year) = explode("-", $defaultDate);
        $statuses = Status::all();
        $Country = Country::all();
        $training= Course::all();//where('pia_id', auth()->user()->Piaid->id)
        //->get();
//dd($training);
        $Candidate = CandidateInterest::find($cid);
        $Courses = CanadidateInterestCourseMaster::where('candidate_interest_id', $cid)->get();
       // $Courselist = CourseMaster::whereIsActive('1')->get();
        $sectors   =   PiaSector::where('program_implementation_agency_id', auth()->user()->Piaid->id)->pluck('sector_id');
        $Courselist   =   CourseMaster::whereIn('sector_id', $sectors)->where('is_active', true)->get();
       
        return view('pia.pages.InterestView', compact('Country','statuses','Candidate', 'Courses', 'Courselist', 'defaultDate', 'max_year','training'));

    }

    public function CheckSeatsCount(Request $request)
    {



        try {
            $cid = $request->input('cid');
            $trainingid = $request->input('course');
            $category = $request->input('category');

            $training = Course::find($trainingid);
            $pr = "NoProceed";
            if ($category == "General") {
                $gseats = $training->general_seats - $training->general_seats_filled;
                if ($gseats > 0) {
                    $pr = "Proceed";


                }
            } else if ($category == "SCST") {
                $SCSTseats = $training->scst_seats - $training->scst_seats_filled;
                if ($SCSTseats > 0) {
                    $pr = "Proceed";

                }
            } else {
                $mseats = $training->minority_seats - $training->minority_seats_filled;
                if ($mseats > 0) {
                    $pr = "Proceed";
                }
            }
            if ($pr != "Proceed") {
                $response['error'] = 'Sorry,No more seats available for this selected Training';
                return response()->json($response);

            } else {
                $response['success'] = '';
                return response()->json($response);
            }
            // Continue with the rest of your logic...
        } catch (\Exception $e) {
            // Log the exception message

            //  $response['error']=$e->getMessage();
            \Log::error($e->getMessage());


        }

    }


    public function loadJobs(Request $request)
    { $empid=  $request->input('empid');
           
            $jobs=    JobVacancy::where('is_active', 1)    
                ->where('employer_id', $empid)->get();
            // dd( $request->master);          
            $response['status'] = "success";
            $response['message'] = "";
            $response['jobs'] = $jobs;
            return response()->json($response);
    }

    public function loadTrainings(Request $request)
    {
        $validator = Validator::make($request->all(), ['master' => 'required|numeric|exists:course_masters,id']);

        if ($validator->fails()) {
            $response['status'] = "error";
            $response['message'] = implode(",", $validator->errors()->all());
        } else {

            $training = Course::where('coursemaster_id', $request->master)
                ->where('pia_id', auth()->user()->Piaid->id)
                ->get();
            // dd( $request->master);          
            $response['status'] = "success";
            $response['message'] = "";
            $response['training'] = $training;
            return response()->json($response);


        }

    }

    public function AlreadyExistEmail(Request $req)
    {
        $emailpresent = User::where('email', $req->input('email'))->first();
        //dd($emailpresent);
        if ($emailpresent) {
            $response['status'] = "exists";
            $response['message'] = "'{$req->input('email')}' already exists.";
        } else {
            $response['status'] = "success";

            $response['message'] = "";
        }
        return response()->json($response);
    }
    public function AlreadyExist_Email($email)
    {
        $emailpresent = User::where('email', $email)->first();
       return $emailpresent;
    }

    public function candidate_ChangeStatus(Request $req)
    {
        $msg_to_can = $req->input('msg_to_can');

        try {
            if ($req->input('course_completion_status')!=3) {  
                    
                $rules = [
                    'msg_to_can' => 'required'
                ];
                
            }
            if ($req->input('course_completion_status')=='') {  
                    
                $rules = [
                    'Candiadate status' => 'required'
                ];
                
            }
            if ($req->input('course_completion_status')==6) {  
                    
                $rules = [
                      ];
                
            }
        if ($req->input('course_completion_status')==3) {  
                    
            $rules = [
                'attachment' => 'required|mimetypes:application/pdf,application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document|max:2000',
            ];
            
        }
        if ($req->input('course_completion_status')==5) {  
                    
            if ($req->input('emp')==1) {/// exist employer
                $rules = [
                            'empid' => 'required',
                            'job' => 'required',
                            'jlocation' => 'required|string' ,
                            'fplacement' => 'required',
                            'salary' => 'required',
                            'jdate' => 'required'                           
                              ];
        
                              if ($req->input('fplacement')=='Yes') {/// exist employer
                                $rules = ['country' => 'required' ];
                              }

                                
            }else{
                $rules = [
                    'employer_name' => 'required|string',
                    'pan_number' => 'required',
                    'njob' => 'required|string' ,
                    'njlocation' => 'required|string' ,
                    'nfplacement' => 'required' ,
                    'category' => 'required' ,
                    'nsalary' => 'required' 
                    
                    ];
                    if ($req->input('nfplacement')=='Yes') {/// exist employer
                        $rules = ['ncountry' => 'required' ];
                      }

            }
         }
            $validator = Validator::make($req->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());               
                $response['redirect'] = route('candidateInterestJoinedList');
                return response()->json($response)->setStatusCode(422);
            } else {

                if ($req->hasFile('attachment')) {
                    $attachment = date('Y-M-d-H-h-h-i-s-a') . rand(1000, 9999) . "." . $req->file('attachment')->getClientOriginalExtension();
                    $req->file('attachment')->storeAs("cvupload", $attachment, "public");
            }               
            $cid = $req->input('cid');
            $msg_to_can = $req->input('msg_to_can');
            
            $course_completion_status = $req->input('course_completion_status');
            
            if($course_completion_status == 16) { // resigned
                
                $user= user::find($cid);
                $user->placement_status = 16;
                $user->profile_status = 4;
                $user->updated_by =  auth()->user()->Piaid->id;                
                $user->updated_at = now();
                $user->save();

               $recruitment= Recruitment::where("employer_id","=",$user->employer_id)->where('candidate_id','=',$cid)->first();
                $recruitment->recruitment_status = 16;
                $recruitment->updated_at = now();
                $recruitment->save();
             

                $notification = new Notification();
                $notification->title = "Job Application Update";
                $notification->description = $msg_to_can;
                $notification->candidate_id = $cid;
                $notification->notification_type = "job_application_update";
                $notification->job_id = $recruitment->job_id;
                $notification->save();

            }

             if ($course_completion_status == 17) { //terminated
                
                $user= user::find($cid);
                $user->placement_status = 17;
                $user->profile_status = 4;                
                $user->updated_by =  auth()->user()->Piaid->id;
                $user->updated_at = now();
                $user->save();

                $recruitment= Recruitment::where("employer_id","=",$user->employer_id)->where('candidate_id','=',$cid)->first();
                $recruitment->recruitment_status = 17;
                $recruitment->updated_at = now();
                $recruitment->save();
                
                $notification = new Notification();
                $notification->title = "Job Application Update";
                $notification->description = $msg_to_can;
                $notification->candidate_id = $cid;
                $notification->notification_type = "job_application_update";
                $notification->job_id = $recruitment->job_id;
                $notification->save();
            }
           
            if($course_completion_status==6){
                 //discontinue

                 $user= user::find($cid);
                 $user->profile_status = 6;               
                 $user->status = 6;
                // $user->course_completion_status_date = now();  
                 $user->updated_at = now();                 
                 $user->updated_by =  auth()->user()->Piaid->id;
                 $user->save();   
                $recruitment= Recruitment::where("employer_id","=",$user->employer_id)->where('candidate_id','=',$cid)->first();
               
                

                $trainingid = $user->course_id;
                $category = $user->category;
    
                $training = Course::find($trainingid);
              
                if($category == "General") {
                   // $training->general_seats = $training->general_seats+1;
                    $training->general_seats_filled = $training->general_seats_filled-1;
                    $training->no_of_seats_filled= $training->no_of_seats_filled-1;
                }
              
                if($category == "ST" || $category == "SC") {
                    //$training->scst_seats = $training->scst_seats+1; 
                    $training->scst_seats_filled = $training->scst_seats_filled-1;
                    $training->no_of_seats_filled= $training->no_of_seats_filled-1;
                } 
                if($category == "Minority"){
                  //  $training->minority_seats = $training->minority_seats+1;
                    $training->minority_seats_filled= $training->minority_seats_filled-1;
                    $training->no_of_seats_filled= $training->no_of_seats_filled-1;
                }
               // $training->no_of_seats= $training->no_of_seats+1;
              
                $training->save();
               
              // dd($user->email);
                Mail::to($user->email)->send(new CandidateDiscontinue($user->name,$msg_to_can));

            }

            if($course_completion_status==3){
                //Completed
                $user= user::find($cid);
                $user->profile_status = 3;
                $user->status = 1;
                $user->course_completion_status = 3;
                $user->course_completion_status_date = now();
                
                $user->updated_by =  auth()->user()->Piaid->id;
                $password = "KtcUser*" . rand(999999, 000000)."*";
                        
                $user->password = Hash::make($password);

                if (isset($attachment)) {
                    $user->document_upload = $attachment;
                }
                $user->save();

                $training = Course::find($user->course_id);
              
                Mail::to($user->email)->send(new CandidateCompleted($user, $training->training_name,$password));


            }
            if($course_completion_status==5){
                //placed
               
                $emp = $req->input('emp');
                if($emp==2){
                    $useremp = new User();
                    $useremp->name =$req->input('employer_name');
                    $useremp->pan_number =$req->input('pan_number');
                    $useremp->category =$req->input('category');
                    $useremp->user_role_id =5;
                    $useremp->password = "No Login";
                    $useremp->email =$req->input('nemail');
                    $useremp->profile_status =14;
                    $chkemail = $this->AlreadyExist_Email($useremp->email);
                 if( $chkemail){  
                    $response['status'] = "exists";
                    $response['message'] = "'{$useremp->email}' already exists.";
                    return response()->json( $response, 400);
                 }
                 if($req->input('nfplacement')=='Yes'){
                    $useremp->country_id =$req->input('ncountry');
                }else{
                    $useremp->country_id =1;
                }
                    $useremp->state_id =1000;
                    $useremp->district_id =1000;
                    $useremp->block_id =1000;
                    $useremp->localbody_id =2000;
                    $useremp->lbTypeid =1000;
                    $useremp->status =14;
                    $useremp->created_by =  auth()->user()->Piaid->id;
                    $useremp->updated_by =  auth()->user()->Piaid->id;
                    $useremp->save();

                    // Now you can get the insert ID
                    $insertedId = $useremp->id;

                    $user= user::find($cid);
                    $user->profile_status = 5;
                    $user->status = 1;
                    //$user->course_completion_status_date = now();
                    $user->placed_at = now();
                    $user->placement_status = 5;
                    $user->employer_id = $insertedId;
                    $user->updated_at = now();
                    $user->updated_by = auth()->user()->Piaid->id;
                    $user->save();
                    ////jobentry 
                    $job = new JobVacancy();
                    $job->employer_id = $insertedId;
                    $job->name =$req->input('njob');
                    $job->code = 'code';
                    $job->location =$req->input('njlocation');
                    $job->salary =$req->input('nsalary');
                    $job->qualification = 'Nill';
                    //$job->skill = 'Nill';
                    $job->description ='Added by PIA';
                    $job->created_at =now();
                    $job->is_active =1;
                    $job->save();
                    $insertedJId = $job->id;

                    //$query = Recruitment::query();
                    //$query->where('recruitment_status', 15)->where('candidate_id', '=',$cid);//shortlist
                    $toreject = Recruitment::select('recruitment_status')->whereCandidateId($cid)->whereRecruitmentStatus(15)->update(['recruitment_status' => 9]);
                    $toreject_msg = Recruitment::select('remarks')->whereCandidateId($cid)->whereRecruitmentStatus(9)->update(['remarks' => "Due to the candidate's placement in another job opportunity, this application is denied."]);
        
                    //$recshortlist = $query->get();
                    //$recshortlist->recruitment_status =18;
                    //$recshortlist->save();
                    $rec = new Recruitment();
                    $rec->employer_id = $insertedId;
                    $rec->location =$req->input('njlocation');
                    $rec->candidate_id =$cid;
                    $rec->job_id = $insertedJId;                    
                    $rec->selected_date =$req->input('njdate');
                    $rec->if_foreign =$req->input('nfplacement');
                    $rec->salary =$req->input('nsalary');
                    $rec->recruitment_status =5;
                    $rec->through_candidate = 21;
                    $rec->if_selected = 1;
                    $rec->msg_to_candidate = $msg_to_can;
                    
                    if($req->input('nfplacement')=='Yes'){
                        $rec->country =$req->input('ncountry');
                    }
                    $rec->created_by =  auth()->user()->id;
                    $rec->save();

                    
                $notification = new Notification();
                $notification->title = "Placement Update";
                $notification->description = $msg_to_can;
                $notification->candidate_id = $cid;
                $notification->notification_type = "job_application_update";
                $notification->job_id = $insertedJId;
                $notification->save();

                $can_applied = JobApplication::where("candidate_id","=",$cid)->where("job_id","=",$insertedJId)->first();
                
                if( $can_applied){
                    $can_applied->application_status = "Placed";
                    $can_applied->updated_by = auth()->user()->Piaid->id;
                    $can_applied->placed_at = now();
                    $can_applied->save();
                }
                    
                    $emp = User::where('id','=',$insertedId)->first();
                    $emp_id = $emp->id;
                    $emp_mail = $emp->email;
                    $emp_phone = $emp->mobile_number;
                    if($emp->building_name){
                    $emp_addr = $emp->building_name  . ', ' .  $emp->postOffice . ', ' .  $emp->State->name . '-' .  $emp->pincode;
                    }else{
                        $emp_addr =$req->input('njlocation');;
                    }
                    $can = User::where('id','=',$cid)->first();
                    $can_id = $can->id;
                    $candidate_name = $can->name;

                    $job = JobVacancy::where('id','=',$insertedJId)->first();
                    $job_id = $job->id;
                    $job_loc = $job->location;
                    $salary = $job->salary;
                    $qualification = $job->qualification;
                    $job_desc = $job->description;
                    
                    $job = $job->name;
                    $employer = $emp->name;
                   // $msg_to_can = "";
                    Mail::to($can->email)->cc($emp->email)->send(new CandidatePlacedbyPia($candidate_name, $employer, $emp_addr, $emp_mail, $emp_phone, $job, $job_loc, $salary, $qualification, $job_desc, $msg_to_can ));
                    //Mail::to($can->email)->send(new CandidatePlacedbyPia($candidate_name, $employer, $emp_addr, $emp_mail, $emp_phone, $job, $job_loc, $salary, $qualification, $job_desc, $msg_to_can ));

                    
                }                     
                else{


                    //$query = Recruitment::query();
                    //$query->where('recruitment_status', 15)->where('candidate_id', '=',$cid);//shortlist
        
                    //$recshortlist = $query->get();
                    //$recshortlist->recruitment_status =18;
                    //$recshortlist->save();

                    $toreject = Recruitment::whereEmployerId($req->input('empid'))->whereCandidateId($cid)->whereJobId($req->input('job'))->whereRecruitmentStatus(15)->get();
                    //dd($toreject);
                    //$toreject_msg = Recruitment::select('remarks')->whereCandidateId($cid)->whereRecruitmentStatus(18)->update(['remarks' => "Due to the candidate's placement in another job opportunity, this application is denied."]); 

                    if(!$toreject->isEmpty()){
                    

                        $toreject = Recruitment::select('recruitment_status')->whereEmployerId($req->input('empid'))->whereCandidateId($cid)->whereRecruitmentStatus(15)->whereJobId($req->input('job'))->update(['recruitment_status' => 5,'msg_to_candidate' => $msg_to_can,'salary' => $req->input('salary'),'location' => $req->input('jlocation'),'updated_at' =>now(),'if_selected' => 1]);

                        $toreject = Recruitment::select('recruitment_status')->whereCandidateId($cid)->whereRecruitmentStatus(15)->whereNotIn('job_id',[$req->input('job')])->update(['recruitment_status' => 9]);
                        $toreject_msg = Recruitment::select('remarks')->whereCandidateId($cid)->whereRecruitmentStatus(9)->update(['remarks' => "Due to the candidate's placement in another job opportunity, this application is denied."]);
                        //echo "hello";
                        //dd($toreject);

                    }else{

                    $rec = new Recruitment();
                    $rec->employer_id = $req->input('empid');
                    $rec->location =$req->input('jlocation');
                    $rec->candidate_id =$cid;
                    $rec->salary =$req->input('salary');
                    $rec->job_id =$req->input('job');                  
                    $rec->selected_date =$req->input('jdate');
                    $rec->if_foreign =$req->input('fplacement');
                    $rec->recruitment_status =5;
                    $rec->if_selected = 1;
                    $rec->msg_to_candidate = $msg_to_can;
                    $rec->through_candidate = 21;
                    $rec->updated_at = now();
                    if($req->input('fplacement')=='Yes'){
                        $rec->country =$req->input('country');
                    }
                    $rec->created_by =  auth()->user()->id;
                    $rec->save();
                    //echo "hi";
                    //dd($rec->insert_id);
  
                    //dd($toreject);

                    $toreject = Recruitment::select('recruitment_status')->whereCandidateId($cid)->whereRecruitmentStatus(15)->whereNotIn('job_id',[$req->input('job')])->update(['recruitment_status' => 9]);
                    $toreject_msg = Recruitment::select('remarks')->whereCandidateId($cid)->whereRecruitmentStatus(9)->update(['remarks' => "Due to the candidate's placement in another job opportunity, this application is denied."]);

                }

                $user= user::find($cid);
                $user->employer_id =$req->input('empid');
                $user->profile_status = 5;
                $user->status = 1;
               // $user->course_completion_status_date = now();
                $user->placed_at = now();
                $user->placement_status = 5;
                $user->updated_by =  auth()->user()->Piaid->id;
                $user->updated_at = now();
                $user->save();

                    

                    $emp = User::where('id','=',$req->input('empid'))->first();
                    $emp_id = $emp->id;
                    $emp_mail = $emp->email;
                    $emp_phone = $emp->mobile_number;
                    if($emp->building_name){
                    $emp_addr = $emp->building_name  . ', ' .  $emp->postOffice . ', ' .  $emp->State->name . '-' .  $emp->pincode;
                    }else{
                        $emp_addr =$req->input('jlocation');
                    }
                    $can = User::where('id','=',$cid)->first();
                    $can_id = $can->id;
                    $candidate_name = $can->name;

                    $job = JobVacancy::where('id','=',$req->input('job'))->first();
                    $job_id = $job->id;
                    $job_loc = $job->location;
                    $salary = $req->input('salary');
                    $qualification = $job->qualification;
                    $job_desc = $job->description;

                    $can_applied = JobApplication::where("candidate_id","=",$cid)->where("job_id","=",$job->id)->first();
                
                    if( $can_applied){
                        $can_applied->application_status = "Placed";
                        $can_applied->updated_by = auth()->user()->Piaid->id;
                        $can_applied->placed_at = now();
                        $can_applied->save();
                    }

                    $notification = new Notification();
                    $notification->title = "Job Application Update";
                    $notification->description = $msg_to_can;
                    $notification->candidate_id = $cid;
                    $notification->notification_type = "job_application_update";
                    $notification->job_id = $req->input('job');
                    $notification->save();


                    $job = $job->name;
                    $employer = $emp->name;
                   // $msg_to_can = "";
                    Mail::to($can->email)->cc($emp->email)->send(new CandidatePlacedbyPia($candidate_name, $employer, $emp_addr, $emp_mail, $emp_phone, $job, $job_loc, $salary, $qualification, $job_desc, $msg_to_can ));


                }
                
            }
           
           $response['status'] = "success";
           $response['redirect'] = route('candidateInterestJoinedList');
           return response()->json($response)->setStatusCode(200);

            }
        


        

    } catch (\Exception $e) {
        // echo "hello";
        //DB::rollback();
        $msg = $e->getMessage();
        dd($e->getMessage());
        if ($e->errorInfo[1] == 1062) {
            // Custom error message for duplicate email
            $customErrorMessage = "The email address is already in use. Please use a different email.";

        } else {
            // Default custom error message
            $customErrorMessage = "The request has not been submitted. Please try after some time." . $e->errorInfo[2];

        }
       
        //  $customErrorMessage = "The request has not been submitted. Please try after some time.";
        \Log::error($customErrorMessage . " " . json_encode($e->errorInfo));
        // Log the exception for debugging purposes (optional)
        $response['status'] = "error";
        $response['message'] = $customErrorMessage . " ";
        $response['developer_message'] = $e->getMessage();
        $response['error_info'] = $e->errorInfo[2]; // Make sure error_info is set
        return response()->json($response)->setStatusCode(422);

    }
}




          
      

    public function AssignCourse(Request $req)
    {
       // dd($req);
        try {
            $cid = $req->input('cid');
            $Email = $req->input('email');
            $ContactNumber = $req->input('ContactNumber');
            $BuildingName = $req->input('BuildingName');
            $Landmark = $req->input('Landmark');
            $PostOffice = $req->input('PostOffice');
            $dob = $req->input('dob');
            $PIN_Code = $req->input('PIN_Code');
            $training = Course::find($req->input('trainings')); //dd($req->input('trainings'));
            $pr = "NoProceed";
            $CandidateInterestData = CandidateInterest::find($cid);
            if ($CandidateInterestData->category == "General") {
                $gseats = $training->general_seats - $training->general_seats_filled;
                if ($gseats > 0) {
                    $pr = "Proceed";
                    $gseat = $training->general_seats_filled + 1;
                    $noseat = $training->no_of_seats_filled + 1;
                    $training->general_seats_filled = $gseat;

                }
            } else if (($CandidateInterestData->category == "SC") || ($CandidateInterestData->category == "ST")) {
             //  dd($training);
                $SCSTseats = $training->scst_seats - $training->scst_seats_filled;
                if ($SCSTseats > 0) {
                    $pr = "Proceed";
                    $SCSTseat = $training->scst_seats_filled + 1;
                    $noseat = $training->no_of_seats_filled + 1;
                    $training->scst_seats_filled = $SCSTseat;
                }
            } else {
                $mseats = $training->minority_seats - $training->minority_seats_filled;
                if ($mseats > 0) {
                    $pr = "Proceed";
                    $mseat = $training->minority_seats_filled + 1;
                    $noseat = $training->no_of_seats_filled + 1;
                    $training->minority_seats_filled = $mseat;
                }
            }
            //  dd($pr);
            if ($pr == "Proceed") {


                $training->no_of_seats_filled = $noseat;
                $training->save();

                // Insert data into another table
                $password = "KtcPia*" . rand(999999, 000000) . "*";
                DB::beginTransaction();

                $user = new User();
                $user->name = $CandidateInterestData->name; // Replace with your column names
                $user->email = $Email;
                $user->dob = $dob;
                $user->user_role_id = 6;
                $user->country_id = $CandidateInterestData->country_id;
                $user->state_id = $CandidateInterestData->state_id;
                $user->district_id = $CandidateInterestData->district_id;
                $user->block_id = $CandidateInterestData->block_id;
                $user->localbody_id = $CandidateInterestData->localbodyid;
                $user->lbTypeid = $CandidateInterestData->lbtypeid;
                $user->password = Hash::make($password);
                $user->mobile_number = $ContactNumber;
                $user->phone_number = $CandidateInterestData->phone_number;
                $user->registered_at = $CandidateInterestData->created_at;
                $user->building_name = $BuildingName;
                $user->landmark = $Landmark;
                $user->postOffice = $PostOffice;
                $user->pincode = $PIN_Code;
                $user->sector_id = $CandidateInterestData->sector_id;
                $user->course_id = $req->input('trainings');
                if ($req->input('MasterCourse') != 'other') {
                    $user->course_master_id = $req->input('MasterCourse');
                } else {
                    $user->course_master_id = $req->input('ExtraMasterId');
                }
                $user->profile_status = 2;
                //$user->course_completion_status = 2; //joined
                $user->status = 11; //joined
                $user->placement_status = 0;

                $user->created_by =  auth()->user()->Piaid->id;
                $user->updated_by =  auth()->user()->Piaid->id;
                $user->highest_qualification = $CandidateInterestData->highest_qualification;
                $user->additional_certificates = $CandidateInterestData->additional_certificates;
                $user->religion = $CandidateInterestData->religion;
                $user->category = $CandidateInterestData->category;
                $user->pwd = $CandidateInterestData->pwd;
                $user->rationcardtype = $CandidateInterestData->rationcardtype;
                $user->MGNREGA = $CandidateInterestData->MGNREGA;
                $user->gender = $CandidateInterestData->gender;
                $user->willingTojoin = $CandidateInterestData->willingTojoin;
                $user->kudumbashree_member = $CandidateInterestData->kudumbashree_member;
                $user->join_type = 13; //By PIA


                $user->save();

                $CandidateInterestDatas = CandidateInterest::find($cid);
                $CandidateInterestDatas->status = '8';
                $CandidateInterestDatas->save();
                DB::commit();


                Mail::to($CandidateInterestData->email)->send(new CandidateRegistration($CandidateInterestData->name, $training));


                //  return redirect()->route('candidateInterestList'); // Redirect to a specific route after insertion

                $response['status'] = "success";
                $response['redirect'] = route('candidateInterestList');
                return response()->json($response)->setStatusCode(200);

            } else {
                $response['status'] = "error";
                $response['message'] = " Sorry,There is no seats available in this Category";
                return response()->json($response)->setStatusCode(200);

            }

        } catch (\Exception $e) {
            // echo "hello";
            DB::rollback();
            $msg = $e->getMessage();
        //dd( $e->getMessage());
            if ($e->errorInfo[1] == 1062) {
                // Custom error message for duplicate email
                $customErrorMessage = "The email address is already in use. Please use a different email.";

            } else {
                // Default custom error message
                $customErrorMessage = "The request has not been submitted. Please try after some time." . $e->errorInfo[2];

            }
            //  $customErrorMessage = "The request has not been submitted. Please try after some time.";
            \Log::error($customErrorMessage . " " . json_encode($e->errorInfo));
            // Log the exception for debugging purposes (optional)
            $response['status'] = "error";
            $response['message'] = $customErrorMessage . " ";
            $response['developer_message'] = $e->getMessage();
            $response['error_info'] = $e->errorInfo[2]; // Make sure error_info is set
            return response()->json($response)->setStatusCode(422);

        }
    }


    public function AssignCourseJoined(Request $req)
    {
        try {
            $cid = $req->input('cid');
            $userdata = User::find($cid);
            $courseId = $userdata->course_id;
            $category = $userdata->category;
            $training = Course::find($courseId);
            if ($category == "General") {

                $gseat = $training->general_seats_filled - 1;
                $noseat = $training->no_of_seats_filled - 1;
                $training->general_seats_filled = $gseat;

            } else if ($category == "SCST") {

                $SCSTseat = $training->scst_seats_filled - 1;
                $noseat = $training->no_of_seats_filled - 1;
                $training->scst_seats_filled = $SCSTseat;
            } else {

                $mseat = $training->minority_seats_filled - 1;
                $noseat = $training->no_of_seats_filled - 1;
                $training->minority_seats_filled = $mseat;
            }

            $training->no_of_seats_filled = $noseat;
            $training->save();
            $password = "KtcUser*" . rand(999999, 000000) . "*";
            DB::beginTransaction();
            $userdata->password = Hash::make($password);
            if ($req->input('course_completion_status') == 3) {
                $userdata->profile_status = 3;
                $userdata->status = 1;
                $userdata->course_completion_status = 1;
            }
            if ($req->input('course_completion_status') == 6) {
                $userdata->profile_status = 11;
                $userdata->status = 11;
                $userdata->course_completion_status = 1;
            }
            $userdata->course_completion_status = $req->input('course_completion_status');
            if ($req->input('course_completion_status') == 5) {
                if ($req->input('emp') == 1) {
                    $userdata->empid = $req->input('empid');
                    $userdata->profile_status = 5;
                    $userdata->status = 1;
                    $userdata->placement_status = 1;
                    $userdata->placed_at = now();
                    $userdata->course_completion_status = 1;
                } else {
                    //new insert emp
                }
            }
            $userdata->updated_by =  auth()->user()->Piaid->id;
            $userdata->save();
            DB::commit();
            if ($req->input('course_completion_status') == 3) {
                Mail::to($userdata->email)->send(new CandidateCredentials($userdata, $password));
            }

            if ($req->input('course_completion_status') == 6) {
                // Mail::to($userdata->email)->send(new CandidateCredentials($userdata, $password));
            }
        } catch (\Exception $e) {
            DB::rollback();
            $msg = $e->getMessage();
            echo $msg;
        }
        return redirect()->route('candidateInterestJoinedList'); // Redirect to a specific route after insertion
    }

    public function addCandidateInterest(Request $request)
    {
        $districts = District::whereIsActive(1)->get();
        $localbody_types = Localbodytype::whereIsActive(1)->get();
        $localbodies = Localbody::whereIsActive(1)->get();
        $defaultDate = Carbon::now()->subYears(18)->format('d-m-Y');
        list($max_day, $max_month, $max_year) = explode("-", $defaultDate);
        $course_masters = CourseMaster::whereIsActive(1)->get();
        return view('pia.pages.InterestForm', compact('districts', 'localbody_types', 'localbodies', 'defaultDate', 'course_masters', 'max_year'));
    }

    public function submitCandidateDetails(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), [
                'name' => 'required|string|max:50',
                'email' => 'required|email|unique:users,email',
                'ContactNumber' => 'required|digits:10|unique:users,mobile_number',
                'gender' => 'required|string|in:Male,Female,Transgender',
                'dob' => 'required|date_format:Y-m-d',
                'hQualification' => 'required|string',
                'district' => 'required|numeric|exists:districts,id',
                'BuildingName' => 'required|string|max:50',
                'Landmark' => 'required|string|max:50',
                'PostOffice' => 'required|string|max:25',
                'PIN_Code' => 'required|digits:6',
                'category' => 'required|string',
                'pwd' => 'required|string|in:Yes,No',
                'KudMember' => 'required|string|in:Yes,No',
                'rationCard' => 'required|string:in:APL,BPL',
                'mgnrega' => 'required|string|in:Yes,No',
                'JoiTocourse' => 'required|string|in:Yes,No',
                'course_master' => 'required|numeric|exists:course_masters,id',
                'trainings' => 'required|numeric|exists:courses,id',
                // 'block_list' => 'exists:blocks,id',
                // 'localbody' => 'exists:localbodies,id'
            ]);



            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                $training = Course::find($request->input('trainings'));
                $pr = "NoProceed";

                if ($request->category == "General") {
                    $gseats = $training->general_seats - $training->general_seats_filled;
                    if ($gseats > 0) {
                        $pr = "Proceed";
                        $gseat = $training->general_seats_filled + 1;
                        $noseat = $training->no_of_seats_filled + 1;
                        $training->general_seats_filled = $gseat;

                    }
                } else if (($request->category == "SC") || ($request->category == "ST")) {
                    $SCSTseats = $training->scst_seats - $training->scst_seats_filled;
                    if ($SCSTseats > 0) {
                        $pr = "Proceed";
                        $SCSTseat = $training->scst_seats_filled + 1;
                        $noseat = $training->no_of_seats_filled + 1;
                        $training->scst_seats_filled = $SCSTseat;
                    }
                } else {
                    $mseats = $training->minority_seats - $training->minority_seats_filled;
                    if ($mseats > 0) {
                        $pr = "Proceed";
                        $mseat = $training->minority_seats_filled + 1;
                        $noseat = $training->no_of_seats_filled + 1;
                        $training->minority_seats_filled = $mseat;
                    }
                }
                if ($pr == "Proceed") {


                    $training->no_of_seats_filled = $noseat;
                    $training->save();




                    DB::beginTransaction();
                    $User = new User();
                    $User->name = $request->name;
                    $User->user_role_id = 6;
                    $User->district_id = $request->district_id;
                    $User->email = $request->email;
                    $User->password = "password";
                    
                    $User->dob = $request->dob;
                    $User->mobile_number = $request->ContactNumber;
                    $User->phone_number = $request->Contact_Number;
                    $User->highest_qualification = $request->hQualification;
                    $User->additional_certificates = $request->certificate;
                    $User->district_id = $request->district;
                    $User->localbody_id = $request->localbody;
                    $User->lbTypeid = $request->localbody_type;
                    $User->block_id = $request->block_list;
                    $User->building_name = $request->BuildingName;
                    $User->landmark = $request->Landmark;
                    $User->postOffice = $request->PostOffice;
                    $User->pincode = $request->pincode;
                    $User->religion = $request->religion;
                    $User->category = $request->category;
                    $User->pwd = $request->pwd;
                    $User->rationcardtype = $request->rationCard;
                    $User->MGNREGA = $request->mgnrega;
                    $User->gender = $request->gender;
                    $User->willingTojoin = $request->JoiTocourse;
                    $User->kudumbashree_member = $request->KudMember;
                    $User->join_type = 13;
                    $User->course_id = $request->trainings;
                    $User->course_master_id = $request->course_master;
                    $course_master = CourseMaster::find($request->course_master);
                    $User->sector_id = $course_master->Sector->id;
                    $User->status = 11;
                    $User->profile_status = 2;
                    $User->registered_at = Carbon::now();
                    $User->pincode = $request->PIN_Code;
                    $User->created_by = auth()->user()->Piaid->id;
                    $User->updated_by = auth()->user()->Piaid->id;
                    $User->save();
                    DB::commit();



                    if ($User->id > 0) {

                        $course = Course::find($request->trainings);

                        Mail::to($request->email)->send(new CandidateRegistration($request->name, $course));
                        $response['status'] = "success";
                        $response['message'] = "Candidate added successfully";
                        $response['developer_message'] = "";
                    } else {

                        $response['status'] = "error";
                        $response['message'] = "Something went wrong";
                        $response['developer_message'] = "";
                    }

                } else {

                    $response['status'] = "error";
                    $response['message'] = "There is no enough seat in this category";
                    $response['developer_message'] = "";


                }


            }


        } catch (\Exception $e) {

            DB::rollBack();

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }


        return response()->json($response);

    }


    public function fetchcandiatelist(Request $request, $DistrictId)
    {
     $piaid = $request->input('piaid'); 
     $sectors   =   PiaSector::where('program_implementation_agency_id',  $piaid)->pluck('sector_id');
     $masters   =   CourseMaster::whereIn('sector_id', $sectors)->where('is_active', true)->pluck('id');
     $data['masters']  = $masters ;
        // $data['course'] = Course::all();
        if ($DistrictId != null && $DistrictId != "0" ) {
            $DistrictId = $request->input('DistrictId');
            //dd($Sectorid);
            $data['candidates']  = CandidateInterest::select('candidate_interests.*', DB::raw('(SELECT GROUP_CONCAT(course_master_id) FROM canadidate_interest_course_masters WHERE candidate_interest_id = candidate_interests.id) as master_ids'))
            ->where('candidate_interests.status', 1)
            ->where('district_id', $DistrictId)->get();
        
            
          
           // $data['candidates'] = CandidateInterest::where('status', 1)->where('district_id', $DistrictId)->get();
        }else{
           
            $data['candidates']  = CandidateInterest::select('candidate_interests.*', DB::raw('(SELECT GROUP_CONCAT(course_master_id) FROM canadidate_interest_course_masters WHERE candidate_interest_id = candidate_interests.id) as master_ids'))
            ->where('candidate_interests.status', 1)->get();
            
        }

        return response()->json(['data' => $data], 200);
    }
}


