<?php

namespace App\Http\Controllers;

use App\Models\ResetPasswordRequest;
use App\Models\User;
//use App\user_role;
//use App\ApplicationMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Crypt;
use League\CommonMark\Extension\SmartPunct\EllipsesParser;
use Carbon\Carbon;
use Mail;
use App\Mail\PasswordReset;
use Illuminate\Support\Facades\DB;


class LoginController extends Controller
{

    public function forgotPassword()
    {
        return view('forgot_password');
    }

    public function requestPasswordReset(Request $request)
    {

        try {

            $validator = Validator::make($request->all(), ['email' => 'required|email|exists:users,email']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                $User = User::whereStatus(1)->whereEmail($request->email)->first();

                if (!$User) {
                    $response['status'] = "error";
                    $response['message'] = "Your account deactivated.Please contact admin";
                    $response['developer_message'] = "";
                } else {

                    $password_reset_request = ResetPasswordRequest::whereUserId($User->id)->where('valid_upto', '>', Carbon::now())->whereStatus(1)->first();

                    if (!$password_reset_request) {
                        $password_reset_request = new ResetPasswordRequest();
                        $password_reset_request->email = $request->email;
                        $password_reset_request->user_id = $User->id;
                        $password_reset_request->valid_upto = Carbon::now()->addMinutes(30);
                        $password_reset_request->requested_at = Carbon::now();
                        $password_reset_request->request_status = "requested";
                        $history = "";
                        $password_reset_request->otp = base64_encode(rand(999999, 100000));

                    } else {

                        $history = $password_reset_request->history;

                    }

                    $password_reset_request->requested_client_ip_address = $request->ip();
                    $password_reset_request->history = $history . "Request for reset password of  account " . $request->email . " from device of ip address " . $request->ip() . " received at " . date('d M Y h:i:s a') . ".";
                    $password_reset_request->save();

                    if ($password_reset_request->id > 0) {
                        $password_reset_request->one_time_password = base64_decode($password_reset_request->otp);

                        $password_reset_request->link = route('otpPasswordReset', ['id' => base64_encode($password_reset_request->id)]);

                        Mail::to($User)->send(new PasswordReset($password_reset_request));

                        $response['status'] = "success";
                        $response['message'] = "Please check inbox of registered email";
                        $response['developer_message'] = "";
                        $response['redirect_url'] = route('otpPasswordReset', ['id' => base64_encode($password_reset_request->id)]);


                    } else {

                        $response['status'] = "error";
                        $response['message'] = "Something went wrong";
                        $response['developer_message'] = "";
                    }




                }




            }


        } catch (\Exception $e) {
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();
        }

        return response()->json($response);

    }

    public function encryptPassword(Request $request)
    {

        try {

            $validator = Validator::make($request->all(), ['password' => 'required']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(" ", $validator->errors()->all());

            } else {

                $response['status'] = "success";
                $password = Crypt::encryptString($request->password);
                $response['data'] = $password;
            }

            return response()->json($response);

        } catch (\Exception $e) {
            $response['status'] = "error";
            // $password=Crypt::encryptString($request->password);
            $response['data'] = $e->getMessage();
        }

    }

    public function loginView()
    {

        if (Auth::check()) {
            if (Auth::user()->user_role_id == 1 || Auth::user()->user_role_id == 2 || Auth::user()->user_role_id == 3) {
                return redirect(route('dashboard'));
            } elseif (Auth::user()->user_role_id == 4) {
                return redirect(route('pia-dashboard'));
            } elseif (Auth::user()->user_role_id == 5) {
                return redirect(route('employer-dashboard'));
            } elseif (Auth::user()->user_role_id == 6) {
                return redirect(route('candidates-dashboard'));
            }
        }

        return view('loginview');
    }

    public function loginCheck(Request $request)
    {

        $rules = [
            'Username' => 'required|email|exists:users,email',
            'hashed_password' => 'required',
        ];
       

        if($request->Username)
        {

            $messages = [
                'Username' => 'Email id or password is incorrect',
                'hashed_password' => 'Enter a valid password.'
            ];

        }

        else{

            $messages = [
                'Username' => 'Enter a valid email ID',
                'hashed_password' => 'Enter a valid password.'
            ];
        }

        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return redirect()->back()->withErrors(['message' => implode(".", $validator->errors()->all())])->withInput($request->all());
        }
        $User = User::whereEmail($request->input('Username'))->first();
        /* $User = User::whereUserName($request->UserName)
             ->where(function ($query) {
                 $query->where('user_type', 1)
                     ->orWhereHas('Roles');
             })
             ->whereStatus(1)->first();*/

        $password = Crypt::decryptString($request->hashed_password);
        // echo $password;exit;
        if ($User && $User->id && ($User->status == 1) && (Hash::check($password, $User->password))) {
            Auth::loginUsingId($User->id);

            $Applications = collect();
            if (Auth::user()->user_role_id == 1) {

                $Applications = Auth::user();
                return redirect(route('dashboard'));
            }
            if (Auth::user()->user_role_id == 2) {
                $Applications = Auth::user();
                return redirect(route('dashboard'));
            }
            if (Auth::user()->user_role_id == 3) {
                $Applications = Auth::user();
                return redirect(route('dashboard'));
            }
            if (Auth::user()->user_role_id == 4) {
                $Applications = Auth::user();
                return redirect(route('pia-dashboard'));
            }
            if (Auth::user()->user_role_id == 5) {
                $Applications = Auth::user();

                return redirect(route('employer-dashboard'));
            }
            if (Auth::user()->user_role_id == 6) {
                $Applications = Auth::user();
                return redirect(route('candidates-dashboard'));
            }
        }



        if ($User) {

            if ($User->status == 11) {



                if ($User->user_role_id == 5) {

                    if (is_null($User->approved_by) && is_null($User->rejected_by)) {

                        $login_error_message = "Your account is not integrated into our system; please contact the administrator.";

                    } else {

                        $login_error_message = "Your account is deactivated.Kindly contact admin";


                    }



                } else {

                    $login_error_message = "Your account is deactivated.Kindly contact admin";
                }






            } else {

                $login_error_message = "Incorrect email id or password";
            }

        } else {

            $login_error_message = "Your account is not integrated into our system; please contact the administrator.";
        }

        return redirect()->back()->withErrors(['message' => $login_error_message])->withInput($request->all());
    }
    public function pwdhash()
    {
        $pwd = Hash::make("123@Aa123");
        echo $pwd;

    }
    public function logout()
    {
        Auth::logout();
        return redirect('loginView');
    }

    public function otpPasswordReset($reset_request = null)
    {

        if (is_null($reset_request)) {
            return redirect()->back();
        } else {

            $password_reset_request = ResetPasswordRequest::find(base64_decode($reset_request));

            if ($password_reset_request) {
                // print_r($password_reset_request);

                $now = Carbon::now();

                if ($password_reset_request->valid_upto > $now && $password_reset_request->status == 1) {
                    return view('reset_password', compact('reset_request'));
                } else {

                    echo "<h1 style='color:red'>Link Expired</h1><br><a href='" . url('/') . "'>" . url('/') . "</a>";
                }


            } else {

                return redirect()->back();
            }


        }
    }

    public function submitPasswordResetRequest(Request $request)
    {

        try {

            $request_id = base64_decode($request->request_id);
            $password = ($request->hashed_password) ? Crypt::decryptString($request->hashed_password) : NULL;
            $confirm_password = ($request->hashed_confirm_password) ? Crypt::decryptString($request->hashed_confirm_password) : NULL;

            $data = [
                'request_id' => $request_id,
                'otp' => $request->otp,
                'new_password' => $password,
                'confirm_password' => $confirm_password
            ];

            $validator = Validator::make($data, [
                'request_id' => 'required|numeric|exists:reset_password_requests,id',
                'otp' => 'required|digits:6',
                'new_password' => 'required|string',
                'confirm_password' => 'required|string|same:new_password'
            ]);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode("", $validator->errors()->all());
                $response['developer_message'] = implode("", $validator->errors()->all());
            } else {

                $password_reset_request = ResetPasswordRequest::whereStatus(1)->whereId($request_id)->where('valid_upto', '>', Carbon::now())->first();

                if (!$password_reset_request) {
                    $response['status'] = "success";
                    $response['message'] = "OTP Expired.Please try again";
                    $response['developer_message'] = "";

                    $reset_request = ResetPasswordRequest::find($request_id);
                    $reset_request->status = "failed";
                    $reset_request->history = $reset_request->history . "Password reset failed due to invalid OTP at " . date('d M Y h:i:s a') . " from a device of IP address " . $request->ip() . ".";
                    $reset_request->save();

                    $request->session()->flash("success", "Please login with your new password");
                } else {

                    if (base64_decode($password_reset_request->otp) == $request->otp) {

                        $User = User::find($password_reset_request->user_id);
                        $User->password = Hash::make($password);
                        $User->save();

                        $response['status'] = "success";
                        $response['message'] = "Password changed successfully";
                        $response['developer_message'] = "";

                        $password_reset_request->request_status = "success";
                        $password_reset_request->status = 11;
                        $password_reset_request->history = $password_reset_request->history . "Password changed at " . date('d M Y h:i:s a') . " from a device of IP address " . $request->ip() . ".";
                        $password_reset_request->save();

                        Auth::loginUsingId($User->id);


                    } else {

                        $response['status'] = "error";
                        $response['message'] = "Wrong OTP";
                        $response['developer_message'] = "";
                    }


                }
            }




        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function changePassword(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), [
                'old_password' => 'required|string',
                'new_password' => 'required|string',
                'confirm_password' => 'required|string|same:new_password'
            ]);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode("", $validator->errors()->all());
            } else {

                if (Hash::check($request->old_password, $request->user()->password)) {

                    DB::beginTransaction();

                    $user = User::find($request->user()->id);
                    $user->password = Hash::make($request->new_password);
                    $user->save();

                    DB::commit();

                    $response['status'] = "success";
                    $response['message'] = "Password changed successfully";



                } else {

                    $response['status'] = "error";
                    $response['message'] = "Old password entered is incorrect ";
                }
            }


        } catch (\Exception $e) {

            DB::rollBack();

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function checkCurrentPassword(Request $request)
    {

        try {

            $validator = Validator::make($request->all(), ['password' => 'required']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(".", $validator->errors()->all());
                $response['developer_message'] = implode(".", $validator->errors()->all());
                $response['password_match_status'] = 0;
            } else {

                if (Hash::check($request->password, $request->user()->password)) {

                    $response['status'] = "success";
                    $response['message'] = "Password matches";
                    $response['password_match_status'] = 1;

                } else {

                    $response['status'] = "success";
                    $response['message'] = "";
                    $response['password_match_status'] = 0;
                }
            }


        } catch (\Exception $e) {
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();
            $response['password_match_status'] = 0;
        }

        return response()->json($response);

    }

}
