<?php

namespace App\Http\Controllers\Employer;

use App\Http\Controllers\Controller;
use App\Models\Recruitment;
use App\Models\Skill;
use App\Models\Status;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use App\Models\CourseMaster;
use App\Models\ProgramImplementationAgency;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Mail\CandidateJobNotification;
use Mail;
use App\Models\JobVacancy;
use App\Models\CanadidateInterestCourseMaster;
use App\Models\Notification;
use Illuminate\Database\Eloquent\Collection;
use App\Models\JobApplication;

class RecruitmentController extends Controller
{

    public function ShortListedCandidateList()
    {
        //dd(auth()->user()->id);

        $shortlisted_can = Recruitment::whereEmployerId(auth()->user()->id)->where("recruitment_status","=",15)->orderByDesc('id')->get();


        return view('employer.pages.ShortListedCandidateList')
            ->with('shortlisted', $shortlisted_can);
    }

    public function ShortListedCandidateDetails($job,$encryptempID)
  {
    $job_id= base64_decode($job);
    //dd($encryptempID);
    if (isset($encryptempID)) {
      $can = User::find(base64_decode($encryptempID));
      //dd($can);
      $Candidate=User::where('id', '=',$can->id)->where('user_role_id','=',6)->first();
      //dd($data['Candidate']);
      $Applied_Job = Recruitment::where('candidate_id','=',$Candidate->id)->whereJobId($job_id)->orderByDesc('id')->get();
      //dd($Applied_Job);
      $statuses = Status::all();

      return view('employer.pages.ShortListedCandidateDetails',compact('Candidate','Applied_Job','statuses'));   
    } else {
    
      return $this->appliedCandidateList();
    }
  }

    public function SendNotificationToCandidate(Request $request)
    {
        //dd($request);

        try {

            $rules = [
                'id' => 'required|numeric|exists:users,id',
                'can_name' => 'required|string',
                'can_email' => 'required|string',
                'pia_mail' => 'required|string',
                'training' => 'required|string',
                'employerID' => 'required|string',
                'Job' => 'required|string',
                'job_id' => 'required|string',
                'EmpStatus' => 'required',
                'candidate_message' => 'string'
            ];


            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {


                DB::beginTransaction();

                //dd($job);

                DB::commit();
                $job = $request->Job;
                $msg_to_can = $request->candidate_message;
                //dd($msg_to_can);

                $emp = User::where('id', '=', auth()->user()->id)->first();
                //dd($emp);
                $emp_id = $emp->id;
                $emp_mail = $emp->email;
                $employer = $emp->name;
                $emp_phone = $emp->mobile_number;
                $emp_addr = $emp->building_name . ', ' . $emp->postOffice . ', ' . $emp->State->name . '-' . $emp->pincode;

                $vacancy = JobVacancy::where('id', '=', $request->job_id)->first();
                $job_id = $vacancy->id;
                $job = $vacancy->name;
                $job_loc = $vacancy->location;
                $salary = $vacancy->salary;
                $qualification = $vacancy->qualification;
                $job_desc = $vacancy->description;

                $can = User::where('email', '=', $request->can_email)->first();
                $can_id = $can->id;
                $candidate_name = $request->can_name;

                $recruitment = Recruitment::where("employer_id","=",$emp_id)->where("candidate_id","=",$can_id)->where("job_id","=",$job_id)->first();

                $can_applied = JobApplication::where("candidate_id","=",$request->id)->where("job_id","=",$request->job_id)->first();
                
                $user = User::find($request->id);
                //dd($recruitment);
                if($recruitment->through_candidate == 20) { // direct employer placement
                    if ($request->EmpStatus == 18) {
                        $recruitment->recruitment_status = 18;
                        $recruitment->save();    

                    } elseif ($request->EmpStatus == 5){ 
                        $recruitment->recruitment_status = 5;
                        $recruitment->selected_date = now();
                        $recruitment->if_selected = 1;
                        $recruitment->save();
                        $toreject = Recruitment::select('recruitment_status')->whereCandidateId($can_id)->whereRecruitmentStatus(15)->whereNotIn('job_id',[$job_id])->update(['recruitment_status' => 9]);
                        $toreject_msg = Recruitment::select('remarks')->whereCandidateId($can_id)->whereRecruitmentStatus(9)->whereNotIn('job_id',[$job_id])->update(['remarks' => "Due to the candidate's placement in another job opportunity, this application is denied."]);
                        //dd($toreject);
                        $user->employer_id = $emp_id;
                        $user -> updated_by = $emp_id;
                        $user->placement_status = 5;
                        $user->profile_status = 5;
                        $user->placed_at = now();
                        $user -> updated_at = now();
                        $user->save();

                    }

                } elseif ($recruitment->through_candidate == 19) { //candidate application scenario
                    if ($request->EmpStatus == 18){
                        //dd($can_applied);
                        $can_applied -> application_status = "Rejected";
                        $can_applied -> rejected_at = now();
                        $can_applied -> updated_by = $emp_id;
                        $can_applied->save();
                        $recruitment->recruitment_status = 18;
                        $recruitment->save();

                    } elseif ($request->EmpStatus == 5){
                        $can_applied -> application_status = "Placed";
                        $can_applied -> updated_by = $emp_id;
                        $can_applied -> placed_at = now();
                        $can_applied->save();
                        $recruitment->recruitment_status = 5;
                        $recruitment -> selected_date = now();
                        $recruitment -> updated_at = now();
                        $recruitment->if_selected = 1;
                        $recruitment->save();
                        $toreject = Recruitment::select('recruitment_status')->whereCandidateId($can_id)->whereRecruitmentStatus(15)->whereNotIn('job_id',[$job_id])->update(['recruitment_status' => 9]);
                        $toreject_msg = Recruitment::select('remarks')->whereCandidateId($can_id)->whereRecruitmentStatus(9)->whereNotIn('job_id',[$job_id])->update(['remarks' => "Due to the candidate's placement in another job opportunity, this application is denied."]);
                        $user->employer_id = $emp_id;
                        $user->placement_status = 5;
                        $user->profile_status = 5;
                        $user -> updated_by = $emp_id;
                        $user->placed_at = now();
                        $user -> updated_at = now();
                        $user->save();

                    }
                }

                $notification = new Notification();
                $notification->title = "Job Application Update";
                $notification->description = $msg_to_can;
                $notification->candidate_id = $can_id;
                $notification->notification_type = "job_application_update";
                $notification->job_id = $job_id;
                $notification->save();

                Mail::to($user->email)->cc($request->pia_mail)->send(new CandidateJobNotification($candidate_name, $employer, $emp_addr, $emp_mail, $emp_phone, $job, $job_loc, $salary, $qualification, $job_desc, $msg_to_can));


                if ($user->id > 0) {
                    $response['status'] = "success";
                    $response['message'] = "Candidate Notification pushed succesfully.";
                    $response['developer_message'] = "";
                    $response['redirect'] = route('ShortListedCandidateList');
                } else {

                    $response['status'] = "error";
                    $response['message'] = "Something went wrong";
                    $response['developer_message'] = "";


                }

            }


        } catch (\Exception $e) {

            DB::rollBack();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }




    public function EmployeeList()
    {
        //dd(auth()->user()->id);
        $employees  = Recruitment::where('employer_id',"=",auth()->user()->id)->where('recruitment_status',"=",5)->orderByDesc('id')->get();
        //dd($employees);
        return view('employer.pages.EmployeeList')
            ->with('employees', $employees );
    }

    public function EmployeeDetails($encryptempID)
    {
      //dd($encryptempID);
      if (isset($encryptempID)) {
        $emp = User::find(base64_decode($encryptempID));

        $Employee=Recruitment::where('candidate_id', '=',$emp->id)->where('employer_id','=',auth()->user()->id)->where('recruitment_status','=',5)->first();
        //dd($Employee);

        $statuses = Status::all();

        return view('employer.pages.EmployeeDetails',compact('Employee','statuses'));   
      } else {
      
        return $this->EmployeeList();
      }
    }

    public function UpdateEmployee(Request $request)
    {
        //dd($request);

        try {

            $rules = [
                'id' => 'required|numeric|exists:users,id',
                'can_name' => 'required|string',
                'can_email' => 'required|string',
                'EmpStatus' => 'required|required'
            ];


            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {


                DB::beginTransaction();

                //dd($job);

                DB::commit();
                $job = $request->Job;
                $employer = $request->employer;
                $msg_to_can = $request->candidate_message;
                //dd($msg_to_can);

                $emp = User::where('id', '=', auth()->user()->id)->first();
                //dd($emp);
                $emp_id = $emp->id;
                $emp_mail = $emp->email;
                $emp_phone = $emp->mobile_number;
                $emp_addr = $emp->building_name . ', ' . $emp->postOffice . ', ' . $emp->State->name . '-' . $emp->pincode;

                $vacancy = JobVacancy::where('id', '=', $request->job_id)->first();
                $job_id = $vacancy->id;
                $job = $vacancy->name;
                $job_loc = $vacancy->location;
                $salary = $vacancy->salary;
                $qualification = $vacancy->qualification;
                $job_desc = $vacancy->description;

                $can = User::where('email', '=', $request->can_email)->first();
                $can_id = $can->id;
                $candidate_name = $request->can_name;

                $recruitment = Recruitment::where("employer_id","=",$emp_id)->where("candidate_id","=",$can_id)->where("job_id","=",$job_id)->first();

                $can_applied = JobApplication::where("candidate_id","=",$request->id)->where("job_id","=",$request->job_id)->first();
                
                $user = User::find($request->id);
                //dd($recruitment);
                if($recruitment->through_candidate == 20) { // direct employer placement
                    if($request->EmpStatus == 16) { // resigned
                        $recruitment->recruitment_status = 16;
                        $recruitment->updated_at = now();
                        $recruitment->save();
                        $user->placement_status = 16;
                        $user->profile_status = 4;
                        $user -> updated_by = $emp_id;
                        $user -> updated_at = now();
                        $user->save();
    
                    } elseif ($request->EmpStatus == 17) { //terminated
                        $recruitment->recruitment_status = 17;
                        $recruitment->updated_at = now();
                        $recruitment->save();
                        $user->placement_status = 17;
                        $user->profile_status = 4;
                        $user -> updated_by = $emp_id;
                        $user -> updated_at = now();
                        $user->save();
                    }

                } elseif ($recruitment->through_candidate == 19) { //candidate application scenario
                    if($request->EmpStatus == 16) { // resigned
                        $recruitment->recruitment_status = 16;
                        $recruitment->updated_at = now();
                        $recruitment->save();
                        $user->placement_status = 16;
                        $user->profile_status = 4;
                        $user -> updated_by = $emp_id;
                        $user -> updated_at = now();
                        $user->save();
                        $can_applied -> application_status = "Resigned";
                        $can_applied -> updated_by = $emp_id;
                        $can_applied->save();
    
                    } elseif ($request->EmpStatus == 17) { //terminated
                        $recruitment->recruitment_status = 17;
                        $recruitment->updated_at = now();
                        $recruitment->save();
                        $user->placement_status = 17;
                        $user->profile_status = 4;
                        $user -> updated_by = $emp_id;
                        $user -> updated_at = now();
                        $user->save();
                        $can_applied -> application_status = "Terminated";
                        $can_applied -> updated_by = $emp_id;
                        $can_applied->save();
                    }
                }


                if ($user->id > 0) {
                    $response['status'] = "success";
                    $response['message'] = "Candidate updated succesfully.";
                    $response['developer_message'] = "";
                    $response['redirect'] = route('EmployeeList');
                } else {

                    $response['status'] = "error";
                    $response['message'] = "Something went wrong";
                    $response['developer_message'] = "";


                }

            }


        } catch (\Exception $e) {

            DB::rollBack();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

}
