<?php

namespace App\Http\Controllers\Employer;

use App\Http\Controllers\Controller;
use App\Models\CanadidateInterestCourseMaster;
use App\Models\Course;
use App\Models\JobVacancy;
use App\Models\Notification;
use App\Models\Recruitment;
use App\Models\Sector;
use App\Models\Status;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Mail\CandidateJobNotification;
use Mail;

class PlacementController extends Controller
{
    public function ongoingCourseList()
    {

        $data['trainigs'] = Course::leftJoin('users', function($join) {
            $join->on('courses.id', '=', 'users.course_id')->where('users.user_role_id', '=', 6)->where('users.status', '=', 1);
          })->leftJoin('program_implementation_agencies', function($join) {
            $join->on('courses.pia_id', '=', 'program_implementation_agencies.id')->where('program_implementation_agencies.is_active', '=', 1);
          })->select('courses.id', 'courses.training_name','courses.end_date', 'program_implementation_agencies.agency_name', Course::raw('count(users.id) as total_students'))->where('courses.course_status', '=', 7)->where('courses.is_active', '=', 1)->orderByDesc('id')->groupBy('courses.id')->get();

        $Sector = Sector::whereIsActive(1)->get();

        return view('employer.pages.OngoingCourses', ["data"=>$data], compact('Sector'));      
    }

    public function completedTrainingList()
    {

        $data['trainigs'] = Course::leftJoin('users', function($join) {
            $join->on('courses.id', '=', 'users.course_id')->where('users.user_role_id', '=', 6)->where('users.status', '=', 1);
          })->leftJoin('program_implementation_agencies', function($join) {
            $join->on('courses.pia_id', '=', 'program_implementation_agencies.id')->where('program_implementation_agencies.is_active', '=', 1);
          })->select('courses.id', 'courses.training_name','courses.end_date', 'program_implementation_agencies.agency_name', Course::raw('count(users.id) as total_students'))->where('courses.course_status', '=', 3)->where('courses.is_active', '=', 1)->orderByDesc('id')->groupBy('courses.id')->get();

        return view('employer.pages.CompletedTrainings', ["data"=>$data]); 
    }

    public function candidatesList($encryptempID = null)
    {

        if (isset($encryptempID)) {
            $course = Course::find(base64_decode($encryptempID));
            //dd($course->id);
            $candidates=User::where('course_id', '=',$course->id)->where('user_role_id','=',6)->where('course_completion_status','=',3)->where('profile_status','=',3)->get();
            //dd($candidates);
            $placed_count = User::where('profile_status', 5)->where('course_id', '=',$course->id)->count();

            return view('employer.pages.TrainingCompletedCandidates',compact('candidates','placed_count'));
        } else {
          
          return $this->completedTrainingList();
        }
    }

    public function viewCandidateDetails($cid)
    {
        //dd(auth()->user());

        $Candidate = User::find($cid);

        $Job_Vacancies = JobVacancy::where('employer_id', auth()->user()->id)->whereIsActive(1)->get();
        //dd($Job_Vacancies);
        $Courses = CanadidateInterestCourseMaster::where('candidate_interest_id', $cid)->get();

        $statuses = Status::all();

        return view('employer.pages.JobInterviewEnquiry', compact('Candidate', 'Courses', 'Job_Vacancies','statuses'));
    }

    public function SendJobNotification(Request $request)
    {
        //dd($request);

        try {

            $rules = [
                'id' => 'required|numeric|exists:users,id',
                'can_name' => 'required|string',
                'can_email' => 'required|string',
                'pia_mail' => 'required|string',
                'training' => 'required|string',
                'Job' => 'required|string',
                'EmpStatus' => 'required',
                'candidate_message' => 'string'
            ];


            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {


                $password = "KtcCan*" . rand(999999, 000000) . "*";

                DB::beginTransaction();

                $user = User::find($request->id);
                $user->password = Hash::make($password);
                $user->rejected_by = auth()->user()->id;
                $user->status = 1;
                $user->save();

                $job = JobVacancy::where('name', '=', $request->Job)->first();
                $job_id = $job->id;
                $job_loc = $job->location;
                $salary = $job->salary;
                $qualification = $job->qualification;
                $job_desc = $job->description;
                //dd($job);

                $error =0;
                if (Recruitment::whereCandidateId($user->id)->whereJobId($job_id)->exists()) {
                    $error =1;
                    // Job Application already exists, return error response
                    return response()->json(['message' => 'Candidate Application for the Selected Job Exists!Please choose another Job.'], 400);
                }

                if ($error ==0){

                    DB::commit();
                    $job = $request->Job;
                    $msg_to_can = $request->candidate_message;
                    //dd($msg_to_can);
    
                    $emp = User::where('id', '=', auth()->user()->id)->first();
                    $emp_id = $emp->id;
                    $emp_mail = $emp->email;
                    $employer = $emp->name;
                    $emp_phone = $emp->mobile_number;
                    $emp_addr = $emp->building_name . ', ' . $emp->postOffice . ', ' . $emp->State->name . '-' . $emp->pincode;
    
                    $can = User::where('email', '=', $request->can_email)->first();
                    $can_id = $can->id;
                    $candidate_name = $request->can_name;
    
                    $recruitment = new Recruitment();
                    $recruitment->employer_id = $emp_id;
                    $recruitment->candidate_id = $can_id;
                    $recruitment->job_id = $job_id;
                    $recruitment->mobile_number = $emp_phone;
                    $recruitment->msg_to_candidate = $msg_to_can;
                    if ($request->EmpStatus = 15) {
                        $recruitment->recruitment_status = 15;
                        $recruitment->through_candidate = 20;
                    } elseif ($request->EmpStatus = 18) {
                        $recruitment->recruitment_status = 18;
                        $recruitment->through_candidate = 20;
                    }
                    $recruitment->created_by = auth()->user()->id;
                    $recruitment -> updated_at = now();
                    $recruitment->save();
    
                    $notification = new Notification();
                    $notification->title = "Job Application Update";
                    $notification->description = $msg_to_can;
                    $notification->candidate_id = $can_id;
                    $notification->notification_type = "job_application_update";
                    $notification->job_id = $job_id;
                    $notification->save();
    
                    Mail::to($user->email)->cc($request->pia_mail)->send(new CandidateJobNotification($candidate_name, $employer, $emp_addr, $emp_mail, $emp_phone, $job, $job_loc, $salary, $qualification, $job_desc, $msg_to_can));
    
    
                    if ($user->id > 0) {
                        $response['status'] = "success";
                        $response['message'] = "Job Notification pushed succesfully.";
                        $response['developer_message'] = "";
                        $response['redirect'] = route('candidatesList');
                    } else {
    
                        $response['status'] = "error";
                        $response['message'] = "Something went wrong";
                        $response['developer_message'] = "";
    
    
                    }


                }


            }


        } catch (\Exception $e) {

            DB::rollBack();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function fetchTrainingProgrammes(Request $request,$idSector)
    {
       // dd("hi");
       if ($idSector != null && $idSector != "0" ) {
        $Sectorid = $request->input('idSector');
        //dd($Sectorid);
        $data['trainigs'] = Course::leftJoin('users', function($join) {
            $join->on('courses.id', '=', 'users.course_id')->where('users.user_role_id', '=', 6)->where('users.status', '=', 1);
            })->leftJoin('program_implementation_agencies', function($join) {
              $join->on('courses.pia_id', '=', 'program_implementation_agencies.id')->where('program_implementation_agencies.is_active', '=', 1);
            })->select('courses.id', 'courses.training_name','courses.end_date', 'program_implementation_agencies.agency_name', Course::raw('count(users.id) as total_students'))->where('courses.course_status', '=', 7)->where('courses.is_active', '=', 1)->where('courses.sector_id', '=', $Sectorid)->orderByDesc('id')->groupBy('courses.id')->get();
    }else{
       
        $data['trainigs'] = Course::leftJoin('users', function($join) {
            $join->on('courses.id', '=', 'users.course_id')->where('users.user_role_id', '=', 6)->where('users.status', '=', 1);
            })->leftJoin('program_implementation_agencies', function($join) {
              $join->on('courses.pia_id', '=', 'program_implementation_agencies.id')->where('program_implementation_agencies.is_active', '=', 1);
            })->select('courses.id', 'courses.training_name','courses.end_date', 'program_implementation_agencies.agency_name', Course::raw('count(users.id) as total_students'))->where('courses.course_status', '=', 7)->where('courses.is_active', '=', 1)->orderByDesc('id')->groupBy('courses.id')->get();
        
    }

    return response()->json(['data' => $data], 200);     
        
    }

}
