<?php

namespace App\Http\Controllers\Employer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Course;
use App\Models\JobApplication;
use App\Models\Recruitment;
class EmployerController extends Controller
{
    public function dashboard()
    {


      $data['candidatesCountCompleted'] = User::where('user_role_id', '=', 6)->where('course_completion_status', '=', 3)->where('placement_status', '!=', 5)->get()->count();


        $data['candidatesCountApplied'] = JobApplication::leftJoin('job_vacancies', function($join) {
            $join->on('job_applications.job_id', '=', 'job_vacancies.id');
          })->where('job_vacancies.employer_id', '=', auth()->user()->id)->where('job_applications.status', '!=', 11)->where('application_status',"=", "Applied")->get()->count();

          $data['placementProvided'] = Recruitment::where('employer_id', '=', auth()->user()->id)->where('is_active', '=', 1)->get()->count();
          /*
          $data['placementProvided'] = JobApplication::leftJoin('job_vacancies', function($join) {
            $join->on('job_applications.job_id', '=', 'job_vacancies.id')->where('job_vacancies.employer_id', '=', auth()->user()->id);
          })->where('job_applications.status', '=', 5)->get()->count();
          */
          $data['candidatesAppliedList'] = JobApplication::leftjoin('job_vacancies', function($join) {
            $join->on('job_applications.job_id', '=', 'job_vacancies.id');
          })->leftjoin('users', function($join) {
            $join->on('job_applications.candidate_id', '=', 'users.id');
          })->select('users.name', 'users.email', 'users.mobile_number', 'job_vacancies.name as job_vacancies_name')->where('job_applications.status', '!=', 11)->where('application_status',"=", "Applied")->where('job_vacancies.employer_id', '=', auth()->user()->id)->orderBy('job_applications.id','DESC')->limit(5)->get();

         

        return view("employer.pages.dashboard", ["data" => $data]
      );
    }

    public function profile()
    {
        return view('employer.pages.profile');
    }
}
