<?php

namespace App\Http\Controllers\Employer;

use App\Http\Controllers\Controller;
use App\Models\CourseSkillMapping;
use App\Models\JobApplication;
use App\Models\Skill;
use App\Models\Status;
use App\Models\User;
use App\Models\JobVacancy;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Mail\CandidateJobNotification;
use Mail;
use App\Models\Recruitment;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\Notification;

class EmployerCandidateController extends Controller
{

    public function CandidateList()
    {
        $data['candidates'] = User::where('status', 1)->where('user_role_id', 6)->where('course_completion_status',"=",3)->orderByDesc('id')->get();

        //dd($candidates);

        $Skills = Skill::whereIsActive(1)->get();
       // dd($candidates);
        return view('employer.pages.CandidateList',  ["data"=>$data],compact('Skills'));
    }
    public function appliedCandidateList()
    {
        $candidates=JobApplication::where('application_status',"=", "Applied")->where('application_status',"=", "Applied")->orderByDesc('id')->get();
     
        return view('employer.pages.AppliedCandidateList')
        ->with('candidates', $candidates);        
  }

  public function viewAppliedCandidateDetails($job,$encryptempID)
  {
    //dd($encryptempID);
    $job_id= base64_decode($job);
    //dd($job_name);
    if (isset($encryptempID)) {
      $Candidate = User::find(base64_decode($encryptempID));
      //dd($Candidate);
      //$Candidate=User::where('id', '=',$can->id)->where('user_role_id','=',6)->first();
      //dd($data['Candidate']);
      //$Job = JobVacancy::where('name',$job_id)->first();
      //dd($Job);
      $applications = JobApplication::select('job_id')->where('candidate_id','=',$Candidate->id)->groupBy('job_id')->get();
      //dd($applications);
      //check
      $Applied_Job = JobApplication::whereCandidateId($Candidate->id)->whereJobId($job_id)->get();     
      //dd($Applied_Job);
      $statuses = Status::all();

      return view('employer.pages.AppliedCandidateDetailview',compact('Candidate','Applied_Job','statuses'));   
    } else {
    
      return $this->appliedCandidateList();
    }
  }

  public function SendNotificationToCandidate(Request $request)
    {
        //dd($request);

        try {

            $rules = [
                'id' => 'required|numeric|exists:users,id',
                'can_name' => 'required|string',
                'pia_mail' => 'required|string',
                'training' => 'required|string',
                'employer' => 'required|string',
                'employerID' => 'required|string',
                'Job' => 'required|string',
                'EmpStatus' => 'required',
                'candidate_message' => 'string'
            ];


            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {


                $password = "KtcCan*" . rand(999999, 000000)."*";

                DB::beginTransaction();

                $user = User::find($request->id);
                $user->password = Hash::make($password);
                $user->status = 1;
                $user->save();

                $job = JobVacancy::where('name','=',$request->Job)->first();
                $job_id = $job->id;
                $job_loc = $job->location;
                $salary = $job->salary;
                $qualification = $job->qualification;
                $job_desc = $job->description;
                //dd($job);

                DB::commit();
                $job = $request->Job;
                $employer = $request->employer;
                $msg_to_can = $request->candidate_message;
                //dd($msg_to_can);
                
                $emp = User::where('name','=',$employer)->first();
                $emp_id = $emp->id;
                $emp_mail = $emp->email;
                $emp_phone = $emp->mobile_number;
                $emp_addr = $emp->building_name  . ', ' .  $emp->postOffice . ', ' .  $emp->State->name . '-' .  $emp->pincode;

                $can = User::where('name','=',$request->can_name)->first();
                $can_id = $can->id;
                $candidate_name = $request->can_name;

                $recruitment = new Recruitment();
                $recruitment->employer_id = $emp_id;
                $recruitment->candidate_id = $can_id;
                $recruitment->job_id = $job_id;
                $recruitment->mobile_number = $emp_phone;
                $recruitment->msg_to_candidate = $msg_to_can;
                $recruitment->recruitment_status = 4;
                $recruitment->created_by = $emp_id;
                $recruitment->save();

                Mail::to($user->email)->cc($request->pia_mail)->send(new CandidateJobNotification($candidate_name, $employer, $emp_addr, $emp_mail, $emp_phone, $job, $job_loc, $salary, $qualification, $job_desc, $msg_to_can ));


                if ($user->id > 0) {
                    $response['status'] = "success";
                    $response['message'] = "Job Notification pushed succesfully.";
                    $response['developer_message'] = "";
                    $response['redirect'] = route('AppliedCandidateList');
                } else {

                    $response['status'] = "error";
                    $response['message'] = "Something went wrong";
                    $response['developer_message'] = "";
                    $response['redirect'] = route('AppliedCandidateList');


                }

            }


        } catch (\Exception $e) {

            DB::rollBack();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function SendNotificationToAppliedCandidate(Request $request)
    {
        //dd($request);

        try {

            $rules = [
                'id' => 'required|numeric|exists:users,id',
                'can_name' => 'required|string',
                'can_email' => 'required|string',
                'pia_mail' => 'required|string',
                'job_id' => 'required|string',
                'training' => 'required|string',
                'Job' => 'required|string',
                'EmpStatus' => 'required',
                'candidate_message' => 'string'
            ];


            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {


                $password = "KtcCan*" . rand(999999, 000000) . "*";

                DB::beginTransaction();

                $user = User::find($request->id);
                $user->password = Hash::make($password);
                $user->status = 1;
                $user->save();

                $job = JobVacancy::where('name', '=', $request->Job)->first();
                $job_id = $job->id;
                $job_loc = $job->location;
                $salary = $job->salary;
                $qualification = $job->qualification;
                $job_desc = $job->description;
                //dd($job);

                DB::commit();
                $job = $request->Job;
                $employer = $request->employer;
                $msg_to_can = $request->candidate_message;
                //dd($msg_to_can);

                $emp = User::where('id', '=', auth()->user()->id)->first();
                $emp_id = $emp->id;
                $emp_mail = $emp->email;
                $emp_phone = $emp->mobile_number;
                $emp_addr = $emp->building_name . ', ' . $emp->postOffice . ', ' . $emp->State->name . '-' . $emp->pincode;

                $can = User::where('email', '=', $request->can_email)->first();
                $can_id = $can->id;
                $candidate_name = $request->can_name;

                $can_applied = JobApplication::where("candidate_id","=",$request->id)->where("job_id","=",$request->job_id)->first();

                $recruitment = new Recruitment();
                $recruitment->employer_id = $emp_id;
                $recruitment->candidate_id = $can_id;
                $recruitment->job_id = $job_id;
                $recruitment->mobile_number = $emp_phone;
                $recruitment->msg_to_candidate = $msg_to_can;
                $recruitment->recruitment_status = 15;
                $recruitment->through_candidate = 19;
                $recruitment->created_by = $request->user()->id;
                $recruitment->save();
                if ($request->EmpStatus == 15){
                    //dd($can_applied);
                    $can_applied -> application_status = "Shortlisted";
                    $can_applied -> updated_by = $emp_id;
                    $can_applied -> shortlisted_at = now();
                    $can_applied->save();

                } elseif ($request->EmpStatus == 18){

                    $can_applied -> application_status = "Rejected";
                    $can_applied -> updated_by = $emp_id;
                    $can_applied -> rejected_at = now();
                    $can_applied->save();

                }


                $notification = new Notification();
                $notification->title = "Job Application Update";
                $notification->description = $msg_to_can;
                $notification->candidate_id = $can_id;
                $notification->notification_type = "job_application_update";
                $notification->job_id = $job_id;
                $notification->save();

                Mail::to($user->email)->cc($request->pia_mail)->send(new CandidateJobNotification($candidate_name, $employer, $emp_addr, $emp_mail, $emp_phone, $job, $job_loc, $salary, $qualification, $job_desc, $msg_to_can));


                if ($user->id > 0) {
                    $response['status'] = "success";
                    $response['message'] = "Job Notification pushed succesfully.";
                    $response['developer_message'] = "";
                    $response['redirect'] = route('AppliedCandidateList');
                } else {

                    $response['status'] = "error";
                    $response['message'] = "Something went wrong";
                    $response['developer_message'] = "";


                }

            }


        } catch (\Exception $e) {

            DB::rollBack();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

     public function fetchCandidatesList(Request $request, $idQualification)
     {
         //dd($request);
         if ($idQualification != null && $idQualification != "0" ) {
             $QualificationId = $request->input('idQualification');
             //dd($Sectorid);
             $data['candidates'] = User::with('Training')->where('status', 1)->where('user_role_id', 6)->where('highest_qualification', $QualificationId)->where('course_completion_status',"=",3)->orderByDesc('id')->get();
         }else{
            
             $data['candidates'] = User::with('Training')->where('status', 1)->where('user_role_id', 6)->where('course_completion_status',"=",3)->orderByDesc('id')->get();
             
         }
         //dd($data['candidates']);
 
         return response()->json(['data' => $data], 200);
     }

     public function fetchCandidatesListonSkill(Request $request, $idSkill)
     {
         //dd($request);
         if ($idSkill != null && $idSkill != "0" ) {
             $SkillId = $request->input('idSkill');

             $courses = CourseSkillMapping::select('course_id')->where('skill_id',"=",$SkillId)->groupBy('course_id')->get()->toArray() ;

             //dd($courses);
             $data['candidates'] = User::with('Training')->where('status', 1)->where('user_role_id', 6)->whereIn('course_id',$courses)->where('course_completion_status',"=",3)->orderByDesc('id')->get();
         }else{
            
             $data['candidates'] = User::with('Training')->where('status', 1)->where('user_role_id', 6)->where('course_completion_status',"=",3)->orderByDesc('id')->get();
             
         }
         //dd($data['candidates']);
 
         return response()->json(['data' => $data], 200);
     }
      
 
}
