<?php

namespace App\Http\Controllers\Employer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CandidateInterest;
use App\Models\CanadidateInterestCourseMaster;
use App\Models\Course;
use App\Models\User;
use App\Models\CourseMaster;
use App\Models\ProgramImplementationAgency;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use App\Mail\CandidateJobNotification;
use Mail;

class CandidateInterestEmpController extends Controller
{
    public function CandidateInterestList()
    {
        $candidates=User::where('course_completion_status', 3)->get();
       
        return view('employer.pages.CandidateInterestListEmp')
        ->with('candidates', $candidates);        
    }

    public function candidateInterestEmpDet($cid)
    {
        //dd(auth()->user());
        $cid= base64_decode($cid);
        $Candidate =   User::find($cid);
        //dd($Candidate);
        $Courses =   CanadidateInterestCourseMaster::where('candidate_interest_id',$cid)->get();
      
        return view('employer.pages.InterestViewEmp',compact('Candidate','Courses'));
    }  
    

  public function SendJobNotification(Request $request)
    {
        //dd($request);

        try {

            $rules = [
                'id' => 'required|numeric|exists:users,id',
                'pia_mail' => 'required|string',
                'EmpStatus' => 'required'
            ];


            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {


                $password = "KtcCan*" . rand(999999, 000000)."*";

                DB::beginTransaction();

                $user = User::find($request->id);
                $user->password = Hash::make($password);
                $user->status = 1;
                $user->save();

                DB::commit();

                Mail::to($user->email)->cc($request->pia_mail)->send(new CandidateJobNotification($user, $password));


                if ($user->id > 0) {
                    $response['status'] = "success";
                    $response['message'] = "Job Notification pushed succesfully.";
                    $response['developer_message'] = "";
                } else {

                    $response['status'] = "error";
                    $response['message'] = "Something went wrong";
                    $response['developer_message'] = "";


                }

            }


        } catch (\Exception $e) {

            DB::rollBack();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }
}
