<?php

namespace App\Http\Controllers\Candidates;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Notification;

class NotificationController extends Controller
{
    public function viewJobAlert($notification_id = null)
    {

        if (is_null($notification_id)) {
            return redirect()->back();
        }

        $notification = Notification::find(base64_decode($notification_id));

        if (!$notification) {
            return redirect()->back();
        }

        if ($notification->notification_type == "job_vacancy") {
            $job = $notification->Job;
            return view('candidates.pages.view_job_details', compact('job'));
        } else {

            $job = $notification->Job;
            return view('candidates.pages.view_notification', compact('job', 'notification'));


        }

    }

    public function listJobAlerts(Request $request)
    {
        $job_alerts = Notification::whereCandidateId($request->user()->id)->orWhere('notification_type', 'job_vacancy')->orderByDesc('id')->get();

        return view('candidates.pages.job_alerts', compact('job_alerts'));
    }
}
