<?php

namespace App\Http\Controllers\Candidates;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\JobVacancy;
use Illuminate\Support\Facades\Validator;
use App\Models\JobApplication;
use Carbon\Carbon;
use App\Models\User;
use Mail;
use App\Mail\JobApplication as JobApplicationMail;

class JobApplicationController extends Controller
{
    public function jobs(Request $request)
    {

        $job_applications = User::find($request->user()->id)->JobApplications;

        $shortlisted_jobs = User::find($request->user()->id)->ShortlistedJobs;

        $jobs_exclude = array();

        foreach ($job_applications as $application) {
            array_push($jobs_exclude, $application->job_id);
        }

        foreach ($shortlisted_jobs as $short_listed) {
            array_push($jobs_exclude, $short_listed->job_id);
        }

        $jobs = JobVacancy::whereNotIn('id', $jobs_exclude)->whereIsActive(1)->get();
        return view('candidates.jobs.list', compact('jobs'));
    }

    public function appliedJobs(Request $request)
    {
        $jobs = User::find($request->user()->id)->JobApplications;
        return view('candidates.jobs.applied_jobs', compact('jobs'));
    }

    public function applyJob(Request $request)
    {


        try {



            $validator = Validator::make($request->all(), ['job' => 'required|string']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = $response['message'];
            } else {

                $job = JobVacancy::find(base64_decode($request->job));

                if ($job) {

                    $job_application = new JobApplication();
                    $job_application->job_id = $job->id;
                    $job_application->candidate_id = $request->user()->id;
                    $job_application->application_status = "Applied";
                    $job_application->applied_at = Carbon::now();
                    $job_application->created_by = $request->user()->id;
                    $job_application->updated_by = $request->user()->id;
                    $job_application->save();

                    if ($job_application->id) {

                        /*  $notification = new Notification();
                          $notification->job_application_id = $job_application->id;
                          $notification->content = $job_application->Candidate->name . " applied for " . $job_application->Job->name . " position on " . $job_application->Job->location . " location on " . date('d M Y', strtotime($job_application->created_at)) . " at " . date('h:i:s a', strtotime($job_application->created_at));
                          $notification->user_type = 5;
                          $notification->save();*/

                        Mail::to($job_application->Job->Employer)->send(new JobApplicationMail($job_application));

                        $response['status'] = "success";
                        $response['message'] = "Job application submitted";
                        $response['developer_message'] = "";
                        $response['redirect'] = route('candidateJobs');

                    } else {

                        $response['status'] = "error";
                        $response['message'] = "Job application not saved";
                        $response['developer_message'] = "Job application not saved";
                    }




                } else {

                    $response['status'] = "error";
                    $response['message'] = "Invalid Job";
                    $response['developer_message'] = "Invalid message";
                }
            }




        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);


    }

    public function jobsOnceShortlisted(Request $request)
    {
        $shortlisted_jobs = $request->user()->ShortlistedJobs;

        return view('candidates.jobs.shortlisted_jobs', compact('shortlisted_jobs'));
    }


}
