<?php

namespace App\Http\Controllers\Candidates;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Course;
use App\Models\JobVacancy;
use App\Models\JobApplication;
use App\Models\Notification;
use Illuminate\Support\Facades\Validator;

class CandidatesController extends Controller
{
    public function dashboard(Request $request)
    {
        $data['totalJobOpenings'] = JobVacancy::where('is_active', '=', 1)->count();
        $data['latestJobOpenings'] = JobVacancy::where('created_at', '>=',  date("Y-m-d", strtotime(date('Y/m/d')."-1 weeks")))->where('created_at', '<=', date("Y-m-d H:i:s", strtotime( date( 'Y/m/d  H:i:s' ))))->where('is_active', '=', 1)->count();
        $data['appliedJobs'] = JobApplication::where('candidate_id', '=', auth()->user()->id)->where('status', '!=', 11)->count();
        $data['notifications'] = Notification::whereCandidateId($request->user()->id)->orWhere('notification_type','job_vacancy')->orderByDesc('id')->limit(3)->get();
        $data['total_notifications']=Notification::whereCandidateId($request->user()->id)->orWhere('notification_type','job_vacancy')->orderByDesc('id')->get()->count();
        $data['listJobOpenings'] = JobVacancy::leftjoin('users', function ($join) {
            $join->on('job_vacancies.employer_id', '=', 'users.id');
          })->select('job_vacancies.name as job_name', 'job_vacancies.location as job_location', 'users.name as employer_name', 'users.district_id')->where('is_active', '=', 1)->orderBy('job_vacancies.id','DESC')->limit(5)->get();
        return view("candidates.pages.dashboard", ["data"=>$data]);
    }
    public function profile()
    {
        return view('candidates.pages.profile');
    }

    public function DeactivateCandidateProfile(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), ['candidate' => 'required|string']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());

            } else {

                User::whereId(base64_decode($request->candidate))->update(['status' => 11, 'profile_status' => 11, 'updated_by' => $request->user()->id]);
                $response['status'] = "success";
                $response['message'] = "Your profile has been deleted successfully, Logging Out!";
                $response['developer_message'] = "";
                $response['redirect'] = route('logout');


            }


        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function logout()
    {
        Auth::logout();
        return redirect('loginView');
    }

}
