<?php

namespace App\Http\Controllers\Admin;

use App\Models\PiaSector;
use Carbon\Carbon;
use App\Http\Controllers\Controller;
use App\Models\Course;
use App\Models\Localbody;
use App\Models\Sector;
use App\Models\CourseMaster;
use App\Models\Block;
use App\Models\CourseSkillMapping;
use App\Models\Skill;
use App\Models\District;
use App\Models\ProgramImplementationAgency;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Laracasts\Flash\Flash;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Response;

class coursescontroller extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $courses = Course::whereIsActive(1)->orderByDesc('id')->get();

        return view('admin.courses.index', compact('courses'));
    }

    public function employercourseList()
    {
        $courses = Course::leftJoin('users', function($join) {
            $join->on('courses.id', '=', 'users.course_id')->where('users.user_role_id', '=', 6)->where('users.status', '=', 1);
          })->leftJoin('program_implementation_agencies', function($join) {
            $join->on('courses.pia_id', '=', 'program_implementation_agencies.id')->where('program_implementation_agencies.is_active', '=', 1);
        })->leftJoin('sectors', function($join) {
            $join->on('courses.sector_id', '=', 'sectors.id')->where('sectors.is_active', '=', 1);
        })->leftJoin('districts', function($join) {
            $join->on('courses.district_id', '=', 'districts.id')->where('districts.is_active', '=', 1);
          })->select('courses.id','sectors.name as sector_name', 'courses.training_name','courses.venue', 'courses.course_status','program_implementation_agencies.agency_name','districts.name as district', Course::raw('count(users.id) as total_students'))->where('courses.is_active', '=', 1)->orderByDesc('id')->groupBy('courses.id')->get();

        return view('employer.trainings.list', compact('courses'));
    }

    public function EmployerviewTrainingProgramme($encryptempID = null)
    {
        if (isset($encryptempID)) {
            $course = Course::find(base64_decode($encryptempID));
            $can_count = Course::leftJoin('users', function($join) {
                $join->on('courses.id', '=', 'users.course_id')->where('users.user_role_id', '=', 6)->where('users.status', '=', 1);
              })->select('courses.id', Course::raw('count(users.id) as total_students'))->where('courses.is_active', '=', 1)->where('courses.id', '=', $course->id)->orderByDesc('id')->groupBy('courses.id')->get();
            //dd($can_count);
            return view('employer.trainings.view', compact('course','can_count'));
        } else {
          
          return $this->employercourseList();
        }
    }

    public function fetchTraining(Request $request,$idSector)
    {
        $data['course'] = CourseMaster::all();
        if ($idSector != null) {
            $Sectorid = $request->input('idSector');
        }
       // dd($Sectorid);
        return response()->json([
            'data' => CourseMaster::whereSectorId($Sectorid)->orderBy('tradename')->get()
        ], 200);

       /* $data['trainings'] = courses::where("sector_id", $request->sector_id)
                                ->get(["course_name", "id"]);
  
        return response()->json($data); */
    }
    public function fetchTradeDuration($tradeId)
{
    // Fetch the trade with the given ID and select only the duration field
    $trade = CourseMaster::where('id', $tradeId)->first(['id', 'tradename', 'duration']);

    // Check if the trade exists
    if (!$trade) {
        return response()->json([
            'message' => 'Trade not found.'
        ], 404);
    }

    // Return the duration of the trade along with other details
    return response()->json([
        'data' => $trade
    ], 200);
}


    public function fetchTrainingCode(Request $request,$idTraining)
    {
        $data['training'] = CourseMaster::all();
        if ($idTraining != null) {
            $Trainingid = $request->input('idTraining');
        }
       // dd($Sectorid);
        return response()->json([
            'data' => CourseMaster::whereId($Trainingid)->get()
        ], 200);
    }

    public function fetchLocalBody(Request $request,$idDistrict)
    {
        //dd($idDistrict);
        $data['localbody'] = Localbody::all();
        if ($idDistrict != null) {
            $Districtid = $request->input('idDistrict');
        }
        //dd($Districtid);
        return response()->json([
            'data' => Localbody::whereDistrictId($Districtid)->get()
        ], 200);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
{
    $CourseMasters = CourseMaster::all();
    $PiaID = ProgramImplementationAgency::whereUserId(auth()->user()->id)->first();
    
    $Sector = PiaSector::whereProgramImplementationAgencyId($PiaID->id)->orderByDesc('id')->get();
    $Skill = Skill::whereIsActive(1)->orderByDesc('id')->get();
    $District = District::whereIsActive(1)->orderByDesc('id')->get();

    return view('admin.courses.create', compact('Sector', 'Skill', 'District', 'CourseMasters'));
}





    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request->input('trainingdropdown'));
        //dd($request);
        try {

            $rules = [
                'SectorID' => 'required|numeric|exists:sectors,id',
                'CourseMasterID' => 'required|numeric|exists:course_masters,id',
               
                'Description' => 'required|string|min:1|max:150',
                'Skill' => 'required|exists:skills,id',
               
                'DistrictID' => 'required|numeric|exists:districts,id',
                'LocalBodyID' => 'numeric|exists:localbodies,id',
                'Venue' => 'required|string|min:1|max:100',
                'start_date' => 'required|date',
                'end_date' => 'date|required|after:start_date',
                
                'GeneralSeats' => 'required|numeric',
                'SCSTSeats' => 'required|numeric',
                'MinoritySeats' => 'required|numeric',
                'TotSeats' => 'required|string',
                'Remarks' => 'sometimes|nullable|string|min:1|max:150',
                'FuturePosssibilities' => 'sometimes|nullable|string|min:1|max:150',
                
               
            ];
            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                $formattedstartDate = Carbon::parse($request->start_date)->format('Y-m-d');
                //dd($formattedstartDate);
                $formattedendDate = Carbon::parse($request->end_date)->format('Y-m-d');

                $course = new Course();
                $course->training_name = $request->TrainingName;
                $course->description = $request->Description;
                $course->sector_id = $request->SectorID;
                $course->district_id = $request->DistrictID;
                $course->pia_id = $request->PIA;
                $course->coursemaster_id = $request->CourseMasterID;
                $course->localbody_id = $request->LocalBodyID;               
                $course->venue = $request->Venue;                                
                $course->start_date = $formattedstartDate;
                $course->end_date = $formattedendDate;
                $course->duration = $request->duration_new;
                $course->training_location = $request->training_location;

                
                $course->general_seats = $request->GeneralSeats;
                $course->scst_seats = $request->SCSTSeats;
                $course->minority_seats = $request->MinoritySeats;
                $course->no_of_seats = $request->TotSeats;
                $course->Remarks = $request->Remarks;
                $course->future_possibilities = $request->FuturePosssibilities;
                $course->course_status = 22; //22=course pending
                $course->save();
                $couid = $course->id;
                //dd($couid);
                $skills = $request->get('Skill');
                
                foreach ($skills as $sk) {
                    $s = new CourseSkillMapping();
                    $s->course_id = $couid;
                    $s->skill_id = $sk;
                    $s->save();
                }

                $response['status'] = "success";
                $response['message'] = "Course added successfully";
                $response['developer_message'] = "";
                $response['redirect'] = route('courseList');

            }
        } catch (\Exception $e) {
            $response['status'] = "error";
            $response['message'] = $e->getMessage();
            
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response); 

    }


    /**
     * Display the specified resource.
     *
     * @param  \App\Models\courses  $courses
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Course  $courses
     * @return \Illuminate\Http\Response
     */
    public function edit($encryptempID = null)
    {

        if(is_null($encryptempID))
        {
            return redirect()->back();
        }

        if (isset($encryptempID)) {

            $course = Course::find(base64_decode($encryptempID));

            if(!$course)
        {
            return redirect()->back();
        }

            $PiaID = ProgramImplementationAgency::whereUserId(auth()->user()->id)->first();
        //dd($PiaID);
            $Sector = PiaSector::whereProgramImplementationAgencyId($PiaID->id)->orderByDesc('id')->get();

            $Skill = Skill::whereIsActive(1)->orderByDesc('id')->get();
    
            $District = District::whereIsActive(1)->orderByDesc('id')->get();

            $CourseMaster = CourseMaster::whereIsActive(1)->orderByDesc('id')->get();
    
            $LocalBody = Localbody::whereIsActive(1)->orderByDesc('id')->get();


            return view('admin.courses.edit', compact('course','Sector','Skill','District','CourseMaster','LocalBody'));

        } else {
          
          return $this->index();
        }

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Course  $courses
     * @return \Illuminate\Http\Response
     */
    

    public function viewTraining($encryptempID = null)
    {
        if (isset($encryptempID)) {
            $course = Course::find(base64_decode($encryptempID));
            //dd($course);
            $rcgs = $course->general_seats - $course->general_seats_filled;
            $rcss = $course->scst_seats - $course->scst_seats_filled;
            $rcms = $course->minority_seats - $course->minority_seats_filled;
            $rcts = $course->no_of_seats - $course->no_of_seats_filled;
            return view('admin.courses.view', compact('course','rcgs','rcss','rcms','rcts'));
        } else {
          
          return $this->index();
        }
    }

    public function employerviewCourse($id)
    {
        $course = Course::find(base64_decode($id));

        return view('admin.courses.view', compact('course'));
    }

    public function updateTrainingDetails(Request $request)
    {   

        //dd($request);
        try {

            $rules = [
                'id' => 'required|numeric|exists:courses,id',
                'SectorID' => 'required|numeric|exists:sectors,id',
                'trainingdropdown' => 'required|numeric|exists:course_masters,id',
                'TrainingName' => 'required|string',
                'Description' => 'required|string',
                'Skill' => 'required|exists:skills,id',
                'PiaID' => '',
                'DistrictID' => 'required|numeric|exists:districts,id',
                'LocalBodyID' => 'required|numeric|exists:localbodies,id',
                'Venue' => 'required',
                'start_date' => 'date|required',
                'end_date' => 'date|required|after:start_date',
                'Duration' => 'required',
                'GeneralSeats' => 'required|numeric',
                'SCSTSeats' => 'required|numeric',
                'MinoritySeats' => 'required|numeric',
                'TotSeats' => 'required|string',
                'Remarks' => '',
                'FuturePossibilities' => '',
                'TPStatus' => 'required|string',
            ];


            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                $formattedstartDate = Carbon::parse($request->start_date)->format('Y-m-d');
                $formattedendDate = Carbon::parse($request->end_date)->format('Y-m-d');
                //remove Block_id
                $course = Course::find($request->id);
                $course->training_name = $request->TrainingName;
                $course->description = $request->Description;
                $course->sector_id = $request->SectorID;
                $course->PIA_id = $request->PiaID;
                $course->district_id = $request->DistrictID;
                $course->coursemaster_id = $request->trainingdropdown;
                $course->localbody_id = $request->LocalBodyID;
                $course->venue = $request->Venue;
                $course->start_date = $formattedstartDate;
                $course->end_date = $formattedendDate;
                $course->duration = $request->Duration;
                $course->general_seats = $request->GeneralSeats;
                $course->scst_seats = $request->SCSTSeats;
                $course->minority_seats = $request->MinoritySeats;
                $course->no_of_seats = $request->TotSeats;
                $course->Remarks = $request->Remarks;
                $course->future_possibilities = $request->FuturePossibilities;
                $course->course_status = $request->TPStatus;
                $course->save();

                CourseSkillMapping::whereCourseId($course->id)->delete();

                $couid = $course->id;

                //dd($couid);

                $skills = $request->get('Skill');
            

                foreach ($skills as $sk) {
                    $s = new CourseSkillMapping();
                    $s->course_id = $couid;
                    $s->skill_id = $sk;
                    $s->save();
                }


                $response['status'] = "success";
                $response['message'] = "Course updated successfully";
                $response['redirect'] = route('courseList');
                $response['developer_message'] = "";

            }


        } catch (\Exception $e) {
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Course  $courses
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Course::whereId($id)->delete();
        return redirect(url('courses'));
    }

    public function deactivateTrainingProgramme(Request $request)
    {


        try {

            $validator = Validator::make($request->all(), ['course' => 'required']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                Course::whereId(base64_decode($request->course))->update(['is_active' => 0]);

                $response['status']="success";
                $response['message']="Course deactivated";
                $response['developer_message']="";
                $response['redirect'] = route('courseList');
                
            }


        } catch (\Exception $e) {

            $response['status']="error";
            $response['message']="Something went wrong";
            $response['developer_message']=$e->getMessage();

        }

        return response()->json($response);
    }
}
