<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Course;
use Illuminate\Http\Request;

class TrainingProgrammeController extends Controller
{
  public function TrainingProgrammeList()
  {
      $courses = Course::leftJoin('users', function($join) {
              $join->on('courses.id', '=', 'users.course_id')
                   ->where('users.user_role_id', '=', 6)
                   ->where('users.status', '=', 1);
          })
          ->leftJoin('program_implementation_agencies', function($join) {
              $join->on('courses.pia_id', '=', 'program_implementation_agencies.id')
                   ->where('program_implementation_agencies.is_active', '=', 1);
          })
          ->leftJoin('sectors', function($join) {
              $join->on('courses.sector_id', '=', 'sectors.id')
                   ->where('sectors.is_active', '=', 1);
          })
          ->leftJoin('districts', function($join) {
              $join->on('courses.district_id', '=', 'districts.id')
                   ->where('districts.is_active', '=', 1);
          })
          ->select(
              'courses.id',
              'sectors.name as sector_name',
              'courses.training_name',
              'courses.venue',
              'courses.course_status',
              'program_implementation_agencies.agency_name',
              'districts.name as district',
              Course::raw('COUNT(users.id) as total_students')
          )
          ->where('courses.is_active', '=', 1)
          ->groupBy(
              'courses.id',
              'sectors.name',
              'courses.training_name',
              'courses.venue',
              'courses.course_status',
              'program_implementation_agencies.agency_name',
              'districts.name'
          )
          ->get();
  
      return view('admin.trainings.list', compact('courses'));
  }
  public function approve($id)
  {
      $course = Course::findOrFail($id);
      $course->course_status = 1; // status 1 = 'Active'
      $course->save();
  
      return redirect()->route('TrainingProgrammeList')->with('success', 'Training Programme approved successfully!');
  }
    

    public function viewTrainingProgramme($encryptempID = null)
    {
        if (isset($encryptempID)) {
            $course = Course::find(base64_decode($encryptempID));
            $can_count = Course::leftJoin('users', function($join) {
                $join->on('courses.id', '=', 'users.course_id')->where('users.user_role_id', '=', 6)->where('users.status', '=', 1);
              })->select('courses.id', Course::raw('count(users.id) as total_students'))->where('courses.is_active', '=', 1)->where('courses.id', '=', $course->id)->groupBy('courses.id')->get();
            //dd($can_count);
            return view('admin.trainings.view', compact('course','can_count'));
        } else {
          
          return $this->TrainingProgrammeList();
        }
    }
}
