<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\SkilController;
use App\Models\Skill;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

class SkillController extends Controller
{
    public function SkillList()
    {
        $Skills = Skill::whereIsActive(1)->orderByDesc('id')->get();

        return view('admin.skills.list', compact('Skills'));
    }

    public function viewSkill($encryptempID = null)
    {
        if (isset($encryptempID)) {
            $Skill = Skill::find(base64_decode($encryptempID));
            return view('admin.skills.view', compact('Skill'));
        } else {
          
          return $this->SkillList();
        }
    }

    public function createSkill()
    {
        return view('admin.skills.create');
    }

    public function submitSkillDetails(Request $request)
    {

        try {

            $rules = [
                'skill' => 'required|string|min:1|max:20',
            
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                DB::beginTransaction();

                $skill = new Skill();
                $skill->name = $request->skill;
                $skill->is_active = 1;
                $skill->save();

                DB::commit();


                if ($skill->id > 0) {
                    $response['status'] = "success";
                    $response['message'] = "Skill added successfully";
                    $response['redirect'] = route('SkillList');
                    $response['developer_message'] = "";
                } else {

                    $response['status'] = "error";
                    $response['message'] = "Something went wrong";
                    $response['developer_message'] = "";


                }

            }


        } catch (\Exception $e) {

            DB::rollBack();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function editSkill($encryptempID = null)
    {
        if (isset($encryptempID)) {
            $Skill = Skill::find(base64_decode($encryptempID));
            return view('admin.skills.edit', compact('Skill'));
        } else {
          
          return $this->SkillList();
        }
    }

    public function updateSkillDetails(Request $request)
    {   

        //dd($request);
        try {

            $rules = [
                'id' => 'required|numeric|exists:skills,id',
                'skill' => 'required|string|min:1|max:20'.$request->id,
            ];


            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                $skill = Skill::find($request->id);
                $skill->name = $request->skill;
                $skill->save();

                $response['status'] = "success";
                $response['message'] = "Skill updated successfully";
                $response['developer_message'] = "";
                $response['redirect'] = route('SkillList');
            }


        } catch (\Exception $e) {
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }



}
