<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Sector;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

class SectorController extends Controller
{
    //
    public function sectorList()
    {
        $sector_details = Sector::whereIsActive(1)->orderByDesc('id')->get();
        // dd($sector_details);

        return view('admin.sector.list', compact('sector_details'));
    }

    public function addSector()
    {
        return view('admin.sector.add');
    }

    public function submitSector(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), [
                'sector_name' => 'required|unique:sectors,name|max:80',
                'sector_code' => 'required|unique:sectors,code|max:3'
            ]);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode("", $validator->errors()->all());
                $response['developer_message'] = implode("", $validator->errors()->all());
            } else {

                DB::beginTransaction();

                $sector = new Sector();
                $sector->name = $request->sector_name;
                $sector->code = $request->sector_code;
                $sector->is_active = 1;
                $sector->save();

                DB::commit();

                if ($sector->id > 0) {

                    $response['status'] = "success";
                    $response['message'] = "Sector saved successfully";
                    $response['developer_message'] = "";

                } else {

                    $response['status'] = "error";
                    $response['message'] = "Something went wrong";
                    $response['developer_message'] = "";
                }

            }


        } catch (\Exception $e) {

            DB::rollBack();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);
    }

    public function editSector($sector_id = null)
    {

        if (!$sector_id) {
            return redirect()->back();
        }

        $sector = Sector::find(base64_decode($sector_id));

        if (!$sector) {
            return redirect()->back();
        }

        return view('admin.sector.edit', compact('sector'));

    }

    public function updateSector(Request $request)
    {

        try {

            $id = base64_decode($request->sector);

            $data = [
                'id' => $id,
                'name' => $request->sector_name,
                'code' => $request->sector_code
            ];

            $validator = Validator::make($data, [
                'id' => 'required|numeric|exists:sectors,id|max:80',
                'name' => 'required|string|unique:sectors,name,' . $id,
                'code' => 'required|string|max:3|unique:sectors,code,' . $id
            ]);

            if($validator->fails())
            {
                $response['status']="error";
                $response['message']=implode("",$validator->errors()->all());
                $response['developer_message']=implode("",$validator->errors()->all());
            }

            else{

                $sector=Sector::find($id);
                $sector->name=$data['name'];
                $sector->code=$data['code'];
                $sector->save();

                if($sector->id>0)
                {
                    $response['status']="success";
                    $response['message']="Sector Updated successfully";
                }

                else{

                    $response['status']="error";
                    $response['message']="Something went wrong";
                }
            }



        } catch (\Exception $e) {
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();
        }

        return response()->json($response);
    }
}
