<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use DateTime;
use Illuminate\Http\Request;
use App\Models\ProgramImplementationAgency;
use App\Models\Course;
use App\Models\CourseMaster;
use App\Models\User;
use App\Models\CandidateInterest;
use App\Models\CanadidateInterestCourseMaster;
use App\Models\State;
use App\Models\District;
use App\Models\Sector;
use App\Models\JobVacancy;
use App\Models\Recruitment;
use Barryvdh\DomPDF\Facade\Pdf as PDF;
use Illuminate\Support\Facades\Validator;
use App\Models\PiaSector;
use App\Models\Block;
use Dompdf\Dompdf;
use Dompdf\Options;


class ReportController extends Controller
{
    public function piaReport()
    {
        $list = ProgramImplementationAgency::whereIsActive(1)->get();

        $sectors = Sector::whereIsActive(1)->get();

        $course_masters_list = CourseMaster::whereIsActive(1)->get();

        $data = array();

        foreach ($list as $pia) {

            $training_programs = Course::wherePiaId($pia->id)->whereIsActive(1)->get();

            $course_masters = array();

            foreach ($training_programs as $program) {
                if (!in_array($program->course_master_id, $course_masters)) {
                    array_push($course_masters, $program->coursemaster_id);
                }
            }

            // print_r($course_masters);



            if (count($course_masters) > 0) {

                foreach ($course_masters as $key => $course_master) {


                    $CourseMaster = CourseMaster::find($course_master);

                    $courses = Course::where('coursemaster_id', $course_master)->wherePiaId($pia->id)->whereIsActive(1)->get();

                    $total_joined_candidates = 0;
                    $total_course_completed_candidates = 0;
                    $total_placed_candidates = 0;



                    foreach ($courses as $key => $course) {
                        $total_joined_candidates += $joined_candidates = User::whereCourseId($course->id)->get()->count();

                        $total_course_completed_candidates += User::whereCourseId($course->id)->whereCourseCompletionStatus(3)->get()->count();

                        $total_placed_candidates += User::whereCourseId($course->id)->wherePlacementStatus(5)->get()->count();


                    }



                    array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => $CourseMaster->tradename, 'No of Training Programs' => $courses->count(), 'No of candidates joined' => $total_joined_candidates, 'Course completed candidates' => $total_course_completed_candidates, 'Candidates with placements' => $total_placed_candidates));

                }

            } else {

                array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => "No courses", 'No of Training Programs' => 0, 'No of candidates joined' => 0, 'Course completed candidates' => 0, 'Candidates with placements' => 0));



            }



        }

        return view('admin.reports.pia', ['pia_list' => $list, 'sectors' => $sectors, 'course_masters' => $course_masters_list]);

    }

    public function filterPiaReport(Request $request)
    {

        if ($request->pia) {

            if ($request) {

            }

        }

    }


    

    public function testPdf()
    {

        $pdf = PDF::loadview('test_pdf');

        return $pdf->stream('report.pdf');
    }

    public function generatePiaReport(Request $request)
    {

        try {

            $request->pia_filter = ($request->pia_filter) ? base64_decode($request->pia_filter) : $request->pia_filter;
            $request->sector_filter = ($request->sector_filter) ? base64_decode($request->sector_filter) : $request->sector_filter;
            $request->course_filter = ($request->course_filter) ? base64_decode($request->course_filter) : $request->course_filter;

            if (is_null($request->pia_filter) && is_null($request->sector_filter) && is_null($request->course_filter)) {

                $list = ProgramImplementationAgency::whereIsActive(1)->get();


                $data = array();

                foreach ($list as $pia) {

                    $training_programs = Course::wherePiaId($pia->id)->whereIsActive(1)->get();

                    $course_masters = array();

                    foreach ($training_programs as $program) {
                        if (!in_array($program->course_master_id, $course_masters)) {
                            array_push($course_masters, $program->coursemaster_id);
                        }
                    }



                    if (count($course_masters) > 0) {

                        foreach ($course_masters as $key => $course_master) {


                            $CourseMaster = CourseMaster::find($course_master);

                            $courses = Course::where('coursemaster_id', $course_master)->wherePiaId($pia->id)->whereIsActive(1)->get();

                            $total_joined_candidates = 0;
                            $total_course_completed_candidates = 0;
                            $total_placed_candidates = 0;



                            foreach ($courses as $key => $course) {
                                $total_joined_candidates += $joined_candidates = User::whereCourseId($course->id)->get()->count();

                                $total_course_completed_candidates += User::whereCourseId($course->id)->whereCourseCompletionStatus(3)->get()->count();

                                $total_placed_candidates += User::whereCourseId($course->id)->wherePlacementStatus(5)->get()->count();


                            }



                            array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => $CourseMaster->tradename, 'No of Training Programs' => $courses->count(), 'No of candidates joined' => $total_joined_candidates, 'Course completed candidates' => $total_course_completed_candidates, 'Candidates with placements' => $total_placed_candidates));

                        }

                    } else {

                        array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => "No courses", 'No of Training Programs' => 0, 'No of candidates joined' => 0, 'Course completed candidates' => 0, 'Candidates with placements' => 0));



                    }



                }


            } else if ($request->pia_filter && is_null($request->sector_filter) && is_null($request->course_filter)) {

                $pia = ProgramImplementationAgency::find($request->pia_filter);

                $data = array();



                $training_programs = Course::wherePiaId($pia->id)->whereIsActive(1)->get();

                $course_masters = array();

                foreach ($training_programs as $program) {
                    if (!in_array($program->course_master_id, $course_masters)) {
                        array_push($course_masters, $program->coursemaster_id);
                    }
                }



                if (count($course_masters) > 0) {

                    foreach ($course_masters as $key => $course_master) {


                        $CourseMaster = CourseMaster::find($course_master);

                        $courses = Course::where('coursemaster_id', $course_master)->wherePiaId($pia->id)->whereIsActive(1)->get();

                        $total_joined_candidates = 0;
                        $total_course_completed_candidates = 0;
                        $total_placed_candidates = 0;



                        foreach ($courses as $key => $course) {
                            $total_joined_candidates += $joined_candidates = User::whereCourseId($course->id)->get()->count();

                            $total_course_completed_candidates += User::whereCourseId($course->id)->whereCourseCompletionStatus(3)->get()->count();

                            $total_placed_candidates += User::whereCourseId($course->id)->wherePlacementStatus(5)->get()->count();


                        }



                        array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => $CourseMaster->tradename, 'No of Training Programs' => $courses->count(), 'No of candidates joined' => $total_joined_candidates, 'Course completed candidates' => $total_course_completed_candidates, 'Candidates with placements' => $total_placed_candidates));

                    }

                } else {

                    array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => "No courses", 'No of Training Programs' => 0, 'No of candidates joined' => 0, 'Course completed candidates' => 0, 'Candidates with placements' => 0));



                }



            } else if ($request->pia_filter && $request->sector_filter && is_null($request->course_filter)) {

                $search = PiaSector::whereProgramImplementationAgencyId($request->pia_filter)->whereSectorId($request->sector_filter)->first();

                if ($search) {


                    $pia = ProgramImplementationAgency::find($request->pia_filter);

                    $data = array();



                    $training_programs = Course::wherePiaId($pia->id)->whereSectorId($request->sector_filter)->whereIsActive(1)->get();

                    $course_masters = array();

                    foreach ($training_programs as $program) {


                        if (!in_array($program->course_master_id, $course_masters)) {
                            array_push($course_masters, $program->coursemaster_id);
                        }
                    }



                    if (count($course_masters) > 0) {

                        foreach ($course_masters as $key => $course_master) {


                            $CourseMaster = CourseMaster::find($course_master);

                            $courses = Course::where('coursemaster_id', $course_master)->wherePiaId($pia->id)->whereIsActive(1)->get();

                            $total_joined_candidates = 0;
                            $total_course_completed_candidates = 0;
                            $total_placed_candidates = 0;



                            foreach ($courses as $key => $course) {
                                $total_joined_candidates += $joined_candidates = User::whereCourseId($course->id)->get()->count();

                                $total_course_completed_candidates += User::whereCourseId($course->id)->whereCourseCompletionStatus(3)->get()->count();

                                $total_placed_candidates += User::whereCourseId($course->id)->wherePlacementStatus(5)->get()->count();


                            }



                            array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => $CourseMaster->tradename, 'No of Training Programs' => $courses->count(), 'No of candidates joined' => $total_joined_candidates, 'Course completed candidates' => $total_course_completed_candidates, 'Candidates with placements' => $total_placed_candidates));

                        }

                    } else {

                        array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => "No courses", 'No of Training Programs' => 0, 'No of candidates joined' => 0, 'Course completed candidates' => 0, 'Candidates with placements' => 0));



                    }

                } else {

                    $request->session()->flash("error", "Selected Pia not belongs to selected sector");

                    return redirect()->back();
                }



            } else if ($request->pia_filter && is_null($request->sector_filter) && $request->course_filter) {


                $pia = ProgramImplementationAgency::find($request->pia_filter);

                $data = array();



                $training_programs = Course::wherePiaId($pia->id)->whereCoursemasterId($request->course_filter)->whereIsActive(1)->get();

                $course_masters = array();

                foreach ($training_programs as $program) {
                    if (!in_array($program->course_master_id, $course_masters)) {
                        array_push($course_masters, $program->coursemaster_id);
                    }
                }



                if (count($course_masters) > 0) {

                    foreach ($course_masters as $key => $course_master) {


                        $CourseMaster = CourseMaster::find($course_master);

                        $courses = Course::where('coursemaster_id', $course_master)->wherePiaId($pia->id)->whereIsActive(1)->get();

                        $total_joined_candidates = 0;
                        $total_course_completed_candidates = 0;
                        $total_placed_candidates = 0;



                        foreach ($courses as $key => $course) {
                            $total_joined_candidates += $joined_candidates = User::whereCourseId($course->id)->get()->count();

                            $total_course_completed_candidates += User::whereCourseId($course->id)->whereCourseCompletionStatus(3)->get()->count();

                            $total_placed_candidates += User::whereCourseId($course->id)->wherePlacementStatus(5)->get()->count();


                        }



                        array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => $CourseMaster->tradename, 'No of Training Programs' => $courses->count(), 'No of candidates joined' => $total_joined_candidates, 'Course completed candidates' => $total_course_completed_candidates, 'Candidates with placements' => $total_placed_candidates));

                    }

                } else {

                    array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => "No courses", 'No of Training Programs' => 0, 'No of candidates joined' => 0, 'Course completed candidates' => 0, 'Candidates with placements' => 0));



                }





            } else if ($request->sector_filter && is_null($request->pia_filter) && is_null($request->course_filter)) {

                $search = PiaSector::whereSectorId($request->sector_filter)->get();

                $pias = array();

                foreach ($search as $s) {
                    array_push($pias, $s->program_implementation_agency_id);
                }


                $list = ProgramImplementationAgency::whereIsActive(1)->whereIn('id', $pias)->get();

                $data = array();

                foreach ($list as $pia) {

                    $training_programs = Course::wherePiaId($pia->id)->whereSectorId($request->sector_filter)->whereIsActive(1)->get();

                    $course_masters = array();

                    foreach ($training_programs as $program) {

                        if (!in_array($program->course_master_id, $course_masters)) {
                            array_push($course_masters, $program->coursemaster_id);
                        }
                    }

                    // print_r($course_masters);



                    if (count($course_masters) > 0) {

                        foreach ($course_masters as $key => $course_master) {


                            $CourseMaster = CourseMaster::find($course_master);

                            $courses = Course::where('coursemaster_id', $course_master)->wherePiaId($pia->id)->whereIsActive(1)->get();

                            $total_joined_candidates = 0;
                            $total_course_completed_candidates = 0;
                            $total_placed_candidates = 0;



                            foreach ($courses as $key => $course) {
                                $total_joined_candidates += $joined_candidates = User::whereCourseId($course->id)->get()->count();

                                $total_course_completed_candidates += User::whereCourseId($course->id)->whereCourseCompletionStatus(3)->get()->count();

                                $total_placed_candidates += User::whereCourseId($course->id)->wherePlacementStatus(5)->get()->count();


                            }



                            array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => $CourseMaster->tradename, 'No of Training Programs' => $courses->count(), 'No of candidates joined' => $total_joined_candidates, 'Course completed candidates' => $total_course_completed_candidates, 'Candidates with placements' => $total_placed_candidates));

                        }

                    } else {

                        array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => "No courses", 'No of Training Programs' => 0, 'No of candidates joined' => 0, 'Course completed candidates' => 0, 'Candidates with placements' => 0));



                    }



                }

            } else if ($request->sector_filter && $request->course_filter && is_null($request->pia_filter)) {


                $search = Course::whereSectorId($request->sector_filter)->whereCoursemasterId($request->course_filter)->whereIsActive(1)->get();

                $pias = array();

                foreach ($search as $s) {
                    array_push($pias, $s->pia_id);
                }

                $list = ProgramImplementationAgency::whereIsActive(1)->whereIn('id', $pias)->get();


                $data = array();

                foreach ($list as $pia) {

                    $training_programs = Course::wherePiaId($pia->id)->whereCoursemasterId($request->course_filter)->whereIsActive(1)->get();

                    $course_masters = array();

                    foreach ($training_programs as $program) {
                        if (!in_array($program->course_master_id, $course_masters)) {
                            array_push($course_masters, $program->coursemaster_id);
                        }
                    }


                    if (count($course_masters) > 0) {

                        foreach ($course_masters as $key => $course_master) {


                            $CourseMaster = CourseMaster::find($course_master);

                            $courses = Course::where('coursemaster_id', $course_master)->wherePiaId($pia->id)->whereIsActive(1)->get();

                            $total_joined_candidates = 0;
                            $total_course_completed_candidates = 0;
                            $total_placed_candidates = 0;



                            foreach ($courses as $key => $course) {
                                $total_joined_candidates += $joined_candidates = User::whereCourseId($course->id)->get()->count();

                                $total_course_completed_candidates += User::whereCourseId($course->id)->whereCourseCompletionStatus(3)->get()->count();

                                $total_placed_candidates += User::whereCourseId($course->id)->wherePlacementStatus(5)->get()->count();


                            }



                            array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => $CourseMaster->tradename, 'No of Training Programs' => $courses->count(), 'No of candidates joined' => $total_joined_candidates, 'Course completed candidates' => $total_course_completed_candidates, 'Candidates with placements' => $total_placed_candidates));

                        }

                    } else {

                        array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => "No courses", 'No of Training Programs' => 0, 'No of candidates joined' => 0, 'Course completed candidates' => 0, 'Candidates with placements' => 0));



                    }



                }

            } else if ($request->course_filter && is_null($request->pia_filter) && is_null($request->sector_filter)) {

                $search = Course::whereCoursemasterId($request->course_filter)->whereIsActive(1)->get();

                $pias = array();

                foreach ($search as $s) {
                    array_push($pias, $s->pia_id);
                }


                $list = ProgramImplementationAgency::whereIsActive(1)->whereIn('id', $pias)->get();


                $data = array();

                foreach ($list as $pia) {

                    $training_programs = Course::wherePiaId($pia->id)->whereCoursemasterId($request->course_filter)->whereIsActive(1)->get();

                    $course_masters = array();

                    foreach ($training_programs as $program) {
                        if (!in_array($program->course_master_id, $course_masters)) {
                            array_push($course_masters, $program->coursemaster_id);
                        }
                    }



                    if (count($course_masters) > 0) {

                        foreach ($course_masters as $key => $course_master) {


                            $CourseMaster = CourseMaster::find($course_master);

                            $courses = Course::where('coursemaster_id', $course_master)->wherePiaId($pia->id)->whereIsActive(1)->get();

                            $total_joined_candidates = 0;
                            $total_course_completed_candidates = 0;
                            $total_placed_candidates = 0;



                            foreach ($courses as $key => $course) {
                                $total_joined_candidates += $joined_candidates = User::whereCourseId($course->id)->get()->count();

                                $total_course_completed_candidates += User::whereCourseId($course->id)->whereCourseCompletionStatus(3)->get()->count();

                                $total_placed_candidates += User::whereCourseId($course->id)->wherePlacementStatus(5)->get()->count();


                            }



                            array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => $CourseMaster->tradename, 'No of Training Programs' => $courses->count(), 'No of candidates joined' => $total_joined_candidates, 'Course completed candidates' => $total_course_completed_candidates, 'Candidates with placements' => $total_placed_candidates));

                        }

                    } else {

                        array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => "No courses", 'No of Training Programs' => 0, 'No of candidates joined' => 0, 'Course completed candidates' => 0, 'Candidates with placements' => 0));



                    }



                }

            } else if ($request->pia_filter && $request->sector_filter && $request->course_filter) {

                $search = PiaSector::whereSectorId($request->sector_filter)->whereProgramImplementationAgencyId($request->pia_filter)->get();

                $pias = array();

                foreach ($search as $s) {
                    array_push($pias, $s->program_implementation_agency_id);
                }

                $pia = ProgramImplementationAgency::whereIsActive(1)->whereIn('id', $pias)->first();

                if ($pia) {

                    $data = array();


                    $training_programs = Course::wherePiaId($pia->id)->whereCoursemasterId($request->course_filter)->whereSectorId($request->sector_filter)->whereIsActive(1)->get();

                    $course_masters = array();

                    foreach ($training_programs as $program) {
                        if (!in_array($program->course_master_id, $course_masters)) {
                            array_push($course_masters, $program->coursemaster_id);
                        }
                    }



                    if (count($course_masters) > 0) {

                        foreach ($course_masters as $key => $course_master) {


                            $CourseMaster = CourseMaster::find($course_master);

                            $courses = Course::where('coursemaster_id', $course_master)->wherePiaId($pia->id)->whereIsActive(1)->get();

                            $total_joined_candidates = 0;
                            $total_course_completed_candidates = 0;
                            $total_placed_candidates = 0;



                            foreach ($courses as $key => $course) {
                                $total_joined_candidates += $joined_candidates = User::whereCourseId($course->id)->get()->count();

                                $total_course_completed_candidates += User::whereCourseId($course->id)->whereCourseCompletionStatus(3)->get()->count();

                                $total_placed_candidates += User::whereCourseId($course->id)->wherePlacementStatus(5)->get()->count();


                            }



                            array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => $CourseMaster->tradename, 'No of Training Programs' => $courses->count(), 'No of candidates joined' => $total_joined_candidates, 'Course completed candidates' => $total_course_completed_candidates, 'Candidates with placements' => $total_placed_candidates));

                        }

                    } else {

                        array_push($data, array('PIA Name' => $pia->agency_name, 'Courses' => "No courses", 'No of Training Programs' => 0, 'No of candidates joined' => 0, 'Course completed candidates' => 0, 'Candidates with placements' => 0));



                    }


                } else {

                    $request->session()->flash("error", "Selected Pia does not belongs to selected sector");

                    return redirect()->back();
                }




            } else {

                $request->session()->flash("error", "Unknown search filter combination");

                return redirect()->back();
            }

            if (count($data) > 0) {

                // print_r($data);

            } else {

                $request->session()->flash("error", "No result found");

                return redirect()->back();
            }



            switch ($request->report_type) {

                case "pdf_report":

                    $pdf = PDF::loadview('admin.reports.pia_report_pdf', ['data' => $data]);

                    return $pdf->stream('pia_report.pdf');

                //return view('admin.reports.pia_report_pdf', compact('data'));


                case "csv_report":

                    header('Content-Type: text/csv');
                    header('Content-Disposition: attachment; filename="pia_report.csv"');


                    $fp = fopen('php://output', 'wb');

                    $print_header = false;
                    foreach ($data as $line) {

                        if (!$print_header) {
                            fputcsv($fp, array_keys($line));

                            $print_header = true;
                        }



                        fputcsv($fp, $line);
                    }

                    fputcsv($fp, array("", "", "", "", "", ""));

                    fputcsv($fp, array("Generated On:" . date('d M Y h:i:s a'), "", "", "", "", ""));
                    fclose($fp);

                    break;

                default:
                    $request->session()->flash("error", "Invalid report type");
                    return redirect()->back();

            }


        } catch (\Exception $e) {

            //  echo "Something went wrong";

            echo $e->getMessage();

            //  $request->session()->flash("error", $e->getMessage());

            $request->session()->flash("error", "Something went wrong");


            \Log::error($e->getMessage());

            return redirect()->back();


        }

    }
    public function training_programs()
    {
        $list = ProgramImplementationAgency::whereIsActive(1)->get();
        $course_masters = CourseMaster::whereIsActive(1)->get();
        $districts = District::whereIsActive(1)->get();
        return view('admin.reports.training_programs', ['pia_list' => $list, 'districts' => $districts, 'course_masters' => $course_masters]);
    }
    public function generateTrainingProgramReport(Request $request)
    {

        $pia_filter = isset($request->pia_filter) ? $request->pia_filter : NULL;
        $district_filter = isset($request->district_filter) ? $request->district_filter : NULL;
        $course_master_filter = isset($request->course_master_filter) ? $request->course_master_filter : NULL;



        $trainig_programs_obj = Course::leftJoin('users', function ($join) {
            $join->on('courses.id', '=', 'users.course_id')->where('users.user_role_id', '=', 6)->where('users.status', '=', 1);
        })->leftJoin('course_masters', function ($join) {
            $join->on('courses.coursemaster_id', '=', 'course_masters.id')->where('course_masters.is_active', '=', 1);
        })->leftJoin('districts', function ($join) {
            $join->on('courses.district_id', '=', 'districts.id')->where('districts.is_active', '=', 1);
        })->leftJoin('program_implementation_agencies', function ($join) {
            $join->on('courses.pia_id', '=', 'program_implementation_agencies.id')->where('program_implementation_agencies.is_active', '=', 1);
          })->select('courses.id', 'courses.training_name', 'courses.course_status', 'courses.start_date', 'courses.end_date', 'course_masters.tradename', 'districts.name as district_name', 'program_implementation_agencies.agency_name', Course::raw('count(users.id) as total_students'), Course::raw('sum(CASE WHEN users.course_completion_status = "3" THEN 1 ELSE 0 END) as completed_students'))->where('courses.course_status', '!=', 11)->where('courses.is_active', '=', 1)->orderBy('courses.id','DESC')->groupBy('courses.id');

        if ($district_filter) {
            $trainig_programs_obj = $trainig_programs_obj->where('courses.district_id', '=', $district_filter);
        }
        if ($pia_filter) {
            $trainig_programs_obj = $trainig_programs_obj->where('courses.pia_id', '=', $pia_filter);
        }
        if ($course_master_filter) {
            $trainig_programs_obj = $trainig_programs_obj->where('courses.coursemaster_id', '=', $course_master_filter);
        }

        $trainig_programs = $trainig_programs_obj->get();

        $data = array();

        foreach ($trainig_programs as $trainig_program) {
            switch ($trainig_program->course_status) {
                case 1:
                    $course_status = "Active";
                    break;
                case 2:
                    $course_status = "Joined";
                    break;
                case 3:
                    $course_status = "Open to Work";
                    break;
                case 4:
                    $course_status = "Completed";
                    break;
                case 5:
                    $course_status = "Placed";
                    break;
                case 6:
                    $course_status = "Discontinued";
                    break;                          
                case 7:
                    $course_status = "In Progress";
                    break;
                case 8:
                    $course_status = "Soft Delete";
                    break;
                case 9:
                    $course_status = "Cancelled";
                    break;    
                case 10:
                    $course_status = "Postponed";
                    break;    
                case 11:
                    $course_status = "Inactive";
                    break;
                default:
                    $course_status = "Others";
            }

        array_push(
            $data,
            array(
                "Training Programs" => $trainig_program->training_name,
                "PIA" => $trainig_program->agency_name,
                "Course" => $trainig_program->training_name,
                "District" =>  $trainig_program->district_name,
                "Start Date" => date("d-m-Y", strtotime( date( $trainig_program->start_date ))),
                "End Date" => date("d-m-Y", strtotime( date( $trainig_program->end_date ))),
                "No. of candidates joined" => $trainig_program->total_students,
                "No. of candidates completed" => $trainig_program->completed_students,
                "Status" => $course_status
               )
        );

        }

        if($request->action == 'generate_traning_pdf_report'){
            $pdf = PDF::loadview('admin.reports.training_programs_pdf', ['data' => $data]);
            return $pdf->stream('training_programs_report.pdf');
        }elseif($request->action == 'generate_traning__csv_report'){

         
            
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment; filename="training_programs_report.csv"');


            $fp = fopen('php://output', 'wb');

            $print_header = false;
            fputcsv($fp, array("TALENTO CONNECT", "", "", "", "", ""));
            fputcsv($fp, array("Training Programs Report", "", "", "", "", ""));
            
            fputcsv($fp, array("", "", "", "", "", ""));
            foreach ($data as $line) {

                if (!$print_header) {
                    fputcsv($fp, array_keys($line));

                    $print_header = true;
                }

                fputcsv($fp, $line);
            }

            fputcsv($fp, array("", "", "", "", "", ""));
            fputcsv($fp, array("This report generated on " . date('d M Y g:i a',strtotime(now())), "", "", "", "", ""));
           
            if(empty($data)){
                fputcsv($fp, array("No data found", "", "", "", "", ""));
               }
            fclose($fp);

        }

    }
    
    public function getPiaCourseByDistrict(Request $request)
    {


        if (!$request->district) {
            $pias = ProgramImplementationAgency::whereIsActive(1)->get();
            $courses = Course::whereIsActive(1)->get();
            $response['status'] = "success";
            $response['message'] = "";
            $response['pias'] = $pias;
            $response['courses'] = $courses;
        } else {

            $pias = ProgramImplementationAgency::whereDistrictId($request->district)->whereIsActive(1)->get();
            $courses = Course::whereDistrictId($request->district)->whereIsActive(1)->get();



            $response['status'] = "success";
            $response['message'] = "";
            $response['pias'] = $pias;
            $response['courses'] = $courses;
        }

        return response()->json($response);

    }

    public function InterestedCandidatesReport()
    {
        $districts = District::whereIsActive(1)->get();
        $course_masters = CourseMaster::whereIsActive(1)->get();

        return view('admin.reports.candidateInterest', compact('districts', 'course_masters'));
    }

    public function loadBlocks(Request $request)
    {
        $validator = Validator::make(['district' => base64_decode($request->district)], ['district' => 'required|numeric']);

        if ($validator->fails()) {
            $response['status'] = "error";
            $response['message'] = implode(",", $validator->errors()->all());
        } else {

            $blocks = Block::whereDistrictId(base64_decode($request->district))->get();

            foreach ($blocks as $key => $block) {
                $blocks[$key]->encoded_id = base64_encode($block->id);
            }

            $response['status'] = "success";
            $response['message'] = "";
            $response['blocks'] = $blocks;
        }

        return response()->json($response);


    }

    public function generateInterestedCandidatesReport(Request $request)
    {

        try {
            $district_filter = ($request->district_filter) ? base64_decode($request->district_filter) : $request->district_filter;
            $block_filter = ($request->block_filter) ? base64_decode($request->block_filter) : $request->block_filter;
            $course_filter = ($request->course_filter) ? base64_decode($request->course_filter) : $request->course_filter;
            $gender_filter = ($request->gender_filter) ? base64_decode($request->gender_filter) : $request->gender_filter;
            $category_filter = ($request->category_filter) ? base64_decode($request->category_filter) : $request->category_filter;

            $data = array();
          
            $query = CandidateInterest::query();          
            
                     
           
            if ($district_filter) {
                $query->where('district_id', $district_filter);
 
            }
            if ($gender_filter) {
                $query->where('gender', $gender_filter);
 
            }
            if ($category_filter) {
                $query->where('category', $category_filter);
 
            }
            if ($block_filter) {
                $query->where('block_id', $block_filter);
 
            }
            $cflag=0;
            if ($course_filter) {

                $cflag=1;
                $query->join('canadidate_interest_course_masters', function ($join) {
                    $join->on('candidate_interests.id', '=', 'canadidate_interest_course_masters.candidate_interest_id');
                    
                });
                $query->join('course_masters', function ($join) {
                    $join->on('course_masters.id', '=', 'canadidate_interest_course_masters.course_master_id');
                    
                });
                
                $query->where('course_master_id', $course_filter);
 
            }
            //dd( $query);
            // Execute the query
            $candidates = $query->get();
            $course ="";

            foreach ($candidates as $key => $candidate) {
            $course ="";

                if( $cflag==0){
                   
                    foreach ($candidate->CandidateInterests as $key=>$masterID){
                     //   echo  $candidate->id;
                        if($key==0){
                            $course .=   $masterID->CourseMaster->tradename;
                        }else{
                            $course .=   ",".$masterID->CourseMaster->tradename;
                        }
                    }
              }
               
                if ($candidate->dob) {
                    $dob = new DateTime($candidate->dob);
                    $now = new DateTime();

                    $interval = $dob->diff($now);

                    $age = $interval->y;

                } else {

                    $age = "Not available";

                }

                if($course ==""){
                    $course = $candidate->tradename; 
                }
                array_push(
                    $data,
                    array(
                        "Name" => $candidate->name,
                        "Gender" => $candidate->gender,
                        "Age" => $age,
                        "Email" => $candidate->email,
                        "MobileNumber" => $candidate->mobile_Number,
                        "Qualification" => $candidate->highest_qualification,
                        "District" => $candidate->District->name,
                        "Block" => $candidate->Block->name,
                        "Category" => $candidate->category,
                        "Course" =>$course,                       
                        "RationCradType" => $candidate->rationcardtype
                        
            
                    )
                );
            }

            if (count($data) > 0) {

                switch ($request->report_type) {

                    case "pdf_report":

                        $pdf = PDF::loadview('admin.reports.candidates_interested_report_pdf', ['data' => $data]);

                        return $pdf->stream('Interested_candidates_report.pdf');

                    //return view('admin.reports.pia_report_pdf', compact('data'));


                    case "csv_report":

                        header('Content-Type: text/csv');
                        header('Content-Disposition: attachment; filename="Interested_candidates_report.csv"');


                        $fp = fopen('php://output', 'wb');

                        $print_header = false;
                        foreach ($data as $line) {

                            if (!$print_header) {
                                fputcsv($fp, array_keys($line));

                                $print_header = true;
                            }

                            fputcsv($fp, $line);
                        }

                        fputcsv($fp, array("", "", "", "", "", ""));

                        fputcsv($fp, array("Generated On:" . date('d M Y h:i:s a'), "", "", "", "", ""));
                        fclose($fp);

                        break;

                    default:
                        $request->session()->flash("error", "Invalid report type");
                        return redirect()->back();

                }
            } else {

                $request->session()->flash("error", "No result found");

                return redirect()->back();
            }


        } catch (\Exception $e) {
            \Log::error($e->getMessage());

            //  $request->session()->flash("error", $e->getMessage());

            $request->session()->flash("error", "Something went wrong");

            return redirect()->back();
        }





    }

    public function CandidatesReport()
    {
        $districts = District::whereIsActive(1)->get();
        $course_masters = Course::whereIsActive(1)->get();

        return view('admin.reports.candidate', compact('districts', 'course_masters'));
    }
    public function CandidatesReport_Pia()
    {
        $districts = District::whereIsActive(1)->get();
        $course_masters = Course::whereIsActive(1)->get();

        return view('pia.reports.candidate', compact('districts', 'course_masters'));
    }


    public function generateCandidatesReport(Request $request)
    {

        try {

            $district_filter = ($request->district_filter) ? base64_decode($request->district_filter) : $request->district_filter;
            $block_filter = ($request->block_filter) ? base64_decode($request->block_filter) : $request->block_filter;
            $course_filter = ($request->course_filter) ? base64_decode($request->course_filter) : $request->course_filter;
            $gender_filter = ($request->gender_filter) ? base64_decode($request->gender_filter) : $request->gender_filter;
            $category_filter = ($request->category_filter) ? base64_decode($request->category_filter) : $request->category_filter;

            $data = array();
            $CandidateType = $request->CandidateType;
            $query = User::query();

            if ($CandidateType == 'Completed') {

                $query->where('course_completion_status', 3)->where('user_role_id', '=', 6);

                if ($district_filter) {
                    $query->where('district_id', $district_filter);
    
                }
                if ($gender_filter) {
                    $query->where('gender', $gender_filter);
    
                }
                if ($category_filter) {
                    $query->where('category', $category_filter);
    
                }
                if ($block_filter) {
                    $query->where('block_id', $block_filter);
    
                }
                if ($course_filter) {
                    $query->where('course_id', $course_filter);
    
                }

        }
        
        
        if($CandidateType=='Placed'){
            $query = User::query();
           
            $query->where('placement_status', 5);

            if ($district_filter) {
                $query->where('district_id', $district_filter);
 
            }
            if ($gender_filter) {
                $query->where('gender', $gender_filter);
 
            }
            if ($category_filter) {
                $query->where('category', $category_filter);
 
            }
            if ($block_filter) {
                $query->where('block_id', $block_filter);
 
            }
            if ($course_filter) {
                $query->where('course_id', $course_filter);
 
            }
            

        }
    
        if($CandidateType=='Joined'){
            $query = User::query();
            $query->whereIn('status', [11,1])->where('user_role_id', '=', 6);

            if ($district_filter) {
                $query->where('district_id', $district_filter);
 
            }
            if ($gender_filter) {
                $query->where('gender', $gender_filter);
 
            }
            if ($category_filter) {
                $query->where('category', $category_filter);
 
            }
            if ($block_filter) {
                $query->where('block_id', $block_filter);
 
            }
            if ($course_filter) {
                $query->where('course_id', $course_filter);
 
            }
        }

            // Execute the query
            $candidates = $query->get();

            foreach ($candidates as $key => $candidate) {

                if ($candidate->dob) {
                    $dob = new DateTime($candidate->dob);
                    $now = new DateTime();

                    $interval = $dob->diff($now);

                    $age = $interval->y;

                } else {

                    $age = "Not available";

                }
                if($CandidateType=='Placed'){
                    
                $employer = User::find($candidate->employer_id);

                array_push(
                    $data,
                    array(
                        "Name" => $candidate->name,
                        "Gender" => $candidate->gender,
                        "Age" => $age,
                        "Email" => $candidate->email,
                        "MobileNumber" => $candidate->mobile_number,
                        "Qualification" => $candidate->highest_qualification,
                        "District" => $candidate->District->name,
                        "Block" => $candidate->Block->name,
                        "Category" => $candidate->category,
                        "PIA" => $candidate->Training->ProgramImplementationAgency->agency_name,
                        "Course" => $candidate->Training->training_name,                        
                        "Employer" => ($employer) ? $employer->name : "Nil",
                        "Location" => $candidate->building_name . "," . $candidate->landmark . "," . $candidate->postOffice . "," . $candidate->District->name . ",PIN-" . $candidate->pincode,
                        "Job Role" => ($candidate->Recruitment) ? $candidate->Recruitment->GetJob->name : "Nil",
                        "Salary" => ($candidate->Recruitment) ? $candidate->Recruitment->salary : "Nil"
                       )
                ); //$candidate->Recruitment->GetJob->salary
            
              
            }else{
                array_push(
                    $data,
                    array(
                        "Name" => $candidate->name,
                        "Gender" => $candidate->gender,
                        "Age" => $age,
                        "Email" => $candidate->email,
                        "MobileNumber" => $candidate->mobile_number,
                        "Qualification" => $candidate->highest_qualification,
                        "District" => $candidate->District->name,
                        "Block" => $candidate->Block->name,
                        "Category" => $candidate->category,
                        "PIA" => ($candidate->Training) ? $candidate->Training->ProgramImplementationAgency->agency_name : "Nil",
                        "Course" => $candidate->Training->training_name
                    )
                );
            }
            }

            if (count($data) > 0) {

                switch ($request->report_type) {

                    case "pdf_report":
                        if($CandidateType=='Completed'){
                          $pdf = PDF::loadview('admin.reports.candidates_report_pdf', ['data' => $data]);
                        
                          return $pdf->stream('candidates_report_pdf.pdf');
                        }
                        if($CandidateType=='Placed'){
                            $options = new Options();
                            $options->set('isHtml5ParserEnabled', true);
                            $options->set('isPhpEnabled', true);
                            
                            // Set paper orientation to landscape
                            $options->set('defaultPaperOrientation', 'landscape');
                            $pdf = new Dompdf($options);
                            $pdf = PDF::loadview('admin.reports.employed_candidates_report_pdf', ['data' => $data]);
                         $pdf->setPaper('A4', 'landscape');
                            $pdf->setOptions(['defaultPaperSize' => 'A4', 'defaultPaperOrientation' => 'landscape', 'margin_bottom' => 0, 'margin_left' => 0, 'margin_right' => 0, 'margin_top' => 0]);
                           
                            $pdf->render();
                        return $pdf->stream('employed_candidates_report_report.pdf');
 }
                        if($CandidateType=='Joined'){
                            $options = new Options();
                            $options->set('isHtml5ParserEnabled', true);
                            $options->set('isPhpEnabled', true);
                            
                            // Set paper orientation to landscape
                            $options->set('defaultPaperOrientation', 'landscape');
                            $pdf = new Dompdf($options);
                        
                            $pdf = PDF::loadview('admin.reports.candidates_joined_report_pdf', ['data' => $data])->setPaper('a4', 'landscape');
                            $pdf->setPaper('A4', 'landscape');
                            $pdf->setOptions(['defaultPaperSize' => 'A4', 'defaultPaperOrientation' => 'landscape', 'margin_bottom' => 0, 'margin_left' => 0, 'margin_right' => 0, 'margin_top' => 0]);
                           
                            $pdf->render();
                            
                            return $pdf->stream('candidates_report_pdf.pdf');
                        }
                      

                    //return view('admin.reports.pia_report_pdf', compact('data'));


                    case "csv_report":

                        header('Content-Type: text/csv');
                        if ($CandidateType == 'Completed') {
                            header('Content-Disposition: attachment; filename="candidates_report_pdf.csv"');
                        }
                          if($CandidateType=='Placed'){
                            header('Content-Disposition: attachment; filename="employed_candidates_report.csv"');
 }
                          if($CandidateType=='Joined'){
                            header('Content-Disposition: attachment; filename="candidates_joined_report_pdf.csv"');
                        }

                        $fp = fopen('php://output', 'wb');

                        $print_header = false;
                        foreach ($data as $line) {

                            if (!$print_header) {
                                fputcsv($fp, array_keys($line));

                                $print_header = true;
                            }

                            fputcsv($fp, $line);
                        }

                        fputcsv($fp, array("", "", "", "", "", ""));

                        fputcsv($fp, array("Generated On:" . date('d M Y h:i:s a'), "", "", "", "", ""));
                        fclose($fp);

                        break;

                    default:
                        $request->session()->flash("error", "Invalid report type");
                        return redirect()->back();

                }
            } else {

                $request->session()->flash("error", "No result found");

                return redirect()->back();
            }


        } catch (\Exception $e) {
            \Log::error($e->getMessage());
//dd($e->getMessage());
          //  $request->session()->flash("error", $e->getMessage());

            $request->session()->flash("error", "Something went wrong");

            return redirect()->back();
        }



    }
    public function EmployerReport(Request $request)
    {
        $list = User::where('user_role_id',5)->get();
        return view('admin.reports.employer_report', ['list' => $list]);
        
    }
    public function generateCandidatesReport_Pia(Request $request)
    {
        try {
            $piaId = auth()->user()->id;
            $CandidateType = $request->CandidateType;
    
            $filters = [
                'district_id' => $request->district_filter ? base64_decode($request->district_filter) : null,
                'block_id' => $request->block_filter ? base64_decode($request->block_filter) : null,
                'course_id' => $request->course_filter ? base64_decode($request->course_filter) : null,
                'gender' => $request->gender_filter ? base64_decode($request->gender_filter) : null,
                'category' => $request->category_filter ? base64_decode($request->category_filter) : null,
            ];
    
            $query = User::where('created_by', $piaId)->where('user_role_id', 6);
    
            switch ($CandidateType) {
                case 'Completed':
                    $query->where('course_completion_status', 3);
                    break;
                case 'Placed':
                    $query->where('placement_status', 5);
                    break;
                case 'Joined':
                    $query->whereIn('status', [11, 1]);
                    break;
            }
    
            foreach ($filters as $field => $value) {
                if ($value) $query->where($field, $value);
            }
    
            $candidates = $query->get();
            $data = [];
    
            foreach ($candidates as $candidate) {
                $age = $candidate->dob ? (new DateTime($candidate->dob))->diff(new DateTime())->y : "Not available";
                $entry = [
                    "Name" => $candidate->name,
                    "Gender" => $candidate->gender,
                    "Age" => $age,
                    "Email" => $candidate->email,
                    "MobileNumber" => $candidate->mobile_number,
                    "Qualification" => $candidate->highest_qualification,
                    "District" => $candidate->District->name,
                    "Block" => $candidate->Block->name,
                    "Category" => $candidate->category,
                    "PIA" => $candidate->Training?->ProgramImplementationAgency->agency_name ?? "Nil",
                    "Course" => $candidate->Training?->training_name ?? "Nil",
                ];
    
                if ($CandidateType == 'Placed') {
                    $employer = User::find($candidate->employer_id);
                    $entry["Employer"] = $employer?->name ?? "Nil";
                    $entry["Location"] = "{$candidate->building_name}, {$candidate->landmark}, {$candidate->postOffice}, {$candidate->District->name}, PIN-{$candidate->pincode}";
                    $entry["Job Role"] = $candidate->Recruitment?->GetJob->name ?? "Nil";
                    $entry["Salary"] = $candidate->Recruitment?->salary ?? "Nil";
                }
    
                $data[] = $entry;
            }
    
            if (empty($data)) {
                $request->session()->flash("error", "No result found");
                return redirect()->back();
            }
    
            if ($request->report_type == "pdf_report") {
                $pdf = PDF::loadView('admin.reports.candidates_report_pdf', ['data' => $data])
                          ->setPaper('A4', 'landscape');
                return $pdf->stream('candidates_report.pdf');
            } elseif ($request->report_type == "csv_report") {
                header('Content-Type: text/csv');
                header('Content-Disposition: attachment; filename="candidates_report.csv"');
                $fp = fopen('php://output', 'wb');
                fputcsv($fp, array_keys($data[0]));
    
                foreach ($data as $line) {
                    fputcsv($fp, $line);
                }
    
                fputcsv($fp, ["Generated On: " . date('d M Y h:i:s a')]);
                fclose($fp);
                exit;
            } else {
                $request->session()->flash("error", "Invalid report type");
                return redirect()->back();
            }
        } catch (\Exception $e) {
            \Log::error($e->getMessage());
            $request->session()->flash("error", "Something went wrong: " . $e->getMessage());
            return redirect()->back();
        }
    }
    


    

    public function generateEmployerReport(Request $request)
    {

        try {

            $request->emp_filter = ($request->emp_filter) ? base64_decode($request->emp_filter) : $request->emp_filter;
            
            if (is_null($request->emp_filter)) {

                $list = User::where('user_role_id',5)->get();
//dd($list);
                $data = array();
                $empyer_id = array();

                foreach ($list as $employer) {
                    

                        if (!in_array($employer->id, $empyer_id)) {
                            array_push($empyer_id, $employer->id);
                           // array_push($empyer_name, $employer->name);
                        }

                    }
                    if ($empyer_id !== null) {
                       // dd($empyer_id);
                       $VacancyCount=0;
                       $jobcommunicated=0;
                       $jobplaced=0;
                       foreach($empyer_id as $emparray){
                        $emp = User::find($emparray);
                        $VacancyCount = JobVacancy::where('employer_id',$emparray)->get()->count();

                        $jobcommunicated = Recruitment::where('employer_id',$emparray)
                                                        ->whereIn('recruitment_status',['5','15','16','17'])
                                                        ->get()
                                                        ->count();
                        $jobplaced = Recruitment::where('employer_id',$emparray)
                                                  ->whereIn('recruitment_status',['5','16','17'])
                                                  ->get()
                                                  ->count();
                                                //  dd($jobplaced);

                            array_push($data, array('Employer Name' =>  $emp->name,'Jobs Posted' => $VacancyCount,'Offer Communicated' => $jobcommunicated,'Jobs Offered' => $jobplaced));
}
                        }

                    else {

                        array_push($data, array('Employer Name' => $employer->name,'Jobs Posted' => 0,'Offer Communicated' => 0,'Jobs Offered' => 0));



                    }



                }else {

                    $employer = User::where('id',$request->emp_filter)->first();
   // dd($employer->id);
                    $data = array();
                        if($employer) {
                           // dd('in');
                            $VacancyCount=0;
                            $jobcommunicated=0;
                            $jobplaced=0;
                            $VacancyCount = JobVacancy::where('employer_id',$employer->id)->get()->count();
                           // dd($VacancyCount);
                            $jobcommunicated = Recruitment::where('employer_id',$employer->id)
                                                            ->whereIn('recruitment_status',['5','15','16','17'])
                                                            ->get()
                                                            ->count();
                            $jobplaced = Recruitment::where('employer_id',$employer->id)
                                                      ->whereIn('recruitment_status',['5','16','17'])
                                                      ->get()
                                                      ->count();
    
                                array_push($data, array('Employer Name' => $employer->name,'Jobs Posted' => $VacancyCount,'Offer Communicated' => $jobcommunicated,'Jobs Offered' => $jobplaced));
  
                            }
    
                        else {
    
                            array_push($data, array('Employer Name' => $employer->name,'Jobs Posted' => 0,'Offer Communicated' => 0,'Jobs Offered' => 0));
           
                        }
            }
            switch ($request->report_type) {

                case "pdf_report":
                    //print_r($data);
                  //  dd("end");

                    $pdf = PDF::loadview('admin.reports.employer_report_pdf', ['data' => $data]);

                    return $pdf->stream('employer_report.pdf');


                case "csv_report":

                    header('Content-Type: text/csv');
                    header('Content-Disposition: attachment; filename="employer_report.csv"');


                    $fp = fopen('php://output', 'wb');

                    $print_header = false;
                    foreach ($data as $line) {

                        if (!$print_header) {
                            fputcsv($fp, array_keys($line));

                            $print_header = true;
                        }

                        

                        fputcsv($fp, $line);
                    }

                    fputcsv($fp, array("", "", "", "", "", ""));

                    fputcsv($fp, array("Generated On:" . date('d M Y h:i:s a'), "", "", "", "", ""));
                    fclose($fp);

                    break;

                default:
                    $request->session()->flash("error", "Invalid report type");
                    return redirect()->back();

            }



        } catch (\Exception $e) {

            //  echo "Something went wrong";

            echo $e->getMessage();

          //  $request->session()->flash("error", $e->getMessage());

            $request->session()->flash("error", "Something went wrong");


            \Log::error($e->getMessage());

            return redirect()->back();


        }

    }

    public function resetCoursesPiaReport(Request $request)
    {

        try {

            $pia_filter = ($request->pia_filter) ? base64_decode($request->pia_filter) : $request->pia_filter;
            $sector_filter = ($request->sector_filter) ? base64_decode($request->sector_filter) : $request->sector_filter;

            if ($pia_filter) {
                // $pia = ProgramImplementationAgency::find($pia_filter);
                $pia = (ProgramImplementationAgency::find($pia_filter)) ? ProgramImplementationAgency::find($pia_filter) : NULL;
            } else {

                $pia = NULL;
            }

            if ($sector_filter) {
                $sector = (Sector::find($sector_filter)) ? Sector::find($sector_filter) : NULL;
            } else {

                $sector = NULL;
            }


            $sector = ($sector_filter) ? Sector::find($sector_filter) : NULL;

            $filtered_course_masters = array();




            if (($pia) && ($sector)) {

                $pia_filtered_masters = array();
                $sector_filtered_masters = array();


                foreach ($pia->Courses as $course) {


                    array_push($pia_filtered_masters, $course->GetCourseMaster->id);
                }

                foreach ($sector->CourseMasters as $course_master) {
                    array_push($sector_filtered_masters, $course_master->id);
                }

                foreach ($pia_filtered_masters as $master) {
                    if (in_array($master, $sector_filtered_masters)) {
                        array_push($filtered_course_masters, $master);
                    }
                }
            } else if ($sector) {
                foreach ($sector->CourseMasters as $course_master) {
                    array_push($filtered_course_masters, $course_master->id);
                }
            } else if ($pia) {
                foreach ($pia->Courses as $course) {


                    array_push($filtered_course_masters, $course->GetCourseMaster->id);
                }
            }


            $course_masters = CourseMaster::whereIsActive(1)->where(function ($query) use ($filtered_course_masters, $pia_filter, $sector_filter) {

                if (($pia_filter) || ($sector_filter)) {
                    $query->whereIn('id', $filtered_course_masters);
                }


            })
                ->get();

            foreach ($course_masters as $key => $course_master) {

                $course_masters[$key]->encoded_id = base64_encode($course_master->id);

            }


            $response['status'] = "success";
            $response['message'] = "";
            $response['course_masters'] = $course_masters;


        } catch (\Exception $e) {
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();
        }

        return response()->json($response);


    }

    public function resetSectorsPiaReport(Request $request)
    {

        try {

            $pia_filter = ($request->pia_filter) ? base64_decode($request->pia_filter) : $request->pia_filter;
            $course_filter = ($request->course_filter) ? base64_decode($request->course_filter) : $request->course_filter;


            $pia = ($pia_filter) ? ProgramImplementationAgency::find($pia_filter) : NULL;

            $course_master = ($course_filter) ? CourseMaster::find($course_filter) : NULL;

            $filtered_sector_masters = array();

            if (($pia) && ($course_master)) {


                foreach ($pia->Sectors as $sector) {

                    if ($sector->Sector->id == $course_master->Sector->id) {
                        array_push($filtered_sector_masters, $course_master->Sector->id);
                    }

                }


            } else if ($course_master) {

                array_push($filtered_sector_masters, $course_master->Sector->id);
            } else if ($pia) {
                foreach ($pia->Sectors as $sector) {
                    array_push($filtered_sector_masters, $sector->Sector->id);
                }
            }

            $sectors = Sector::whereIsActive(1)
                ->where(function ($query) use ($filtered_sector_masters, $course_filter, $pia_filter) {
                    if (($pia_filter) || ($course_filter)) {
                        $query->whereIn('id', $filtered_sector_masters);
                    }
                })
                ->get();

            foreach ($sectors as $key => $sector) {
                $sectors[$key]->encoded_id = base64_encode($sector->id);
            }

            $response['status'] = "success";
            $response['message'] = "";
            $response['sectors'] = $sectors;



        } catch (\Exception $e) {
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();
        }

        return response()->json($response);



    }

    public function resetPiasPiaReport(Request $request)
    {
        try {

            $course_filter = ($request->course_filter) ? base64_decode($request->course_filter) : $request->course_filter;
            $sector_filter = ($request->sector_filter) ? base64_decode($request->sector_filter) : $request->sector_filter;

            $course_master = ($course_filter) ? CourseMaster::find($course_filter) : NULL;
            $sector = ($sector_filter) ? Sector::find($sector_filter) : NULL;

            $filtered_pia_masters = array();


            if (($course_master) && ($sector)) {
                $sector_filtered_masters = array();

                foreach ($sector->Pias as $pia) {
                    array_push($sector_filtered_masters, $pia->Pia->id);
                }

                $course_filtered_masters = array();

                foreach ($course_master->Courses as $course) {

                    array_push($course_filtered_masters, $course->Pia->id);
                }

                foreach ($sector_filtered_masters as $master) {
                    if (in_array($master, $course_filtered_masters)) {
                        array_push($filtered_pia_masters, $master);
                    }
                }
            } else if ($course_master) {

                foreach ($course_master->Courses as $course) {
                    array_push($filtered_pia_masters, $course->Pia->id);
                }

            } else if ($sector) {

                foreach ($sector->Pias as $pia) {
                    array_push($filtered_pia_masters, $pia->Pia->id);
                }

            }

            $pias = ProgramImplementationAgency::whereIsActive(1)
                ->where(function ($query) use ($filtered_pia_masters, $sector_filter, $course_filter) {

                    if (($sector_filter) || ($course_filter)) {
                        $query->whereIn('id', $filtered_pia_masters);
                    }


                })

                ->get();

            foreach ($pias as $key => $pia) {

                $pias[$key]->encoded_id = base64_encode($pia->id);

            }

            $response['status'] = "success";
            $response['message'] = "";
            $response['pias'] = $pias;




        } catch (\Exception $e) {
            $response['status'] = "error";
            $response['message'] = "Something went wrong  ".$e->getLine();
            $response['developer_message'] = $e->getMessage();
        }

        return response()->json($response);
    }

}
