<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\block;
use Illuminate\Http\Request;
use App\Models\ProgramImplementationAgency;
use App\Models\Sector;
use App\Models\Country;
use Illuminate\Support\Facades\Validator;
use App\Models\State;
use App\Models\District;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use App\Mail\PIARegistration;
use Mail;
use App\Mail\PiaReactivation;
use App\Mail\PiaDeactivation;
use App\Models\PiaSector;
use App\Models\PiaTrade;
use App\Models\CourseMaster;
use Illuminate\Support\Facades\DB;


class PIAController extends Controller
{
    public function piaList()
    {
        $pia_list = ProgramImplementationAgency::whereIsActive(1)->orderByDesc('id')->get();

        return view('admin.pia.list', compact('pia_list'));
    }

    public function blockedPIAList()
    {

        $pia_list = ProgramImplementationAgency::whereIsActive(11)->orderByDesc('id')->get();

        return view('admin.pia.blocked_list', compact('pia_list'));

    }

    public function createPIA()
    {
        $sectors = Sector::whereIsActive(1)->get();
        $states = State::whereIsActive(1)->get();
        $trades= CourseMaster::whereIsActive(1)->get();

        return view('admin.pia.create', compact('sectors', 'states','trades'));
    }
    public function getTradesBySector(Request $request)
    {
        $sectorIds = $request->input('sector_ids', []);
    
        // Fetch active trades for the provided sectors
        $trades = CourseMaster::whereIn('sector_id', $sectorIds)
                              ->where('is_active', 1)
                              ->get(['id', 'tradename']);
    
        return response()->json($trades);
    }
    
    public function loadStates(Request $request)
    {
        $validator = Validator::make($request->all(), ['country' => 'required|numeric']);

        if ($validator->fails()) {
            $response['status'] = "error";
            $response['message'] = implode(",", $validator->errors()->all());

        } else {

            $states = state::whereCountryId($request->country)->get();

            $response['status'] = "success";
            $response['message'] = "";
            $response['states'] = $states;


        }

        return response()->json($response);
    }

    public function loadDistricts(Request $request)
    {
        $validator = Validator::make($request->all(), ['state' => 'required|numeric']);

        if ($validator->fails()) {
            $response['status'] = "error";
            $response['message'] = implode(",", $validator->errors()->all());
        } else {

            $districts = district::whereStateId($request->state)->get();

            $response['status'] = "success";
            $response['message'] = "";
            $response['districts'] = $districts;


        }

        return response()->json($response);
    }

    public function loadBlocks(Request $request)
    {
        $validator = Validator::make($request->all(), ['district' => 'required|numeric']);

        if ($validator->fails()) {
            $response['status'] = "error";
            $response['message'] = implode(",", $validator->errors()->all());
        } else {

            $blocks = Block::whereDistrictId($request->district)->get();

            $response['status'] = "success";
            $response['message'] = "";
            $response['blocks'] = $blocks;
        }

        return response()->json($response);
    }

    public function submitPIADetails(Request $request)
    {

        try {

            $rules = [
                'agency_name' => 'required|string|min:1|max:50',
                'course_assigned_location' => 'required|string|min:1|max:250',
                'building_number' => 'required|string|min:1|max:50',
                'street_name' => 'required|string|min:1|max:50',
                'district' => 'required|numeric|exists:districts,id',
                'state' => 'required|numeric|exists:states,id',
                'pincode' => 'required|digits:6',
                'post_office' => 'required|string|min:1|max:25',
                'sector' => 'required',
                'mobile_number' => 'required|digits:10|unique:program_implementation_agencies,mobile_number',
                'pan_number' => 'required|string|unique:program_implementation_agencies,pan_number|regex:/^([a-zA-Z]){5}([0-9]){4}([a-zA-Z]){1}?$/',
                'email' => 'required|string|email|unique:program_implementation_agencies,email|unique:users,email'
            ];

            if ($request->phone_number) {
                $rules['phone_number'] = "digits_between:10,12";
            }

            if ($request->hasFile('attachment')) {
                $rules['attachment'] = 'mimes:pdf|max:2000';
            }



            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {



                $password = "KtcPia*" . rand(999999, 000000) . "*";



                if ($request->hasFile('attachment')) {
                    $attachment = date('Y-M-d-H-h-h-i-s-a') . rand(1000, 9999) . "." . $request->file('attachment')->getClientOriginalExtension();

                    $request->file('attachment')->storeAs("pia_docs", $attachment, "public");



                }

                $state = state::find($request->state);

                DB::beginTransaction();

                $user = new User();
                $user->email = $request->email;
                $user->name = $request->agency_name;
                $user->user_role_id = 4;
                $user->state_id = $request->state;
                $user->country_id = $state->Country->id;
                $user->district_id = $request->district;
                $user->password = Hash::make($password);
                $user->mobile_number = $request->mobile_number;
                $user->phone_number = $request->phone_number;
                $user->pincode = $request->pincode;
                $user->course_assigned_location = $request->course_assigned_location;
                $user->pan_number = $request->pan_number;
                $user->status = 1;
                $user->save();



                $pia = new ProgramImplementationAgency();
                $pia->user_id = $user->id;
                $pia->agency_name = $request->agency_name;
                $pia->building_number = $request->building_number;
                $pia->street_name = $request->street_name;
                $pia->district_id = $request->district;
                $pia->state_id = $request->state;
                $pia->pincode = $request->pincode;
                $pia->post_office = $request->post_office;
                $pia->mobile_number = $request->mobile_number;
                $pia->pan_number = $request->pan_number;
                $pia->email = $request->email;
                $pia->course_assigned_location = $request->course_assigned_location;
                $pia->created_by = $request->user()->id;
                $pia->updated_by = $request->user()->id;

                if (isset($attachment)) {
                    $pia->attachment = $attachment;
                }

                $pia->phone_number = $request->phone_number;
                $pia->save();

                foreach ($request->sector as $sector) {
                    $pia_sector = new PiaSector;
                    $pia_sector->sector_id = $sector;
                    $pia_sector->program_implementation_agency_id = $pia->id;
                    $pia_sector->save();
                }
                foreach ($request->trade as $trade) {
                    $piaTrade = new PiaTrade();  
                    $piaTrade->pia_id = $pia->id;  
                    $piaTrade->sector_id = $sector;  
                    $piaTrade->trade_id = $trade;  
                    $piaTrade->save();
                }
                
                DB::commit();

                Mail::to($pia->email)->send(new PIARegistration($pia, $password));


                if ($pia->id > 0) {
                    $response['status'] = "success";
                    $response['message'] = "PIA updated successfully";
                    $response['redirect'] = route('piaList');
                    $response['developer_message'] = "";
                } else {

                    $response['status'] = "error";
                    $response['message'] = "Something went wrong";
                    $response['developer_message'] = "";


                }

            }


        } catch (\Exception $e) {

            DB::rollBack();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function updatePIADetails(Request $request)
    {

        try {

            $rules = [
                'id' => 'required|numeric|exists:program_implementation_agencies,id',
                'building_number' => 'required|string|min:1|max:50',
                'street_name' => 'required|string|min:1|max:50',
                'district' => 'required|numeric|exists:districts,id',
                'state' => 'required|numeric|exists:states,id',
                'post_office' => 'required|string|min:1|max:25',
                'course_assigned_location' => 'required|string|min:1|max:250',
                'pincode' => 'required|digits:6',
                'sector' => 'required',
                'mobile_number' => 'required|digits:10|unique:program_implementation_agencies,mobile_number,' . $request->id
            ];

            if ($request->hasFile('attachment')) {
                $rules['attachment'] = 'mimes:pdf|max:2000';
            }

            if ($request->phone_number) {

                $rules['phone_number'] = 'digits_between:10,12';


            }



            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                if ($request->hasFile('attachment')) {
                    $attachment = date('Y-M-d-H-h-h-i-s-a') . rand(1000, 9999) . "." . $request->file('attachment')->getClientOriginalExtension();

                    $request->file('attachment')->storeAs("pia_docs", $attachment, "public");



                }

                DB::beginTransaction();

                $pia = ProgramImplementationAgency::find($request->id);
                $pia->building_number = $request->building_number;
                $pia->street_name = $request->street_name;
                $pia->post_office = $request->post_office;
                $pia->district_id = $request->district;
                $pia->state_id = $request->state;
                $pia->pincode = $request->pincode;
                $pia->course_assigned_location = $request->course_assigned_location;
                $pia->mobile_number = $request->mobile_number;
                $pia->updated_by = $request->user()->id;
                if (isset($attachment)) {
                    $pia->attachment = $attachment;
                }

                $pia->phone_number = $request->phone_number;
                $pia->save();

                $user = User::find($pia->user_id);
                $user->user_role_id = 4;
                $user->state_id = $request->state;
                $user->district_id = $request->district;
                $user->mobile_number = $request->mobile_number;
                $user->phone_number = $request->phone_number;
                $user->pincode = $request->pincode;
                $user->course_assigned_location = $request->course_assigned_location;
                $user->status = 1;
                $user->save();

                PiaSector::whereProgramImplementationAgencyId($pia->id)->delete();
               
                foreach ($request->sector as $sector) {
                    $pia_sector = new PiaSector;
                    $pia_sector->sector_id = $sector;
                    $pia_sector->program_implementation_agency_id = $pia->id;
                    $pia_sector->save();
                }
                PiaTrade::wherepia_id($pia->id)->delete();
                foreach ($request->trade as $trade) {
                    $piaTrade = new PiaTrade();  
                    $piaTrade->pia_id = $pia->id;  
                    $piaTrade->sector_id = $sector;  
                    $piaTrade->trade_id = $trade;  
                    $piaTrade->save();
                }


                DB::commit();

                if ($pia->id > 0) {
                    $response['status'] = "success";
                    $response['message'] = "PIA updated successfully";
                    $response['developer_message'] = "";
                    $response['redirect'] = route('piaList');
                } else {

                    $response['status'] = "error";
                    $response['message'] = "Something went wrong";
                    $response['developer_message'] = "";


                }


            }


        } catch (\Exception $e) {

            DB::rollBack();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function editPIA($id)
    {
        $pia = ProgramImplementationAgency::with(['assignedCourses','sectors'])->findOrFail(base64_decode($id));
        $sectors = Sector::where('is_active', 1)->get();
        $states = State::all();
        $districts = District::where('state_id', $pia->state_id)->get();
    
        
        $selectedSectors = $pia->Sectors->pluck('sector_id')->toArray();
    
        
        $courses = CourseMaster::whereIn('sector_id', $selectedSectors)->get();
    
        
        $selectedCourses = $pia->assignedCourses->pluck('id')->toArray();
       //dd($courses); 
        //dd($selectedCourses); // Check the contents of selectedCourses

       // dd($pia->assignedCourses);
      // dd( $selectedSectors);

    

    
        return view('admin.pia.edit', compact(
            'pia', 'sectors', 'states', 'districts', 'courses', 'selectedCourses','selectedSectors'
        ));
    }
    
    public function viewPIA($id = null)
    {

        if (is_null($id)) {
            return redirect()->back();
        }

        $pia = ProgramImplementationAgency::find(base64_decode($id));

        if (!$pia) {
            return redirect()->back();
        }

        return view('admin.pia.view', compact('pia'));
    }

    public function deactivatePIA(Request $request)
    {


        try {

            $validator = Validator::make($request->all(), ['pia' => 'required']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                ProgramImplementationAgency::whereId(base64_decode($request->pia))->update(['is_active' => 11, 'updated_by' => $request->user()->id]);

                $pia = ProgramImplementationAgency::find(base64_decode($request->pia));

                User::whereId($pia->user_id)->update(['status' => 11, 'updated_by' => $request->user()->id]);

                Mail::to($pia->User)->send(new PiaDeactivation($pia));

                $response['status'] = "success";
                $response['message'] = "PIA deactivated";
                $response['developer_message'] = "";
                $response['redirect'] = route('piaList');

            }


        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);
    }

    public function reactivatePIA(Request $request)
    {


        try {

            $validator = Validator::make($request->all(), ['pia' => 'required']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                ProgramImplementationAgency::whereId(base64_decode($request->pia))->update(['is_active' => 1, 'updated_by' => $request->user()->id]);

                $pia = ProgramImplementationAgency::find(base64_decode($request->pia));

                User::whereId($pia->user_id)->update(['status' => 1, 'updated_by' => $request->user()->id]);

                Mail::to($pia)->send(new PiaReactivation($pia));



                $response['status'] = "success";
                $response['message'] = "PIA reactivated";
                $response['developer_message'] = "";
                $response['redirect'] = route('piaList');
            }


        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);
    }
    public function getTrades(Request $request)
{
    $request->validate([
        'sectors' => 'required|array',
    ]);

    $courses = CourseMaster::whereIn('sector_id', $request->sectors)->get();

    return response()->json($courses);
}

    
}
