<?php

namespace App\Http\Controllers\Admin;

use App\Models\JobVacancySkillMapping;
use App\Models\Skill;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\JobVacancy;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use App\Models\Notification;


class JobVacancyController extends Controller
{
    public function JobVacanciesList()
    {
        $job_list = JobVacancy::whereIsActive(1)->where('employer_id', auth()->user()->id)->get();

        return view('admin.jobvacancy.list', compact('job_list'));
    }

    public function viewJobVacancy($encryptempID = null)
    {
        if (isset($encryptempID)) {
            $job = JobVacancy::find(base64_decode($encryptempID));
            return view('admin.jobvacancy.view', compact('job'));
        } else {
          
          return $this->JobVacanciesList();
        }
    }

    public function createJobVacancy()
    {

        $skills = Skill::whereIsActive(1)->get();
        return view('admin.jobvacancy.create', compact('skills'));
    }

    public function submitJobVacancyDetails(Request $request)
    {

        try {

            $rules = [
                'employer' => 'required|numeric|exists:users,id',
                'vacancy_name' => 'required|string|min:1|max:80',
                'job_code' => 'required|string',
                'job_location' => 'required|string',
                'qualification' => 'required|string',
                'salary' => 'required|string',
                'description' => 'required|string|min:1|max:200',
                'Skill' => 'required|exists:skills,id'
            
            ];

            if ($request->hasFile('attachment')) {
                $rules['attachment'] = 'mimes:jpeg|max:2000';
            }

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                if ($request->hasFile('attachment')) {
                    $attachment = date('Y-M-d-H-h-h-i-s-a') . rand(1000, 9999) . "." . $request->file('attachment')->getClientOriginalExtension();

                    $request->file('attachment')->storeAs("job_vacancy_docs", $attachment, "public");



                }

                DB::beginTransaction();

                $job = new JobVacancy();
                $job->name = $request->vacancy_name;
                $job->code = $request->job_code;
                $job->location = $request->job_location;
                $job->qualification = $request->qualification;
                $job->salary = $request->salary;
                $job->code = $request->job_code;
                $job->description = $request->description;
                $job->employer_id = $request->user()->id;

                if (isset($attachment)) {
                    $job->attachment = $attachment;
                }

                $job->is_active = 1;
                $job->save();

                $jobid = $job->id;

                $skills = $request->get('Skill');

                foreach ($skills as $sk) {
                    $job_skill = new JobVacancySkillMapping;
                    $job_skill->skill_id  = $sk;
                    $job_skill->job_vacancy_id = $jobid;
                    $job_skill->save();
                }

                DB::commit();


                if ($job->id > 0) {

                    $notification=new Notification();
                    $notification->title="Job Opening";
                    $notification->description="New job vacancy for ".$job->name." in ".$job->location;
                    $notification->job_id=$job->id;
                    $notification->notification_type="job_vacancy";
                    $notification->save();

            
                    $response['status'] = "success";
                    $response['message'] = "Job Vacancy added successfully";
                    $response['developer_message'] = "";
                    $response['redirect'] = route('JobVacanciesList');
                } else {

                    $response['status'] = "error";
                    $response['message'] = "Something went wrong";
                    $response['developer_message'] = "";


                }

            }


        } catch (\Exception $e) {

            DB::rollBack();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function editJobVacancy($encryptempID = null)
    {
        if (isset($encryptempID)) {
            $job = JobVacancy::find(base64_decode($encryptempID));
            $skills = Skill::whereIsActive(1)->get();    
            return view('admin.jobvacancy.edit', compact('job','skills'));
        } else {
          
          return $this->JobVacanciesList();
        }
    }

    public function updateJobVacancyDetails(Request $request)
    {   

        //dd($request);
        try {

            $rules = [
                'id' => 'required|numeric|exists:job_vacancies,id',
                'vacancy_name' => 'required|string|min:1|max:80',
                'job_code' => 'required|string',
                'job_location' => 'required|string',
                'qualification' => 'required|string',
                'salary' => 'required|string',
                'description' => 'required|string|min:1|max:200',
                'Skill' => 'required|exists:skills,id'
            ];

            if ($request->hasFile('attachment')) {
                $rules['attachment'] = 'mimes:jpeg|max:2000';
            }


            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                if ($request->hasFile('attachment')) {
                    $attachment = date('Y-M-d-H-h-h-i-s-a') . rand(1000, 9999) . "." . $request->file('attachment')->getClientOriginalExtension();

                    $request->file('attachment')->storeAs("job_vacancy_docs", $attachment, "public");



                }

                $job = JobVacancy::find($request->id);
                $job->name = $request->vacancy_name;
                $job->code = $request->job_code;
                $job->location = $request->job_location;
                $job->qualification = $request->qualification;
                $job->salary = $request->salary;
                $job->description = $request->description;

                if (isset($attachment)) {
                    $job->attachment = $attachment;
                }

                $job->is_active = 1;
                $job->save();

                JobVacancySkillMapping::whereJobVacancyId($job->id)->delete();

                $jobid = $job->id;

                //dd($couid);

                $skills = $request->get('Skill');
            

                foreach ($skills as $sk) {
                    $job_skill = new JobVacancySkillMapping;
                    $job_skill->skill_id  = $sk;
                    $job_skill->job_vacancy_id = $jobid;
                    $job_skill->save();
                }


                $response['status'] = "success";
                $response['message'] = "Job Vacancy updated successfully";
                $response['developer_message'] = "";
                $response['redirect'] = route('JobVacanciesList');

            }


        } catch (\Exception $e) {
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function deactivateJobVacancy(Request $request)
    {


        try {

            $validator = Validator::make($request->all(), ['job' => 'required']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
                $response['redirect']=route('/employer/JobVacancies-list');
            } else {

                JobVacancy::whereId(base64_decode($request->job))->update(['is_active' => 0]);

                $response['status']="success";
                $response['message']="Job Vacancy deactivated";
                $response['developer_message']="";
            }


        } catch (\Exception $e) {

            $response['status']="error";
            $response['message']="Something went wrong";
            $response['developer_message']=$e->getMessage();

        }

        return response()->json($response);
    }
}
