<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Country;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Mail;
use App\Mail\EmployerRegistration;
use App\Models\State;
use App\Models\District;
use App\Models\EmployerDetailsUpdationRequest;
use App\Mail\EmployerReactivation;
use App\Mail\EmployerDeactivation;

class EmployerController extends Controller
{
    public function employerList(Request $request)
    {
        $employers = User::whereUserRoleId(5)->whereStatus(1)->orderByDesc('id')->get();



        return view('pia.employers.list', compact('employers'));
    }



    public function approvalPendingEmployersList()
    {

        $employers = User::whereUserRoleId(5)->whereApprovalStatus(11)->whereNull('approved_by')->whereNull('rejected_by')->orderByDesc('id')->get();
        return view('admin.employers.approval_pending', compact('employers'));

    }

    public function deactivatedEmployersList()
    {

        $employers = User::whereUserRoleId(5)->whereApprovalStatus(1)->whereStatus(11)->orderByDesc('id')->get();
        return view('admin.employers.deactivated_employers', compact('employers'));

    }

    public function employerListForAdmin()
    {
        $employers = User::whereUserRoleId(5)->whereStatus(1)->orderByDesc('id')->get();

        return view('admin.employers.list', compact('employers'));
    }

    public function addEmployer(Request $request)
    {
        $countries = Country::all();

        if ($request->user()->user_role_id == 1) {
            return view('admin.employers.add', compact('countries'));
        } else {

            return view('pia.employers.add', compact('countries'));


        }


    }

    public function editEmployer(Request $request, $id = null)
    {

        if (is_null($id)) {
            return redirect()->back();
        }

        $user = User::find(base64_decode($id));

        if (!$user) {
            return redirect()->back();
        }


        $countries = Country::all();
        $states = state::whereCountryId($user->country_id)->get();
        $districts = District::whereStateId($user->state_id)->get();

        if ($request->user()->user_role_id == 1) {

            return view('admin.employers.edit', compact('user', 'countries', 'states', 'districts'));


        } else {

            return view('pia.employers.edit', compact('user', 'countries', 'states', 'districts'));
        }


    }

    public function submitEmployerDetails(Request $request)
    {

        try {

            $rules = [
                'building_number' => 'required|string|min:1|max:50',
                'landmark' => 'required|string|min:1|max:50',
                'employer_name' => 'required|string|min:1|max:50',
                'country' => 'required|numeric|exists:countries,id',
                'state' => 'required|numeric|exists:states,id',
                'district' => 'required|numeric|exists:districts,id',
                'contact_number' => 'required|digits_between:10,12',
                'pan_number' => 'required|string|unique:users,pan_number|min:10|max:10',
                'post_office' => 'required|string|min:1|max:25',
                'pincode' => 'required|digits:6',
                'email' => 'required|email|unique:users,email',
                'cover_area' => 'required|string|min:1|max:100',
                'prefered_location' => 'required|string|min:1|max:100',
            ];

            if ($request->hasFile('attachment')) {
                $rules['attachment'] = "required|file|mimes:pdf|max:2000";
            }

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                if ($request->hasFile('attachment')) {
                    $attachment = date('Y-M-d-H-h-i-s-a') . "-" . rand(99999, 00000) . "." . $request->file('attachment')->getClientOriginalExtension();

                    $request->file('attachment')->storeAs("employer_docs", $attachment, "public");
                }

                $password = ($request->user()->user_role_id == 1) ? "KtcEmp*" . rand(999999, 000000) . "#" : "password";

                DB::beginTransaction();

                $user = new User();
                $user->name = $request->employer_name;
                $user->user_role_id = 5;
                $user->country_id = $request->country;
                $user->state_id = $request->state;
                $user->district_id = $request->district;
                // $user->block_id = 0;
                $user->email = $request->email;
                $user->postOffice = $request->post_office;
                $user->landmark = $request->landmark;
                $user->building_name = $request->building_number;
                $user->phone_number = $request->contact_number;
                $user->pincode = $request->pincode;
                $user->prefered_location = $request->prefered_location;
                $user->cover_area = $request->cover_area;
                $user->password = ($request->user()->user_role_id == 1) ? Hash::make($password) : $password;
                $user->pan_number = $request->pan_number;
                $user->created_by = $request->user()->id;
                $user->updated_by = $request->user()->id;
                $user->status = 11;
                $user->approval_status = 11;

                if ($request->user()->user_role_id == 1) {
                    $user->approval_status = 1;
                    $user->approved_by = $request->user()->id;
                }

                if (isset($attachment)) {
                    $user->document_upload = $attachment;
                }

                $user->save();

                DB::commit();

                if ($user->id > 0) {

                    if ($request->user()->user_role_id == 1) {

                        Mail::to($user)->send(new EmployerRegistration($user, $password));

                    }


                    $response['status'] = "success";
                    $response["message"] = "Details submitted for approval";
                    $response['developer_message'] = "";
                    $response['redirect'] = route('piaEmployerList');

                } else {

                    $response['status'] = "error";
                    $response["message"] = "Something went wrong";
                    $response['developer_message'] = "";


                }

            }


        } catch (\Exception $e) {

            DB::rollback();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();
        }

        return response()->json($response);

    }

    public function viewEmployer(Request $request, $id = null)
    {

        if (is_null($id)) {
            return redirect()->back();
        }

        $employer = User::find(base64_decode($id));
        $agency = User::where('id', $employer->created_by)->pluck('name');
        //dd($agency);

        if (!$employer) {
            return redirect()->back();
        }


        if ($request->user()->user_role_id == 1 || $request->user()->user_role_id == 2 || $request->user()->user_role_id == 3) {
            return view('admin.employers.view', compact('employer', 'agency'));
        } else {

            return view('pia.employers.view', compact('employer'));
        }



    }

    public function updateEmployerDetails(Request $request)
    {

        try {

            $rules = [
                'id' => 'required|numeric|exists:users,id',
                'building_number' => 'required|string|min:1|max:50',
                'landmark' => 'required|string|min:1|max:50',
                'employer_name' => 'required|string|min:1|max:50',
                'country' => 'required|numeric|exists:countries,id',
                'state' => 'required|numeric|exists:states,id',
                'district' => 'required|numeric|exists:districts,id',
                'contact_number' => 'required|digits_between:10,12',
                'pan_number' => 'required|string|min:10|max:10|unique:users,pan_number,' . $request->id,
                'post_office' => 'required|string|min:1|max:25',
                'prefered_location' => 'required|string|min:1|max:100',
                'cover_area' => 'required|string|min:1|max:100',
                'pincode' => 'required|digits:6',
                'email' => 'required|email|unique:users,email,' . $request->id,

            ];



            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                if ($request->user()->user_role_id == 1) {


                    DB::beginTransaction();

                    $user = User::find($request->id);
                    $user->country_id = $request->country;
                    $user->state_id = $request->state;
                    $user->district_id = $request->district;
                    // $user->block_id = 0;
                    $user->email = $request->email;
                    $user->postOffice = $request->post_office;
                    $user->landmark = $request->landmark;
                    $user->building_name = $request->building_number;
                    $user->phone_number = $request->contact_number;
                    $user->pincode = $request->pincode;
                    $user->prefered_location = $request->prefered_location;
                    $user->cover_area = $request->cover_area;
                    $user->updated_by = $request->user()->id;

                    $user->save();

                    DB::commit();

                    if ($user->id > 0) {


                        $response['status'] = "success";
                        $response["message"] = "Details submitted for approval";
                        $response['developer_message'] = "";


                    } else {

                        $response['status'] = "error";
                        $response["message"] = "Something went wrong";
                        $response['developer_message'] = "";


                    }

                } else if ($request->user()->user_role_id == 4) {

                    DB::beginTransaction();

                    $update_request = new EmployerDetailsUpdationRequest();
                    $update_request->employer_id = $request->id;
                    $update_request->building_name = $request->building_number;
                    $update_request->phone_number = $request->contact_number;
                    $update_request->landmark = $request->landmark;
                    $update_request->country_id = $request->country;
                    $update_request->state_id = $request->state;
                    $update_request->district_id = $request->district;
                    $update_request->postOffice = $request->post_office;
                    $update_request->pincode = $request->pincode;
                    $update_request->prefered_location = $request->prefered_location;
                    $update_request->cover_area = $request->cover_area;
                    $update_request->created_by = $request->user()->id;
                    $update_request->approval_status = 11;
                    $update_request->save();

                    DB::commit();

                    if ($update_request->id > 0) {


                        $response['status'] = "success";
                        $response["message"] = "Updation request submitted";
                        $response['developer_message'] = "";
                        $response['redirect'] = route('piaEmployerList');

                    } else {

                        $response['status'] = "error";
                        $response["message"] = "Something went wrong";
                        $response['developer_message'] = "";


                    }



                }




            }


        } catch (\Exception $e) {

            DB::rollback();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();
        }

        return response()->json($response);

    }

    public function deactivateEmployer(Request $request)
    {


        try {

            $validator = Validator::make($request->all(), ['employer' => 'required|string']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());

            } else {

                User::whereId(base64_decode($request->employer))->update(['status' => 11, 'updated_by' => $request->user()->id]);
                $employer = User::find(base64_decode($request->employer));
                Mail::to($employer)->send(new EmployerDeactivation($employer));
                $response['status'] = "success";
                $response['message'] = "Employer deactivated successfully";
                $response['developer_message'] = "";
                $response['redirect'] = route('adminEmployerList');


            }


        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);
    }

    public function approveEmployer(Request $request)
    {

        try {

            $validator = Validator::make($request->all(), ['employer' => 'required|string']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {



                User::whereId(base64_decode($request->employer))->update(['approval_status' => 1, 'updated_by' => $request->user()->id, 'approved_by' => $request->user()->id]);

                $password = "KtcEmp*" . rand(999999, 100000) . "#";

                $user = User::find(base64_decode($request->employer));
                $user->approval_status = 1;
                $user->password = Hash::make($password);
                $user->updated_by = $request->user()->id;
                $user->approved_by = $request->user()->id;
                $user->status = 1;
                $user->save();

                Mail::to($user)->send(new EmployerRegistration($user, $password));

                $response['status'] = "success";
                $response['message'] = "Employer Approved successfully";
                $response['developer_message'] = "";
                $response['redirect'] = route('adminApprovalPendingEmployersList');


            }


        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function rejectEmployer(Request $request)
    {

        try {

            $validator = Validator::make($request->all(), ['employer' => 'required|string']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {



                User::whereId(base64_decode($request->employer))->update(['approval_status' => 11, 'updated_by' => $request->user()->id, 'rejected_by' => $request->user()->id]);

                $user = User::find(base64_decode($request->employer));
                $user->approval_status = 11;
                $user->updated_by = $request->user()->id;
                $user->rejected_by = $request->user()->id;
                $user->status = 11;
                $user->save();

                $response['status'] = "success";
                $response['message'] = "Employer Rejected successfully";
                $response['developer_message'] = "";
                $response['redirect'] = route('adminApprovalPendingEmployersList');


            }


        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function openEmployerUpdationRequests()
    {
        $requests = EmployerDetailsUpdationRequest::whereApprovalStatus(11)->whereNull('processed_by')->get();

        return view('admin.employers.update_request_list', compact('requests'));
    }

    public function employerUpdationRequest(Request $request, $id = null)
    {

        if (is_null($id)) {
            return redirect()->back();
        }

        $update_request = EmployerDetailsUpdationRequest::find(base64_decode($id));

        if (!$update_request) {
            return redirect()->back();
        }

        return view('admin.employers.update_request', compact('update_request'));

    }

    public function processUpdateRequest(Request $request)
    {

        try {

            $validator = Validator::make($request->all(), ['approval_status' => 'required|numeric', 'request_id' => 'required|string']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                $update_request = EmployerDetailsUpdationRequest::find(base64_decode($request->request_id));

                $update_request->approval_status = $request->approval_status;
                $update_request->processed_by = $request->user()->id;
                $update_request->processed_at = Now();
                $update_request->save();

                if ($update_request->approval_status == 1) {

                    DB::beginTransaction();
                    $employer = User::find($update_request->employer_id);
                    $employer->country_id = $update_request->country_id;
                    $employer->district_id = $update_request->district_id;
                    $employer->state_id = $update_request->state_id;
                    $employer->phone_number = $update_request->phone_number;
                    $employer->building_name = $update_request->building_name;
                    $employer->landmark = $update_request->landmark;
                    $employer->pincode = $update_request->pincode;
                    $employer->updated_by = $request->user()->id;
                    $employer->postOffice = $update_request->postOffice;
                    $employer->prefered_location = $update_request->prefered_location;
                    $employer->cover_area = $update_request->cover_area;
                    $employer->save();
                    DB::commit();

                    if ($employer->id > 0) {

                        $response['status'] = "success";
                        $response['message'] = "The employer's account data has been updated successfully...";
                        $response['developer_message'] = "";
                        $response['redirect'] = route('adminOpenEmployerUpdationRequests');

                    } else {

                        $response['status'] = "Error";
                        $response['message'] = "Something went wrong";
                        $response['developer_message'] = "";


                    }

                } else if ($update_request->approval_status == 11) {

                    $response['status'] = "success";
                    $response['message'] = "The employer's account data update is rejected.";
                    $response['developer_message'] = "";
                    $response['redirect'] = route('adminOpenEmployerUpdationRequests');


                } else {

                    $response['status'] = "error";
                    $response['message'] = "Something went wrong";
                    $response['developer_message'] = "";
                }


            }

        } catch (\Exception $e) {

            DB::rollBack();

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function reactivateEmployer(Request $request)
    {

        try {

            $validator = Validator::make($request->all(), ['employer' => 'required|string']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                DB::beginTransaction();

                $employer = User::find(base64_decode($request->employer));
                $employer->status = 1;
                $employer->updated_by = $request->user()->id;
                $employer->save();

                DB::commit();

                if ($employer->id > 0) {

                    $employer = User::find(base64_decode($request->employer));
                    Mail::to($employer)->send(new EmployerReactivation($employer));
                    $response['status'] = "success";
                    $response['message'] = "Employer deactivated";
                    $response['developer_message'] = "";
                    $response['redirect'] = route('adminDeactivatedEmployersList');


                } else {

                    $response['status'] = "error";
                    $response['message'] = "Something went wrong";
                    $response['developer_message'] = "Something went wrong";
                }




            }


        } catch (\Exception $e) {
            DB::rollBack();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function rejectedEmployersList(Request $request)
    {

        $employers = User::whereUserRoleId(5)->whereCreatedBy($request->user()->id)->whereNotNull('rejected_by')->get();

        return view('pia.employers.rejected_employers', compact('employers'));


    }
    public function pendingEmployersList(Request $request)
    {

        $employers = User::whereUserRoleId(5)->whereCreatedBy($request->user()->id)
            ->where('status', 11)
            ->whereNull('approved_by')
            ->whereNull('rejected_by')
            ->where('profile_status', 1)->get();
        //dd($employers);
        return view('pia.employers.pending_employer', compact('employers'));


    }




}
