<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Sector;
use App\Models\CourseMaster;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

class CourseMasterController extends Controller
{
    //
    public function CourseMasterList()
    {
        $courseMaster_details = CourseMaster::whereIsActive(1)->orderByDesc('id')->get();
       // dd($sector_details);

        return view('admin.courseMaster.list', compact('courseMaster_details'));
    }

    public function viewCourseMaster($encryptempID = null)
    {
        if (isset($encryptempID)) {
            $courseMaster_details = CourseMaster::find(base64_decode($encryptempID));
            return view('admin.courseMaster.view', compact('courseMaster_details'));
        } else {
          
          return $this->CourseMasterList();
        }
    }

    public function createCourseMaster()
    {

        $Sectors = Sector::whereIsActive(1)->get();
        return view('admin.courseMaster.create', compact('Sectors'));
    }

    public function submitCourseMasterDetails(Request $request)
    {

        try {

            $rules = [
                'Sector' => 'required|numeric|exists:sectors,id',
                'trade_name' => 'required|string|min:1|max:80',
                'trade_code' => 'unique:course_masters,tradecode',
                 'duration' => 'required|string|min:1|max:50',
                 'qualification' => 'required|string|min:1|max:100',
                 'description' => 'required|string|min:1|',
            ];

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                DB::beginTransaction();

                $course = new CourseMaster();
                $course->sector_id = $request->Sector;
                $course->tradename = $request->trade_name;
                $course->tradecode = $request->trade_code;
                $course->duration = $request->duration;
                $course->qualification = $request->qualification;
                $course->description = $request->description;
                $course->is_active = 1;
                $course->save();

                DB::commit();


                if ($course->id > 0) {
                    $response['status'] = "success";
                    $response['message'] = "Course added successfully";
                    $response['redirect'] = route('CourseMasterList');
                    $response['developer_message'] = "";
                } else {

                    $response['status'] = "error";
                    $response['message'] = "Something went wrong";
                    $response['developer_message'] = "";


                }

            }


        } catch (\Exception $e) {

            DB::rollBack();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function editCourseMaster($encryptempID = null)
    {
        if (isset($encryptempID)) {
            $courseMaster = CourseMaster::find(base64_decode($encryptempID));
            $Sector = Sector::whereIsActive(1)->get();
            return view('admin.courseMaster.edit', compact('courseMaster','Sector'));
        } else {
          
          return $this->CourseMasterList();
        }
    }

    public function updateCourseMasterDetails(Request $request)
    {   

        //dd($request);
        try {

            $rules = [
                'id' => 'required|numeric|exists:course_masters,id',
                'Sector' => 'required|numeric|exists:sectors,id',
                'trade_name' => 'required|string|min:1|max:80',
                'trade_code' => 'unique:course_masters,tradecode,'.$request->id,
                'duration' => 'required|string|min:1|max:50',
                'qualification' => 'required|string|min:1|max:100',
                'description' => 'required|string|min:1|max:500',
            ];


            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                $course = CourseMaster::find($request->id);
                $course->sector_id = $request->Sector;
                $course->tradename = $request->trade_name;
                $course->tradecode = $request->trade_code;
                $course->duration = $request->duration;
                $course->qualification = $request->qualification;
                $course->description = $request->description;
                $course->save();

                $response['status'] = "success";
                $response['message'] = "Course Master updated successfully";
                $response['developer_message'] = "";
                $response['redirect'] = route('CourseMasterList');
            }


        } catch (\Exception $e) {
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);

    }

    public function deactivateCourse(Request $request)
    {


        try {

            $validator = Validator::make($request->all(), ['course' => 'required']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                CourseMaster::whereId(base64_decode($request->course))->update(['is_active' => 0]);

                $response['status']="success";
                $response['message']="Course deactivated";
                $response['developer_message']="";
            }


        } catch (\Exception $e) {

            $response['status']="error";
            $response['message']="Something went wrong";
            $response['developer_message']=$e->getMessage();

        }

        return response()->json($response);
    }

    public function deactivateCoursebyId(Request $request)
    {


        try {

            $validator = Validator::make($request->all(), ['course' => 'required']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

                CourseMaster::whereId(base64_decode($request->course))->update(['is_active' => 11]);

                $response['status']="success";
                $response['message']="Course deactivated";
                $response['developer_message']="";
                $response['redirect'] = route('CourseMasterList');
            }


        } catch (\Exception $e) {

            $response['status']="error";
            $response['message']="Something went wrong";
            $response['developer_message']=$e->getMessage();

        }

        return response()->json($response);
    }


}
