<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Course;
use App\Models\District;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Log;

use Illuminate\Support\Facades\Hash;
use Mail;
use App\Mail\AdminRegistration;
use App\Mail\adminDeactive;
use App\Mail\adminReactive;
use App\Models\Country;
use App\Models\State;
use App\Models\Block;
use App\Models\CandidateInterest;
class CommonController extends Controller
{
    public function dashboard(Request $request)
    {
        if(auth()->user()->user_role_id == 1){

       
          for ($i = 0; $i <= 11; $i++) {
            $month_year[]= date("Y-M", strtotime( date( 'Y-m-01' )." -$i months"));
                //$months[] = date("Y-M", strtotime( date( 'Y-m-01' )." -$i months"));
            }

            for ($i = 0; $i <= 11; $i++) {
           
                $user_registered[]= CandidateInterest::where('created_at', '>=', date("Y-m-d", strtotime( date( 'Y/m/01' )." -$i months")))
                ->where('created_at', '<=', date("Y-m-d", strtotime( date( 'Y/m/31' )." -$i months")))->where('status', '!=', 11)->get()->count();
                }
                for ($i = 0; $i <= 11; $i++) {
           
                    $user_placed[]= User::where('placed_at', '>=', date("Y-m-d", strtotime( date( 'Y/m/01' )." -$i months")))
                    ->where('placed_at', '<=', date("Y-m-d", strtotime( date( 'Y/m/31' )." -$i months")))->where('user_role_id', '=', 6)->where('placement_status', '=', 5)->get()->count();
                    }
    
                $data['month_user_registered'] = $user_registered;
                $data['month_user_placed'] = $user_placed;
          $data['month_year'] = $month_year;
        

            $data['trainig_total_count'] = Course::where('is_active', '=', 1)->count();
            $data['trainig_ongoing_count'] = Course::where('is_active', '=', 1)->where('course_status', '=', 7)->count();
            $data['trainig_completed_count'] = Course::where('is_active', '=', 1)->where('course_status', '=', 3)->count();
           
          
            $data['trainigs'] = Course::leftJoin('users', function($join) {
                $join->on('courses.id', '=', 'users.course_id')->where('users.user_role_id', '=', 6)->where('users.profile_status', '=', 2);
              })->leftJoin('districts', function($join) {
                $join->on('courses.district_id', '=', 'districts.id')->where('districts.is_active', '=', 1);
              })->leftJoin('program_implementation_agencies', function($join) {
                $join->on('courses.pia_id', '=', 'program_implementation_agencies.id')->where('program_implementation_agencies.is_active', '=', 1);
              }) ->select(
                'courses.id', 
                'courses.training_name', 
                'courses.end_date', 
                'program_implementation_agencies.user_id', 
                Course::raw('COUNT(users.id) as total_students')
            )
            ->where('program_implementation_agencies.user_id', '=', auth()->user()->id)
            ->where('courses.course_status', '=', 7)
            ->groupBy(
                'courses.id', 
                'courses.training_name', 
                'courses.end_date', 
                'program_implementation_agencies.user_id'
            )
            ->orderBy('courses.id', 'DESC')
            ->get();
        
       
           


            $data['piasCount'] = User::where('user_role_id', '=', 4)->where('status', '=', 1)->get()->count();
            $data['employersCount'] = User::where('user_role_id', '=', 5)->where('status', '=', 1)->get()->count();
            $data['candidatesCount'] = CandidateInterest::Where('status', '=', 1)->count();
            $data['candidatesCountCompleted'] = User::where('user_role_id', '=', 6)->where('course_completion_status', '=', 3)->where('placement_status', '!=', 5)->get()->count();
            $data['candidatesCountPlaced'] = User::where('user_role_id', '=', 6)->where('placement_status', '=', 5)->get()->count();

        }elseif(auth()->user()->user_role_id == 2){
            $data['user_district'] = District::where('id', '=', auth()->user()->district_id)->where('districts.is_active', '=', 1)->select('name')->first();
            $data['widget_info_district'] = " ( ".$data['user_district']->name." )";

            $data['trainig_total_count'] = Course::where('is_active', '=', 1)->where('district_id', '=', auth()->user()->district_id)->count();
            $data['trainig_ongoing_count'] = Course::where('is_active', '=', 1)->where('district_id', '=', auth()->user()->district_id)->where('course_status', '=', 7)->count();
            $data['trainig_completed_count'] = Course::where('is_active', '=', 1)->where('district_id', '=', auth()->user()->district_id)->where('course_status', '=', 3)->count();

            $data['trainigs'] = Course::leftJoin('users', function($join) {
                $join->on('courses.id', '=', 'users.course_id')->where('users.user_role_id', '=', 6)->where('users.profile_status', '=', 2);
              })->leftJoin('districts', function($join) {
                $join->on('courses.district_id', '=', 'districts.id')->where('districts.is_active', '=', 1);
              })->leftJoin('program_implementation_agencies', function($join) {
                $join->on('courses.pia_id', '=', 'program_implementation_agencies.id')->where('program_implementation_agencies.is_active', '=', 1);
              })->select('courses.id', 'courses.training_name', 'districts.name as district_name', 'program_implementation_agencies.agency_name', Course::raw('count(courses.id) as total_students'))->where('courses.district_id', '=', auth()->user()->district_id)->where('courses.course_status', '=', 7)->where('courses.is_active', '=', 1)->groupBy('courses.id')->orderBy('courses.id','DESC')->limit(5)->get();

            $data['piasCount'] = User::where('user_role_id', '=', 4)->where('status', '=', 1)->get()->count();
            $data['employersCount'] = User::where('user_role_id', '=', 5)->where('status', '=', 1)->get()->count();
            $data['candidatesCount'] = CandidateInterest::Where('status', '=', 1)->where('district_id', '=', auth()->user()->district_id)->count();
            $data['candidatesCountCompleted'] = User::where('user_role_id', '=', 6)->where('district_id', '=', auth()->user()->district_id)->where('course_completion_status', '=', 3)->where('placement_status', '!=', 5)->get()->count();
            $data['candidatesCountPlaced'] = User::where('user_role_id', '=', 6)->where('district_id', '=', auth()->user()->district_id)->where('placement_status', '=', 5)->get()->count();
        }elseif(auth()->user()->user_role_id == 3){
            $data['user_district'] = District::where('id', '=', auth()->user()->district_id)->where('is_active', '=', 1)->select('name')->first();
            $data['widget_info_district'] = " ( ".$data['user_district']->name." )";

            $data['trainig_total_count'] = Course::where('is_active', '=', 1)->where('district_id', '=', auth()->user()->district_id)->count();
            $data['trainig_ongoing_count'] = Course::where('is_active', '=', 1)->where('district_id', '=', auth()->user()->district_id)->where('course_status', '=', 7)->count();
            $data['trainig_completed_count'] = Course::where('is_active', '=', 1)->where('district_id', '=', auth()->user()->district_id)->where('course_status', '=', 3)->count();

            $data['trainigs'] = Course::leftJoin('users', function($join) {
                $join->on('courses.id', '=', 'users.course_id')->where('users.user_role_id', '=', 6)->where('users.profile_status', '=', 2);
              })->leftJoin('districts', function($join) {
                $join->on('courses.district_id', '=', 'districts.id')->where('districts.is_active', '=', 1);
              })->leftJoin('program_implementation_agencies', function($join) {
                $join->on('courses.pia_id', '=', 'program_implementation_agencies.id')->where('program_implementation_agencies.is_active', '=', 1);
              })->select('courses.id', 'courses.training_name', 'districts.name as district_name', 'program_implementation_agencies.agency_name', Course::raw('count(courses.id) as total_students'))->where('courses.district_id', '=', auth()->user()->district_id)->where('courses.course_status', '=', 7)->where('courses.is_active', '=', 1)->groupBy('courses.id')->orderBy('courses.id','DESC')->limit(5)->get();

            $data['piasCount'] = User::where('user_role_id', '=', 4)->where('status', '=', 1)->get()->count();
            $data['employersCount'] = User::where('user_role_id', '=', 5)->where('status', '=', 1)->get()->count();
            $data['candidatesCount'] = CandidateInterest::Where('status', '=', 1)->where('district_id', '=', auth()->user()->district_id)->count();
            $data['candidatesCountCompleted'] = User::where('user_role_id', '=', 6)->where('district_id', '=', auth()->user()->district_id)->where('course_completion_status', '=', 3)->where('placement_status', '!=', 5)->get()->count();
            $data['candidatesCountPlaced'] = User::where('user_role_id', '=', 6)->where('district_id', '=', auth()->user()->district_id)->where('placement_status', '=', 5)->get()->count();
        }
        
        $data['totalCount'] = User::get()->count();
       
        return view("admin.pages.dashboard", ["data"=>$data]);
    }

    public function training_list()
    {
      if (auth()->user()->user_role_id == 1){
        $data['trainigs'] = Course::leftJoin('users', function($join) {
          $join->on('courses.id', '=', 'users.course_id')->where('users.user_role_id', '=', 6)->where('users.profile_status', '=', 2);
        })->leftJoin('districts', function($join) {
          $join->on('courses.district_id', '=', 'districts.id')->where('districts.is_active', '=', 1);
        })->leftJoin('program_implementation_agencies', function($join) {
          $join->on('courses.pia_id', '=', 'program_implementation_agencies.id')->where('program_implementation_agencies.is_active', '=', 1);
        })->select('courses.id', 'courses.training_name', 'districts.name as district_name', 'program_implementation_agencies.agency_name', Course::raw('count(users.id) as total_students'))->where('courses.course_status', '=', 7)->where('courses.is_active', '=', 1)->groupBy('courses.id')->orderBy('courses.id','DESC')->get();

      } elseif ( auth()->user()->user_role_id == 2 || auth()->user()->user_role_id == 3 ){
          $data['trainigs'] = Course::leftJoin('users', function($join) {
            $join->on('courses.id', '=', 'users.course_id')->where('users.user_role_id', '=', 6)->where('users.profile_status', '=', 2);
          })->leftJoin('districts', function($join) {
            $join->on('courses.district_id', '=', 'districts.id')->where('districts.is_active', '=', 1);
          })->leftJoin('program_implementation_agencies', function($join) {
            $join->on('courses.pia_id', '=', 'program_implementation_agencies.id')->where('program_implementation_agencies.is_active', '=', 1);
          })->select('courses.id', 'courses.training_name', 'districts.name as district_name', 'program_implementation_agencies.agency_name', Course::raw('count(courses.id) as total_students'))->where('courses.district_id', '=', auth()->user()->district_id)->where('courses.course_status', '=', 7)->where('courses.is_active', '=', 1)->groupBy('courses.id')->orderBy('courses.id','DESC')->get();
      }
      return view("admin.pages.training_list", ["data"=>$data]);
    }
    public function admin_create()
    {

      
      if (auth()->user()->user_role_id == 1){
   
      $districts = District::distinct('districts.id')->leftJoin('users', function($join) {
        $join->on('districts.id', '=', 'users.district_id')->where('users.user_role_id', '=', 2)->where('users.status', '=', 1);
      })->select('districts.id', 'districts.name', 'users.id as users_id', 'users.state_id as user_state', 'users.status as user_status')->get();
      return view("admin.pages.admin_create", compact('districts'));
    }elseif(auth()->user()->user_role_id == 2){
      $district = District::Where('id', '=', auth()->user()->district_id)->first();
      $blocks = Block::distinct('block.id')->leftJoin('users', function($join) {
        $join->on('blocks.id', '=', 'users.block_id')->where('users.user_role_id', '=', 3)->where('users.status', '=', 1);
      })->leftJoin('districts', function($join) {
        $join->on('blocks.district_id', '=', 'districts.id');
      })->select('blocks.id', 'blocks.name', 'users.id as users_id', 'users.district_id as user_district', 'users.status as user_status', 'districts.name as district_name')->where('blocks.district_id', auth()->user()->district_id)->get();
      return view("admin.pages.block_admin_create", compact('district', 'blocks'));
    }
      
    }

 
    public function admin_form_block_list(Request $request)
    {
        $validator = Validator::make($request->all(), ['district' => 'required|numeric']);

        if ($validator->fails()) {
            $response['status'] = "error";
            $response['message'] = implode(",", $validator->errors()->all());
        } else {

            $blocks =  Block::distinct('block.id')->leftJoin('users', function($join) {
              $join->on('blocks.id', '=', 'users.block_id')->where('users.user_role_id', '=', 3)->where('users.status', '=', 1);
            })->leftJoin('districts', function($join) {
              $join->on('blocks.district_id', '=', 'districts.id');
            })->select('blocks.id', 'blocks.name', 'users.id as users_id', 'users.district_id as user_district', 'users.status as user_status', 'districts.name as district_name')->where('blocks.district_id', $request->district)->get();

            $response['status'] = "success";
            $response['message'] = "";
            $response['blocks'] = $blocks;
        }

        return response()->json($response);
    } 
    
    public function admin_create_submit(Request $request)
    {
          try {
            if($request->role == 2){
              $rules = [
                'admin_name' => 'required|string',
                'district' => 'required|numeric|exists:districts,id',
                'mobile_number' => 'required|numeric|min:10|unique:users,mobile_number',
                'email' => 'required|email|unique:users,email',
                'role' => 'required|numeric'
            ];

            }else{
              $rules = [
                'admin_name' => 'required|string',
                'district' => 'required|numeric|exists:districts,id',
                'block' => 'required|numeric|exists:blocks,id',
                'mobile_number' => 'required|numeric|min:10|unique:users,mobile_number',
                'email' => 'required|email|unique:users,email'
            ];
            }
            
            $validator = Validator::make($request->all(), $rules);
            if ($validator->fails()) {
              $response['status'] = "error";
              $response['message'] = implode(",", $validator->errors()->all());
              $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

              
              if ($request->role == 2) {
                if($dist_admin_current = User::where('district_id', $request->district)->where('user_role_id', 2)->where('status', 1)){
                  $districtadmin = User::where('district_id', $request->district)
                  ->where('user_role_id', 2)
                  ->where('status', 1)
                  ->first();  
              
              try {
                  if ($districtadmin) {
                    Mail::to($districtadmin->email)->send(new adminDeactive($districtadmin));
                  } else {
                      Log::error('User not found for district admin deactivation.');
                  }
              } catch (\Exception $e) {
                  Log::error('Email sending failed: ' . $e->getMessage());
                  if ($districtadmin) {
                      Log::error('Email id: ' . $districtadmin->email);
                  } else {
                      Log::error('User not found for district admin deactivation.');
                  }
              }
                  
                  $dist_admin_current->update([
                    'status' => 11,
                    'profile_status' => 11
                ]);

                 
                }
                          
              }elseif ($request->role == 3) {
                if($block_admin_current = User::where('block_id', $request->block)->where('user_role_id', 3)->where('status', 1)){
                  $blockedadmin = User::where('block_id', $request->block)
                  ->where('user_role_id', 3)
                  ->where('status', 1)
                  ->first();  // Fetch the user object using 'first()'
              
              try {
                  if ($blockedadmin) {
                      Mail::to($blockedadmin->email)->send(new adminDeactive($blockedadmin));
                  } else {
                      Log::error('User not found for block admin deactivation.');
                  }
              } catch (\Exception $e) {
                  Log::error('Email sending failed: ' . $e->getMessage());
                  if ($blockedadmin) {
                      Log::error('Email id: ' . $blockedadmin->email);
                  } else {
                      Log::error('User not found for block admin deactivation.');
                  }
              }
              
                  $block_admin_current->update([
                    'status' => 11,
                    'profile_status' => 11
                ]);
                //dd($block_admin_current->id);
               
                }
              }
              $password = "Pass_".rand(999999, 000000);

              DB::beginTransaction();

                  $user = new User();
                  $user->name = $request->admin_name;
                  $user->user_role_id = $request->role;
                  $user->country_id = 1;
                  $user->state_id = 32;
                  $user->district_id = $request->district;
                  if(isset($request->block)){
                    $user->block_id = $request->block;
                  }
                  $user->email = $request->email;
                  $user->mobile_number = $request->mobile_number;
                  $user->password = Hash::make($password);
                  $user->created_by = auth()->user()->id;
                  $user->updated_by = auth()->user()->id;
                  $user->status = 1;


                  $user->save();

                  DB::commit();

                  if ($user->id > 0) {

                   Mail::to($user)->send(new AdminRegistration($user, $password));

                    $response['status'] = "success";
                    $response["message"] = "Admin account created";
                    $response['developer_message'] = "";
                    $response['redirect'] = route('admin_list');

                } else {

                    $response['status'] = "error";
                    $response["message"] = "Something went wrong try";
                    $response['developer_message'] = "";


                }

            }

          } catch (\Exception $e) {

            DB::rollback();
            $response['status'] = "error";
            $response['message'] = "Something went wrong catch";
            $response['developer_message'] = $e->getMessage();
          }

          return response()->json($response);
    }


    public function admin_list()
    {

      if (auth()->user()->user_role_id == 1){
        $admins = User::leftJoin('user_roles', function($join) {
          $join->on('users.user_role_id', '=', 'user_roles.id');
        })->leftJoin('districts', function($join) {
          $join->on('users.district_id', '=', 'districts.id')->Where('districts.is_active', '=', 1);
        })->leftJoin('blocks', function($join) {
          $join->on('users.block_id', '=', 'blocks.id')->Where('blocks.is_active', '=', 1);
        })->select('users.id', 'users.name as user_name', 'users.district_id', 'users.mobile_number', 'users.email', 'user_roles.role', 'districts.name as district_name', 'blocks.name as block_name', 'users.status')->Where('status', '=', 1)->where(function ($query) {
          $query->Where('users.user_role_id', '=', 2)->orWhere('users.user_role_id', '=', 3);
      })->orderBy('id', 'desc')->get();
        return view('admin.pages.admin_list', compact('admins'));
      }elseif (auth()->user()->user_role_id == 2){
        $block_admins = User::leftJoin('user_roles', function($join) {
          $join->on('users.user_role_id', '=', 'user_roles.id');
        })->leftJoin('districts', function($join) {
          $join->on('users.district_id', '=', 'districts.id')->Where('districts.is_active', '=', 1);
        })->leftJoin('blocks', function($join) {
          $join->on('users.block_id', '=', 'blocks.id')->Where('blocks.is_active', '=', 1);
        })->select('users.id', 'users.name as user_name', 'users.district_id', 'users.mobile_number', 'users.email', 'user_roles.role', 'districts.name as district_name', 'blocks.name as block_name', 'users.status')->Where('user_role_id', '=', 3)->Where('users.district_id', '=', auth()->user()->district_id)->Where('users.status', '=', 1)->orderBy('users.id', 'desc')->get();
        return view('admin.pages.block_admin_list', compact('block_admins'));
      }
        
    }



    public function deactivateAdmin(Request $request)
    {


        try {

            $validator = Validator::make($request->all(), ['admin' => 'required|string']);

            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {
              $admin = User::find(base64_decode($request->admin));
             // dd($admin);
               User::whereId(base64_decode($request->admin))->update(['status' => 11, 'updated_by' => auth()->user()->id]);
                try {
                Mail::to($admin->email)->send(new adminDeactive($admin));
                $response['status'] = "success";
                $response['message'] = "Admin deleted successfully";
                $response['developer_message'] = "";
                $response['redirect'] = route('admin_list');
            } catch (\Exception $e) {
                // Log or handle the exception
                Log::error('Error sending email: ' . $e->getMessage());
                Log::error($e);
                $response['status'] = "error";
                $response['message'] = "Error sending email";
                $response['developer_message'] = $e->getMessage();
            }
                


            }


        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);
    }

    public function editAdmin(Request $request, $id)
    {

        $user = User::find(base64_decode($id));
        $districts = District::leftJoin('users', function($join) {
          $join->on('districts.id', '=', 'users.district_id')->where('users.user_role_id', '=', 2)->where('users.status', '=', 1);
        })->select('districts.id', 'districts.name', 'users.id as users_id', 'users.state_id as user_state', 'users.status as user_status')->where('districts.state_id', $user->state_id)->get();
  
        $blocks = Block::leftJoin('users', function($join) {
          $join->on('blocks.id', '=', 'users.block_id')->where('users.user_role_id', '=', 3)->where('users.status', '=', 1);
        })->leftJoin('districts', function($join) {
          $join->on('blocks.district_id', '=', 'districts.id');
        })->select('blocks.id', 'blocks.name', 'users.id as users_id', 'users.district_id as user_district', 'users.status as user_status', 'districts.name as district_name')->where('blocks.district_id', $user->district_id)->get();

            
            if (auth()->user()->user_role_id == 1){
              return view('admin.pages.admin_edit', compact('user', 'districts', 'blocks'));
            }elseif (auth()->user()->user_role_id == 2){
              return view('admin.pages.block_admin_edit', compact('user', 'districts', 'blocks'));
            }


    }
    public function updateAdminDetails(Request $request)
    {



      if ($request->user_role_id == 2) {

          $rules = [
              'id' => 'required|numeric|exists:users,id',
              'user_role_id' => 'required|numeric',
              'district' => 'required|numeric|exists:districts,id',
              'mobile_number' => 'required|numeric|min:10|unique:users,mobile_number,'.$request->id,
              'email' => 'required|email|unique:users,email,'.$request->id
          ];
  
      }elseif ($request->user_role_id == 3) {
        if(auth()->user()->user_role_id == 1){
            $rules = [
              'id' => 'required|numeric|exists:users,id',
              'user_role_id' => 'required|numeric',
              'district' => 'required|numeric|exists:districts,id',
              'block' => 'required|numeric|exists:blocks,id',
              'mobile_number' => 'required|numeric|min:10|unique:users,mobile_number,'.$request->id,
              'email' => 'required|email|unique:users,email,'.$request->id
          ];
        }else{
          $rules = [
            'id' => 'required|numeric|exists:users,id',
            'user_role_id' => 'required|numeric',
            'block' => 'required|numeric|exists:blocks,id'
        ];
        }
      }
      $validator = Validator::make($request->all(), $rules);
      try{


            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

              if ($request->user_role_id == 2) {
                if($dist_admin_current = User::where('district_id', $request->district)->where('id', '!=', $request->id)->where('user_role_id', 2)->where('status', 1)){
                  $districtadmin = User::where('district_id', $request->district)
                                   ->where('id', '!=', $request->id)
                                   ->where('user_role_id', 2)
                                   ->where('status', 1)
                                   ->first();                
              try {
                  if ($districtadmin) {

                    Mail::to($districtadmin->email)->send(new adminDeactive($districtadmin));
                  } else {
                      Log::error('User not found for district admin deactivation.');
                  }
              } catch (\Exception $e) {
                  Log::error('Email sending failed: ' . $e->getMessage());
                  if ($districtadmin) {
                      Log::error('Email id: ' . $districtadmin->email);
                  } else {
                      Log::error('User not found for district admin deactivation.');
                  }
              }
                  $dist_admin_current->update([
                    'status' => 11,
                    'profile_status' => 11                    
                ]);        
                }              
                  $user = User::where('status', 1)->find($request->id);
                  $user->user_role_id = $request->user_role_id; 
                  $user->email = $request->email;
                  $user->mobile_number = $request->mobile_number;
                    $user->district_id = $request->district;
                    $user->block_id = NULL;
                    // $user->block_id = 0;
                    $user->updated_by = $request->user()->id;
                    
                    $user->save();

                    DB::commit();

                    if ($user->id > 0) {


                        $response['status'] = "success";
                        $response["message"] = "The district admin account was updated.";
                        $response['developer_message'] = "";
                        $response['redirect'] = route('admin_list');

                    } else {

                        $response['status'] = "error";
                        $response["message"] = "Something went wrong";
                        $response['developer_message'] = "";
                    }

          
              }elseif ($request->user_role_id == 3) {
                
                if($block_admin_current = User::where('block_id', $request->block)->where('id', '!=', $request->id)->where('user_role_id', 3)->where('status', 1)){
                  $blockadmin = User::where('block_id', $request->block)
                                         ->where('id', '!=', $request->id)
                                         ->where('user_role_id', 3)
                                         ->where('status', 1)
                                         ->first();  
              
              try {
                  if ($blockadmin) {

                    Mail::to($blockadmin)->send(new adminDeactive($blockadmin));
                  } else {
                      Log::error('User not found for district admin deactivation.');
                  }
              } catch (\Exception $e) {
                  Log::error('Email sending failed: ' . $e->getMessage());
                  if ($blockadmin) {
                      Log::error('Email id: ' . $blockadmin->email);
                  } else {
                      Log::error('User not found for district admin deactivation.');
                  }
              }
                  $block_admin_current->update([
                    'status' => 11,
                    'profile_status' => 11
                ]);
                }
                $user = User::where('status', 1)->find($request->id);
                $user->user_role_id = $request->user_role_id;
                if(auth()->user()->user_role_id == 1){ 
                  $user->email = $request->email;
                  $user->mobile_number = $request->mobile_number;
                  $user->district_id = $request->district;
                }
                $user->block_id = $request->block;
                $user->updated_by = $request->user()->id;
                $user->save();

                    DB::commit();

                    if ($user->id > 0) {


                        $response['status'] = "success";
                        $response["message"] = "The block admin account was updated.";
                        $response['developer_message'] = "";
                        $response['redirect'] = route('admin_list');

                    } else {

                        $response['status'] = "error";
                        $response["message"] = "Something went wrong";
                        $response['developer_message'] = "";
                    }
              }

            }
          } catch (\Exception $e) {

            DB::rollback();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();
        }
        return response()->json($response);
    }

    
    public function UpdateInactiveAdminDetails(Request $request)
    {
     
      if ($request->user_role_id == 2) {

        $rules = [
          'id' => 'required|numeric|exists:users,id',
          'user_role_id' => 'required|numeric',
          'district' => 'required|numeric|exists:districts,id',
          'mobile_number' => 'required|numeric|min:10|unique:users,mobile_number,'.$request->id,
          'email' => 'required|email|unique:users,email,'.$request->id
      ];
  
      }elseif ($request->user_role_id == 3) {

        if(auth()->user()->user_role_id == 1){
          $rules = [
            'id' => 'required|numeric|exists:users,id',
            'user_role_id' => 'required|numeric',
            'district' => 'required|numeric|exists:districts,id',
            'block' => 'required|numeric|exists:blocks,id',
            'mobile_number' => 'required|numeric|min:10|unique:users,mobile_number,'.$request->id,
            'email' => 'required|email|unique:users,email,'.$request->id
        ];
        }else{
          $rules = [
            'id' => 'required|numeric|exists:users,id',
            'user_role_id' => 'required|numeric|exists:users,user_role_id',
            'block' => 'required|numeric|exists:blocks,id'
        ];
        }
            
      }
      $validator = Validator::make($request->all(), $rules);
      try{
            if ($validator->fails()) {
                $response['status'] = "error";
                $response['message'] = implode(",", $validator->errors()->all());
                $response['developer_message'] = implode(",", $validator->errors()->all());
            } else {

              if ($request->user_role_id == 2) {
                if($dist_admin_current = User::where('district_id', $request->district)->where('user_role_id', 2)->where('status', 1)){
                  $districtadmin = User::where('district_id', $request->district)
                  ->where('user_role_id', 2)
                  ->where('status', 1)
                  ->first();  
              
              try {
                  if ($districtadmin) {
                    Mail::to($districtadmin->email)->send(new adminDeactive($districtadmin));
                  } else {
                      Log::error('User not found for district admin deactivation.');
                  }
              } catch (\Exception $e) {
                  Log::error('Email sending failed: ' . $e->getMessage());
                  if ($districtadmin) {
                      Log::error('Email id: ' . $districtadmin->email);
                  } else {
                      Log::error('User not found for district admin deactivation.');
                  }
              }
                  $dist_admin_current->update([
                    'status' => 11,
                    'profile_status' => 11
                    
                ]);
                
                }
                  $user = User::where('users.status', '=', 11)->find($request->id);

                    $user->user_role_id = $request->user_role_id; 
                    $user->email = $request->email;
                    $user->mobile_number = $request->mobile_number;
                    $user->district_id = $request->district;
                    $user->block_id = NULL;
                    $user->status = 1;
                    $user->profile_status = 1;
                    // $user->block_id = 0;
                    $user->updated_by = $request->user()->id;
                    $user->save();

                    DB::commit();
                    $adminuser = User::where('id', $user->id)
                      ->first();
                      try {
                        if ($adminuser) {
                          Mail::to($adminuser)->send(new adminReactive($adminuser));
                        } else {
                            Log::error('User not found for admin reactivation.');
                        }
                    } catch (\Exception $e) {
                        Log::error('Email sending failed: ' . $e->getMessage());
                        if ($adminuser) {
                            Log::error('Email id: ' . $adminuser->email);
                        } else {
                            Log::error('User not found for admin reactivation.');
                        }
                    }

                    if ($user->id > 0) {


                        $response['status'] = "success";
                        $response["message"] = "The district admin account has been activated.";
                        $response['developer_message'] = "";

                    } else {

                        $response['status'] = "error";
                        $response["message"] = "Something went wrong";
                        $response['developer_message'] = "";
                    }

          
              }elseif ($request->user_role_id == 3) {
                
                if($block_admin_current = User::where('block_id', $request->block)->where('user_role_id', 3)->where('status', 1)){
                  $blockadmin = User::where('block_id', $request->block)
                ->where('user_role_id', 3)
                ->where('status', 1)
                ->first();  
              
              try {
                  if ($blockadmin) {
                    Mail::to($blockadmin->email)->send(new adminDeactive($blockadmin));
                  } else {
                      Log::error('User not found for block admin deactivation.');
                  }
              } catch (\Exception $e) {
                  Log::error('Email sending failed: ' . $e->getMessage());
                  if ($blockadmin) {
                      Log::error('Email id: ' . $blockadmin->email);
                  } else {
                      Log::error('User not found for block admin deactivation.');
                  }
              }
              
                  $block_admin_current->update([
                    'status' => 11,
                    'profile_status' => 11
                ]);
                
                }
                $user = User::where('users.status', '=', 11)->find($request->id);
                if(auth()->user()->user_role_id == 1){ 
                  $user->user_role_id = $request->user_role_id;
                  $user->email = $request->email;
                  $user->mobile_number = $request->mobile_number;
                  $user->district_id = $request->district;
                }
                $user->block_id = $request->block;
                $user->status = 1;
                $user->profile_status = 1;
                $user->updated_by = $request->user()->id;
                $user->save();

                    DB::commit();
                    $adminuser = User::where('id', $user->id)
                      ->first();
                      try {
                        if ($adminuser) {
                          Mail::to($adminuser)->send(new adminReactive($adminuser));
                        } else {
                            Log::error('User not found for admin reactivation.');
                        }
                    } catch (\Exception $e) {
                        Log::error('Email sending failed: ' . $e->getMessage());
                        if ($adminuser) {
                            Log::error('Email id: ' . $adminuser->email);
                        } else {
                            Log::error('User not found for admin reactivation.');
                        }
                    }

                    if ($user->id > 0) {
                                      


                        $response['status'] = "success";
                        $response["message"] = "The block admin account has been activated.";
                        $response['developer_message'] = "";

                    } else {

                        $response['status'] = "error";
                        $response["message"] = "Something went wrong";
                        $response['developer_message'] = "";
                    }
              }

            }
          } catch (\Exception $e) {

            DB::rollback();
            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();
        }
        return response()->json($response);
    }

    public function admin_list_inactive()
    {

      if (auth()->user()->user_role_id == 1){
        $admins = User::leftJoin('user_roles', function($join) {
          $join->on('users.user_role_id', '=', 'user_roles.id');
        })->leftJoin('districts', function($join) {
          $join->on('users.district_id', '=', 'districts.id');
        })->leftJoin('blocks', function($join) {
          $join->on('users.block_id', '=', 'blocks.id')->Where('blocks.is_active', '=', 1);
        })->select('users.id', 'users.name as user_name', 'users.district_id', 'users.mobile_number', 'users.email', 'user_roles.role', 'districts.name as district_name', 'blocks.name as block_name', 'users.status')->where(function ($query) {
          $query->Where('users.user_role_id', '=', 2)->orWhere('users.user_role_id', '=', 3);
      })->where('users.status', '=', 11)->orderBy('users.id', 'desc')->get();
        return view('admin.pages.admin_list_inactive', compact('admins'));
      }elseif (auth()->user()->user_role_id == 2){
        $block_admins = User::leftJoin('user_roles', function($join) {
          $join->on('users.user_role_id', '=', 'user_roles.id');
        })->leftJoin('districts', function($join) {
          $join->on('users.district_id', '=', 'districts.id');
        })->leftJoin('blocks', function($join) {
          $join->on('users.block_id', '=', 'blocks.id')->Where('blocks.is_active', '=', 1);
        })->select('users.id', 'users.name as user_name', 'users.district_id', 'users.mobile_number', 'users.email', 'user_roles.role', 'districts.name as district_name', 'blocks.name as block_name', 'users.status')->Where('users.user_role_id', '=', 3)->Where('users.district_id', '=', auth()->user()->district_id)->Where('users.status', '=', 11)->orderBy('users.id', 'desc')->get();
        return view('admin.pages.block_admin_list_inactive', compact('block_admins'));
      }
        
    }

    public function editAdminInactive(Request $request, $id)
    {

        $user = User::where('users.status', '=', 11)->find(base64_decode($id));
        $districts = District::distinct('districts.id')->leftJoin('users', function($join) {
          $join->on('districts.id', '=', 'users.district_id')->where('users.user_role_id', '=', 2)->where('users.status', '=', 1);
        })->select('districts.id', 'districts.name', 'users.id as users_id', 'users.state_id as user_state', 'users.status as user_status')->where('districts.state_id', $user->state_id)->get();
  
        $blocks = Block::distinct('block.id')->leftJoin('users', function($join) {
          $join->on('blocks.id', '=', 'users.block_id')->where('users.user_role_id', '=', 3)->where('users.status', '=', 1);
        })->leftJoin('districts', function($join) {
          $join->on('blocks.district_id', '=', 'districts.id');
        })->select('blocks.id', 'blocks.name', 'users.id as users_id', 'users.district_id as user_district', 'users.status as user_status', 'districts.name as district_name')->where('blocks.district_id', $user->district_id)->get();

         
         if (auth()->user()->user_role_id == 1){
          return view('admin.pages.admin_edit_inactive', compact('user', 'districts', 'blocks'));
        }elseif (auth()->user()->user_role_id == 2){
          return view('admin.pages.block_admin_edit_inactive', compact('user', 'districts', 'blocks'));
        }

    }

    /******************Pan Number Already Exist************************ */
    public function PanNumberCheck(Request $request)
    {
      $pan = "PABS1234QQ";
      //$pan =  $request->pan
      $user = User::wherePanNumber($pan)->get();

        if ($user->count()>0) {
            $response['status'] = "1";//Already exist
        } else {           
            $response['status'] = "0";//no exist
           
        }

        return response()->json($response);
    }

     /******************Email Already Exist************************ */
     public function EmailCheck(Request $request)
     {
       $email = "PABS1234QQ";
       //$email =  $request->email
       $user = User::whereEmail($email)->get();
 
         if ($user->count()>0) {
             $response['status'] = "1";//Already exist
         } else {           
             $response['status'] = "0";//no exist
            
         }
 
         return response()->json($response);
     }

       /******************mobile_number Already Exist************************ */
       public function mobile_number(Request $request)
       {
         $mob = "9497163591";
         //$email =  $request->email
         $user = User::whereMobileNumber($mob)->get();
   
           if ($user->count()>0) {
               $response['status'] = "1";//Already exist
           } else {           
               $response['status'] = "0";//no exist
              
           }
   
           return response()->json($response);
       }
     
}
