<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\CandidateInterest;
use App\Models\CanadidateInterestCourseMaster;
use App\Models\Course;
use App\Models\User;
use App\Models\CourseMaster;
use App\Models\Country;
use App\Models\ProgramImplementationAgency;
use App\Models\District;
use App\Models\Block;
use App\Models\Localbody;
use App\Models\Localbodytype;
use App\Models\Status;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use App\Mail\CandidateRegistration;
use App\Mail\CandidateDeactivation;
use App\Mail\CandidateCredentials;
use Mail;

class CandidateController extends Controller
{
    public function candidatejoinedList()
    {
        $data['users'] = User::where('status', '!=', 8)
                ->where('user_role_id', '=', 6)
                ->get();
        return view('admin.pages.candidatejoinedlist',compact('data'));
        //->with('candidates', $candidates);        
    }

    public function candidateListDet($type,$cid)
    {
        $type= base64_decode($type);
        $defaultDate = Carbon::now()->subYears(18)->format('d-m-Y');
        $cid= base64_decode($cid);                 
        $Candidate =   CandidateInterest::find($cid);
        $statuses = Status::all();
        $Courses =   CanadidateInterestCourseMaster::where('candidate_interest_id',$cid)->get();
        return view('admin.pages.candidatedet',compact('Candidate','Courses','type','statuses','defaultDate'));      
    }
      
    public function candidateList()
    {
        $data['candidates'] = CandidateInterest::where('status',1)->get();
        return view('admin.pages.candidatelist',compact('data'));
               
    }

    public function candidatejoinedListDet($type,$cid)
    {
        $type= base64_decode($type);
        $cid= base64_decode($cid);
        $defaultDate = Carbon::now()->subYears(18)->format('d-m-Y');
        if($type=='candi'){           
            $data['users'] =   CandidateInterest::find($cid);
            $data['Courses'] =   CanadidateInterestCourseMaster::where('candidate_interest_id',$cid)->get();
            return view('admin.pages.candidatedet',compact('data'));
        }else{
            $Candidate = User::find($cid);
            $PIA = User::where('id',$Candidate->id)->pluck('name');
           
        $empname="";
        if($Candidate->employer_id){
            $empname =  User::find($Candidate->employer_id);
       }
        $emplist = DB::table('users')->where('profile_status', 1)->orWhere('profile_status', 14)->where('user_role_id', 5)->get();
       
            $statuses = Status::all();
           // dd($statuses);
               // echo $cid; dd($Candidate);
            return view('admin.pages.candidatejoineddet',compact('empname','Candidate','type','statuses','PIA','defaultDate'));
        }
    }
   
    public function Deactivate_user(Request $req)
    {
        try {
            if(base64_decode($req->type) =='candi'){
                CandidateInterest::whereId($req->cid)->update(['status' => 8]);
            }else{
                User::whereId($req->cid)->update(['status' => 8]);
           }
                $response['status']="success";
                $response['message']="Candidate deactivated";
                $response['developer_message']="";        

        } catch (\Exception $e) {

            $response['status']="error";
            $response['message']="Something went wrong";
            $response['developer_message']=$e->getMessage();

        }
        if(base64_decode($req->type) =='candi'){
            return redirect()->route('candidateallist'); // Redirect to a specific route after insertion
        }else{
            return redirect()->route('candidatejoinedList'); // Redirect to a specific route after insertion
        }
    }

    public function deactivateCandidate(Request $request)
    {
       

        try {

          
                CandidateInterest::whereId($request->candidate)->update(['status' => 8]);
               $CandidateInterest = CandidateInterest::find($request->candidate);
              // dd($CandidateInterest);
              $user_type="New";
                Mail::to($CandidateInterest->email)->send(new CandidateDeactivation($CandidateInterest,$user_type));
                $response['status'] = "success";
                $response['message'] = "Candidate deactivated successfully";
                $response['developer_message'] = "";
                $response['redirect'] = route('candidateallist');


            


        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);
    }
    public function deactivateUser(Request $request)
    {
       

        try {

          
                User::whereId($request->candidate)->update(['status' => 8]);
               $User = User::find($request->candidate);
               $user_type='User';
              // dd($User);
                Mail::to($User->email)->send(new CandidateDeactivation($User,$user_type));
                $response['status'] = "success";
                $response['message'] = "Candidate deactivated successfully";
                $response['developer_message'] = "";
                $response['redirect'] = route('candidatejoinedList');


            


        } catch (\Exception $e) {

            $response['status'] = "error";
            $response['message'] = "Something went wrong";
            $response['developer_message'] = $e->getMessage();

        }

        return response()->json($response);
    }



   public function CheckSeatsCount(Request $request)
   { 
    
    try {   
            $cid = $request->input('cid');
            $trainingid = $request->input('course');
            $category = $request->input('category');

            $training = Course::find($trainingid); 
            $pr="NoProceed";          
            if($category =="General"){
               $gseats= $training->general_seats-$training->general_seats_filled;
               if($gseats >0){$pr="Proceed";
                
              
            }
            }else if($category =="SCST"){
                $SCSTseats= $training->scst_seats-$training->scst_seats_filled;
                if($SCSTseats >0){$pr="Proceed";
                   
                }
            }else{
                $mseats= $training->minority_seats-$training->minority_seats_filled;
                if($mseats >0){$pr="Proceed";
                }
            }
          if($pr!="Proceed"){  
            $response['error'] = 'Sorry,No more seats available for this selected Training';
            return response()->json($response);
        
        }
       
        // Continue with the rest of your logic...
    } catch (\Exception $e) {
        // Log the exception message
        \Log::error($e->getMessage());
    }
    // Return an error response
   
}

 
    
    public function loadTrainings(Request $request)
    {
       $validator = Validator::make($request->all(), ['master' => 'required|numeric|exists:course_masters,id']);

        if ($validator->fails()) {
            $response['status'] = "error";
            $response['message'] = implode(",", $validator->errors()->all());
        } else {

        $training = Course::where('coursemaster_id', $request->master)
        ->where('pia_id', auth()->user()->Piaid->id)
        ->get();        

        $response['status'] = "success";
        $response['message'] = "";
        $response['training'] = $training;
        return response()->json($response);


        }
       
    }

    public function AssignCourse(Request $req)
    {
     try {
            $cid   =   $req->input('cid');
            $Email   =   $req->input('Email');
            $ContactNumber   =   $req->input('ContactNumber');
            $BuildingName   =   $req->input('BuildingName');
            $Landmark   =   $req->input('Landmark');
            $PostOffice   =   $req->input('PostOffice');
            $PIN_Code   =   $req->input('PIN_Code');
            $training = Course::find($req->input('trainings')); 
            $pr="NoProceed";
            $CandidateInterestData = CandidateInterest::find($cid);
            if($CandidateInterestData->category =="General"){
               $gseats= $training->general_seats-$training->general_seats_filled;
               if($gseats >0){$pr="Proceed";
                $gseat = $training->general_seats_filled+1;
                $noseat = $training->no_of_seats_filled+1;
                $training->general_seats_filled = $gseat;
              
            }
            }else if(($CandidateInterestData->category =="SC") || ($CandidateInterestData->category =="ST")){
                $SCSTseats= $training->scst_seats-$training->scst_seats_filled;
                if($SCSTseats >0){$pr="Proceed";
                    $SCSTseat = $training->scst_seats_filled+1;
                    $noseat = $training->no_of_seats_filled+1;                    
                    $training->scst_seats_filled = $SCSTseat;
                }
            }else{
                $mseats= $training->minority_seats-$training->minority_seats_filled;
                if($mseats >0){$pr="Proceed";
                    $mseat = $training->minority_seats_filled+1;
                    $noseat = $training->no_of_seats_filled+1;                    
                     $training->minority_seats_filled = $mseat;
                }
            }
            $error =0;
            if (User::where('email', $Email)->exists()) {
                $error =1;
                // Email already exists, return error response
                return response()->json(['message' => 'Email already exists.'], 400);
            }
        
          if($pr=="Proceed" and $error==0){  


            $training->no_of_seats_filled = $noseat;          
            $training->save();

                            // Insert data into another table
                            $password = "KtcPia*" . rand(999999, 000000)."*";
                            DB::beginTransaction();

                            $user = new User();
                            $user->name = $CandidateInterestData->name; // Replace with your column names
                            $user->email = $Email;
                            $user->user_role_id = 6;
                            $user->country_id = $CandidateInterestData->country_id;
                            $user->state_id = $CandidateInterestData->state_id;
                            $user->district_id = $CandidateInterestData->district_id;
                            $user->block_id = $CandidateInterestData->block_id;
                            $user->localbody_id = $CandidateInterestData->localbodyid;
                            $user->lbTypeid = $CandidateInterestData->lbtypeid;
                            $user->password = Hash::make($password);
                            $user->mobile_number = $ContactNumber;
                            $user->phone_number = $CandidateInterestData->phone_number;
                            $user->registered_at = $CandidateInterestData->created_at;
                            $user->building_name = $BuildingName;
                            $user->landmark = $Landmark;
                            $user->postOffice = $PostOffice;
                            $user->pincode = $PIN_Code;
                            $user->sector_id = $CandidateInterestData->sector_id;
                            $user->course_id = $req->input('trainings');
                            $user->course_master_id = $req->input('MasterCourse');
                            $user->profile_status = 11;
                            $user->course_completion_status = 2;//joined
                            $user->placement_status = 0;    

                            $user->created_by = auth()->user()->Piaid->id; 
                            $user->updated_by = auth()->user()->Piaid->id;  
                            $user->highest_qualification = $CandidateInterestData->highest_qualification;
                            $user->additional_certificates = $CandidateInterestData->additional_certificates;
                            $user->religion = $CandidateInterestData->religion; 
                            $user->category = $CandidateInterestData->category; 
                            $user->pwd = $CandidateInterestData->pwd;
                            $user->rationcardtype = $CandidateInterestData->rationcardtype; 
                            $user->MGNREGA = $CandidateInterestData->MGNREGA;
                            $user->gender = $CandidateInterestData->gender; 
                            $user->willingTojoin = $CandidateInterestData->willingTojoin;
                            $user->kudumbashree_member = $CandidateInterestData->kudumbashree_member; 
                            $user->join_type = 13;//By PIA

                            
                            $user->save();

                            $CandidateInterestDatas = CandidateInterest::find($cid);
                            $CandidateInterestDatas->status = '8';        
                            $CandidateInterestDatas->save();
                            DB::commit();

                        
                            Mail::to($CandidateInterestData->email)->send(new CandidateRegistration($CandidateInterestData->name, $training));
                        
                    
                    return redirect()->route('candidateInterestList'); // Redirect to a specific route after insertion
 
                }else{
echo "Sorry,There is no seats available in this Category";
                }

            }catch(\Exception $e)
            {
            // echo "hello";
                DB::rollback();
                $msg = $e->getMessage();echo $msg;
            }
  }
  
  
  public function AssignCourseJoined(Request $req)
  {
   try {
          $cid   =   $req->input('cid');
          $userdata = User::find($cid);
          $courseId = $userdata->course_id;   
          $category = $userdata->category;  
          $training = Course::find($courseId); 
          if($category =="General"){
           
             $gseat = $training->general_seats_filled-1;
             $noseat = $training->no_of_seats_filled-1;
             $training->general_seats_filled = $gseat;
           
         }else if($category =="SCST"){
            
                 $SCSTseat = $training->scst_seats_filled-1;
                 $noseat = $training->no_of_seats_filled-1;                 
                 $training->scst_seats_filled = $SCSTseat;
             }else{
          
                 $mseat = $training->minority_seats_filled-1;
                 $noseat = $training->no_of_seats_filled-1;                    
                  $training->minority_seats_filled = $mseat;
             }
         
         $training->no_of_seats_filled = $noseat;          
         $training->save();
          $password = "KtcUser*" . rand(999999, 000000)."*";
          DB::beginTransaction();          
          $userdata->password = Hash::make($password);
          if($req->input('course_completion_status')==3){
            $userdata->profile_status = 1;
         }
         
          $userdata->course_completion_status = $req->input('course_completion_status');
          $userdata->updated_by = Auth::user()->id;  
          $userdata->save();
          DB::commit();
          if($req->input('course_completion_status')==3){
            Mail::to($userdata->email)->send(new CandidateCredentials($userdata, $password));
          }
   }catch(\Exception $e)
   {
      DB::rollback();
      $msg = $e->getMessage();echo $msg;
   }
   return redirect()->route('candidateInterestJoinedList'); // Redirect to a specific route after insertion
}
}
