<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;

class MakeEverything extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:everything {name}';
    protected $description = 'Create migration, model, and repository';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $name = $this->argument('name');
        $repositoryClass =  $name . 'Repository';

        // Create Migration
        Artisan::call('make:migration', ['name' => $name]);

        // Create Model
        Artisan::call('make:model', ['name' => $name]);

        // Create Repository
        $repositoryPath = app_path('Repositories/' . $name . 'Repository.php');

        if (File::exists($repositoryPath)) {
            $this->error('Repository already exists!');
        } else {
            File::put($repositoryPath, $this->getRepositoryStub($repositoryClass));
            $this->info('Repository created successfully.');
        }

        $this->info('Migration and Model created successfully.');
    }
    protected function getRepositoryStub($repositoryClass)
    {
        // You can customize this stub based on your repository structure
        return "<?php\n\nnamespace App\Repositories;\n\nclass $repositoryClass\n{\n    // Your repository logic goes here\n}\n";
    }
}
