<?php
/*
Template Name: Staff Page
*/

get_header();
?>
<!-- Breadcrumb Area Start -->
  <div class="tp-breadcrumb-area tp-breadcrumb-spacing bg-position" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/01.jpg">
         <div class="container">
            <div class="row">
               <div class="col-lg-12 px-0">
                  <div class="tp-breadcrumb-content">
                     <h2 class="tp-breadcrumb-title mb-15 wow fadeInRight" data-wow-duration=".9s" data-wow-delay=".3s">
                     <?php the_title(); ?></h2>
                     <div class="tp-breadcrumb-list wow fadeInLeft" data-wow-duration=".9s" data-wow-delay=".3s">
                        <span><a href="<?php echo home_url(); ?>">Home</a></span>
                        <span class="tp-breadcrumb-dvdr">-</span>
                        <span class="tp-breadcrumb-title-pre"><?php the_title(); ?></span>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
<!-- Breadcrumb Area End -->

<!-- Content Section Start -->
  <!--content section-->
  <div class="content-main">
         <div class="container">
            <?php
$departments = ['CEO', 'Staffs']; 
foreach ($departments as $dept):
    $staffs = new WP_Query([
        'post_type' => 'staff',
        'posts_per_page' => -1,
        'meta_key' => 'department_',
        'meta_value' => $dept,
    ]);
 
    if ($staffs->have_posts()):
?>  
<!--<h4 class="mb-3"><?php echo esc_html($dept); ?> </h4>-->

<div class="row justify-content-center align-items-center"> <?php while ($staffs->have_posts()): $staffs->the_post(); ?>
<div class="col-md-4 mb-4">
<div class="p-4 cont-item">
<div class="mb-25">
          <?php
          $image = get_field('image'); // ACF image field
          if ($image) {
              echo wp_get_attachment_image($image['ID'], 'medium', false, ['class' => 'img-fluid']);
          }
          ?>
        </div>   
<h5 class="mb-1"><?php the_title(); ?></strong> </h5>
<p class="text-muted mb-1"> <?php the_field('position'); ?></p>
<p class="text-muted mb-1"> <?php the_field('contact'); ?></p>
</div>
</div>        
            <?php endwhile; wp_reset_postdata(); ?>
           
  </div>
<?php
    endif;
endforeach;
?>
      </div>
   </div>
</div>
<!-- Content Section End -->
<?php
get_footer();
?>