<?php
/*
Template Name: FAQ Page
*/
get_header();
?>

<!-- Breadcrumb Area Start -->
<div class="tp-breadcrumb-area tp-breadcrumb-spacing bg-position" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/01.jpg">
  <div class="container">
    <div class="row">
      <div class="col-lg-12 px-0">
        <div class="tp-breadcrumb-content">
          <h2 class="tp-breadcrumb-title mb-15 wow fadeInRight" data-wow-duration=".9s" data-wow-delay=".3s">
            <?php the_title(); ?>
          </h2>
          <div class="tp-breadcrumb-list wow fadeInLeft" data-wow-duration=".9s" data-wow-delay=".3s">
            <span><a href="<?php echo home_url(); ?>">Home</a></span>
            <span class="tp-breadcrumb-dvdr">-</span>
            <span class="tp-breadcrumb-title-pre"><?php the_title(); ?></span>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Breadcrumb Area End -->

<!-- FAQ Section -->
<div class="content-main py-5">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <div class="tp-service-details-list-3">
          <div class="tp-faq-wrapper tp-faq-wrapper-insu">
            <div class="accordion" id="general_faqaccordion">
              <?php
              $faq_query = new WP_Query(array(
                'post_type' => 'faq',
                'posts_per_page' => -1,
                'orderby' => 'menu_order',
                'order' => 'ASC'
              ));
              if ($faq_query->have_posts()):
                $i = 0;
                while ($faq_query->have_posts()): $faq_query->the_post();
                  $i++;
                  $heading_id = 'faq_heading_' . $i;
                  $collapse_id = 'faq_collapse_' . $i;
                  $show_class = ($i === 1) ? 'show' : '';
                  $collapsed_class = ($i === 1) ? '' : 'collapsed';
              ?>
              <div class="accordion-item mb-3 tp-faq-item">
                <h2 class="accordion-header" id="<?php echo esc_attr($heading_id); ?>">
                  <button class="accordion-button <?php echo esc_attr($collapsed_class); ?> tp-faq-btn-2 tp-faq-btn-4"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#<?php echo esc_attr($collapse_id); ?>"
                    aria-expanded="<?php echo $i === 1 ? 'true' : 'false'; ?>"
                    aria-controls="<?php echo esc_attr($collapse_id); ?>">
                    <?php the_title(); ?>
                    <b class="tp-faq-icon-inner">
                      <span class="accordion-btn tp-faq-icon"></span>
                    </b>
                  </button>
                </h2>
                <div id="<?php echo esc_attr($collapse_id); ?>" class="accordion-collapse collapse <?php echo esc_attr($show_class); ?>" aria-labelledby="<?php echo esc_attr($heading_id); ?>" data-bs-parent="#general_faqaccordion">
                  <div class="accordion-body tp-faq-para-2">
                    <?php the_content(); ?>
                  </div>
                </div>
              </div>
              <?php
                endwhile;
                wp_reset_postdata();
              else:
                echo '<p>No FAQs found.</p>';
              endif;
              ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>





<?php
get_footer();
?>
