<?php
/**
 * Template Name: Careers Page
 */
get_header();
?>

<!-- breadcam-area-start -->
<div class="tp-breadcrumb-area tp-breadcrumb-spacing bg-position" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/01.jpg">
   <div class="container">
      <div class="row">
         <div class="col-lg-12 px-0">
            <div class="tp-breadcrumb-content">
               <h2 class="tp-breadcrumb-title mb-15 wow fadeInRight" data-wow-duration=".9s" data-wow-delay=".3s">
                  <?php the_title(); ?>
               </h2>
               <div class="tp-breadcrumb-list wow fadeInLeft" data-wow-duration=".9s" data-wow-delay=".3s">
                  <span><a href="<?php echo home_url(); ?>">Home</a></span>
                  <span class="tp-breadcrumb-dvdr">-</span>
                  <span class="tp-breadcrumb-title-pre"><?php the_title(); ?></span>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<!-- breadcam-area-end -->

<!-- main content start -->
<div class="content-main">
   <div class="container">
      <div class="row">
         <?php
         $args = array(
             'post_type' => 'career',
             'posts_per_page' => -1,
             'orderby' => 'date',
             'order' => 'DESC'
         );
         $career_query = new WP_Query($args);
         ?>

         <?php if ($career_query->have_posts()) : ?>
            <?php while ($career_query->have_posts()) : $career_query->the_post(); ?>
               <div class="col-md-12 mb-4">
                  <div class="d-flex tp-feature-wrapper align-items-center justify-content-between">
                     <div>
                        <h5 class="mb-1"><?php the_title(); ?></h5>
                        <p class="text-muted mb-1"><?php echo get_the_date(); ?></p>
                        <p><?php the_excerpt(); ?></p>
                     </div>
                     <div class="text-end">
                        <?php if ($attachment = get_field('attachment')) : ?>
                           <a href="<?php echo esc_url($attachment['url']); ?>" target="_blank" rel="noopener">
                              <img src="<?php echo get_template_directory_uri(); ?>/assets/img/download.svg" width="40" alt="Download">
                           </a>
                        <?php endif; ?>
                     </div>
                  </div>
               </div>
            <?php endwhile; ?>
         <?php else : ?>
            <div class="col-md-12">
               <p>No career opportunities available at the moment.</p>
            </div>
         <?php endif; ?>
         <?php wp_reset_postdata(); ?>
      </div>
   </div>
</div>

<?php get_footer(); ?>
