<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
   <meta charset="<?php bloginfo('charset'); ?>">
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <title><?php wp_title(); ?></title>
   <?php
   $upload_dir = wp_get_upload_dir();
   ?>
   <meta property="og:image" content="<?php echo home_url(); ?>/wp-content/uploads/2025/05/banner-new.png" />

  <style>
  /* Prevent scroll & hide content while loading */
  html.gtranslate-waiting {
    overflow: hidden;
  }
  body.gtranslate-hidden {
    visibility: hidden;
    opacity: 0;
  }
  body.gtranslate-visible {
    visibility: visible;
    opacity: 1;
    transition: opacity 0.4s ease-in-out;
  }

  /* Loader container */
  #gtranslate-loader {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100dvh;
    background: white;
    z-index: 9999;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    font-family: sans-serif;
    font-size: 16px;
    color: #555;
  }

  /* Simple branded spinner */
  .spinner {
    width: 40px;
    height: 40px;
    border: 4px solid #ccc;
    border-top: 4px solid #009688; /* your brand color */
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin-bottom: 10px;
  }

  @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
  }

  /* Hide loader after page is visible */
  body.gtranslate-visible #gtranslate-loader {
    display: none;
  }
</style>


   <div id="google_translate_element" style="display:none;"></div>
<script>
  document.documentElement.classList.add('gtranslate-waiting');
  document.body.classList.add('gtranslate-hidden');

  document.addEventListener('DOMContentLoaded', function () {
    const htmlEl = document.documentElement;

    const checkTranslateReady = setInterval(function () {
      const selectedLangEl = document.querySelector('.gt_selected a');
      if (!selectedLangEl) return;

      const langText = selectedLangEl.textContent.trim();

      const isEnglish = langText.includes('English') && !htmlEl.classList.contains('translated-ltr');
      const isMalayalam = langText.includes('മലയാളം') && htmlEl.classList.contains('translated-ltr');

      if (isEnglish || isMalayalam) {
        document.body.classList.remove('gtranslate-hidden');
        document.body.classList.add('gtranslate-visible');
        document.documentElement.classList.remove('gtranslate-waiting');
        clearInterval(checkTranslateReady);
      }
    }, 200);

    // Optional failsafe to unhide after max wait
    setTimeout(() => {
      document.body.classList.remove('gtranslate-hidden');
      document.body.classList.add('gtranslate-visible');
      document.documentElement.classList.remove('gtranslate-waiting');
      clearInterval(checkTranslateReady);
    }, 3000);
  });
</script>

   <link rel="icon" href="<?php echo $upload_dir['baseurl']; ?>/2025/05/favicon.png">
    <!-- CSS here -->
   <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/bootstrap.css">
   <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/font-awesome-pro.css">
   <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/flaticon.css">
   <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/main.css">
   <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/spacing.css">
   <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/toddy-style.css">
<link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Malayalam&display=swap" rel="stylesheet">

   <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div id="gtranslate-loader">
  <div class="spinner"></div>
  <p>Loading translation…</p>
</div>

<header class="tp-header-height">
    <!-- header-area-start -->
    <div class="header-area-start">

        <!-- header-top-area-start -->
        <div class="tp-header-top-area tp-border-bottom section-plr d-none d-lg-block">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-7 col-xl-8 ps-0">
                        <div class="tp-header-top-info">
                            <ul>
                                <li>
                                    <a href="mailto:Ktidb123@gmail.com">
                                        <i class="fa-regular fa-envelope"></i>
                                        <span translate="no">Ktidb123@gmail.com</span>
                                    </a>
                                </li>
                                <li class="tp-top-menu">
                                    <a href="<?php echo home_url(); ?>/career">Opportunities</a>
                                  <?php if (get_option('show_faq_menu')) : ?>  <a href="<?php echo home_url(); ?>/faqs">FAQ</a>  <?php endif; ?>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-5 col-xl-4">
                        <div class="tp-header-social-icon d-flex justify-content-end">
                            <span>Follow Us On</span>
                            <?php 
                            $social_page_id = get_page_by_path('social-links')->ID;
                            if ($facebook = get_field('facebook_url', $social_page_id)) {
                                echo '<a href="' . esc_url($facebook) . '" target="_blank"><i class="fa-brands fa-facebook"></i></a>';
                            }
                            if ($instagram = get_field('instagram_url', $social_page_id)) {
                                echo '<a href="' . esc_url($instagram) . '" target="_blank"><i class="fa-brands fa-instagram"></i></a>';
                            }
                            if ($twitter = get_field('twitter_url', $social_page_id)) {
                                echo '<a href="' . esc_url($twitter) . '" target="_blank"><i class="fa-brands fa-twitter"></i></a>';
                            }
                            if ($pinterest = get_field('pinterest_url', $social_page_id)) {
                                echo '<a href="' . esc_url($pinterest) . '" target="_blank"><i class="fa-brands fa-pinterest"></i></a>';
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- header-top-area-end -->

        <!-- header-bottom-start -->
        <div class="header-bootom-area tp-header-menu-spacing section-plr p-relative tp-white-bg" id="tp-header-sticky">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xxl-3 col-xl-3 col-6 px-0">
                        <div class="tp-logo">
                            <a href="<?php echo home_url(); ?>">
                                <img 
                                    src="<?php echo $upload_dir['baseurl']; ?>/2025/05/logo-toddy-industry-development-board.png" 
                                    alt="Toddy Industry Development Board" 
                                  
                                    decoding="async"
                                   
                                >
                            </a>  <!--width="200" height="80"  style="width:200px;height:80px;"-->
                        </div>
                    </div>
                  <div class="col-xxl-7 col-xl-6 d-none d-xl-block px-0">
  <div class="tp-main-menu">

    <!-- English Menu -->
   <span translate="no"> 
    <nav id="menu-english" class="tp-main-menu-content">
      <ul>
        <li><a href="<?php echo home_url(); ?>">Home</a></li>
        <li class="has-dropdown">
          <a href="#">About Us</a>
          <ul class="tp-submenu submenu">
            <li><a href="<?php echo home_url(); ?>/about">Vision & Mission</a></li>
            <li><a href="<?php echo home_url(); ?>/directors">Director Board</a></li>
            <li><a href="<?php echo home_url(); ?>/organogram">Organogram</a></li>
            <li><a href="<?php echo home_url(); ?>/our-staff">Staffs</a></li>
          </ul>
        </li>
        <li><a href="<?php echo home_url(); ?>/project">Projects</a></li>
        <li><a href="<?php echo home_url(); ?>/rti-info">RTI</a></li>
        <li><a href="<?php echo home_url(); ?>/gallery">Gallery</a></li>
        <li><a href="<?php echo home_url(); ?>/news-announcements">News</a></li>
        <li><a href="<?php echo home_url(); ?>/contact">Contact Us</a></li>
      </ul>
    </nav>

    <!-- Malayalam Menu (initially hidden) -->
    <nav id="menu-malayalam" class="tp-main-menu-content" style="display:none;">
<ul>
                                    <li><a href="<?php echo home_url(); ?>"><font style="vertical-align: inherit;"><font style="vertical-align: inherit;">ഹോം</font></font></a></li>
                                    <li class="has-dropdown">
                                        <a href="#"><font style="vertical-align: inherit;"><font style="vertical-align: inherit;">ആമുഖം</font></font></a>
                                        <ul class="tp-submenu submenu">
                                            <li><a href="<?php echo home_url(); ?>/about"><font style="vertical-align: inherit;"><font style="vertical-align: inherit;">ദർശനവും ദൗത്യവും</font></font></a></li>
                                            <li><a href="<?php echo home_url(); ?>/directors"><font style="vertical-align: inherit;"><font style="vertical-align: inherit;">ഡയറക്ടർ ബോർഡ്</font></font></a></li>
                                            <li><a href="<?php echo home_url(); ?>/organogram"><font style="vertical-align: inherit;"><font style="vertical-align: inherit;">ഓർഗാനോഗ്രാം</font></font></a></li>
                                            <li><a href="<?php echo home_url(); ?>/our-staff"><font style="vertical-align: inherit;"><font style="vertical-align: inherit;">ജീവനക്കാർ</font></font></a></li>
                                        </ul>
                                    </li>
                                    <li><a href="<?php echo home_url(); ?>/project"><font style="vertical-align: inherit;"><font style="vertical-align: inherit;">പദ്ധതികൾ</font></font></a></li>
                                    <li><a href="<?php echo home_url(); ?>/rti-info"><font style="vertical-align: inherit;"><font style="vertical-align: inherit;">വിവരാവകാശം</font></font></a></li>
                                    <li><a href="<?php echo home_url(); ?>/gallery"><font style="vertical-align: inherit;"><font style="vertical-align: inherit;">ഗാലറി</font></font></a></li>
                                    <li><a href="<?php echo home_url(); ?>/news-announcements"><font style="vertical-align: inherit;"><font style="vertical-align: inherit;">വാർത്തകൾ</font></font></a></li>
                                    <li><a href="<?php echo home_url(); ?>/contact"><font style="vertical-align: inherit;"><font style="vertical-align: inherit;">വിലാസം</font></font></a></li>
                                </ul>



      
    </nav>
</span>
  </div>
</div>

                    <div class="col-xxl-2 col-xl-3 col-6">
                        <div class="tp-header-right-action d-none d-xl-block">
                            <ul class="d-flex align-items-center justify-content-end">
                                <li>
                                    <div class="tp-header-search">
                                        <button class="search-click" id="searchsubmit">
                                            <i class="flaticon-search"></i>
                                        </button>
                                    </div>
                                </li>
                                <li>
                                    <div class="tp-header-btn">
                                        <?php echo do_shortcode('[gtranslate]'); ?>
                                    </div>
                                </li>
                            </ul>
                        </div>
                        <div class="tp-main-menu-bar tp-menu-bar tp-header-hamburger-toogle tp-header-hamburger d-block d-xl-none">
                            <span></span><span></span><span></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- header-bottom-end -->
    </div>
    <!-- header-area-end -->

    <!-- Mobile Offcanvas Area -->
    <div class="tpoffcanvas-area">
        <div class="tpoffcanvas">
            <div class="tpoffcanvas__close-btn">
                <button class="close-btn"><i class="fal fa-times"></i></button>
            </div>
            <div class="tpoffcanvas__logo">
                <a href="<?php echo home_url(); ?>">
                    <img 
                    src="<?php echo $upload_dir['baseurl']; ?>/2025/05/logo-toddy-industry-development-board.png" 
                    alt="Toddy Industry Development Board" decoding="async">
                </a>
            </div>
            <div class="tp-main-menu-mobile d-xl-none"></div>

             <div class="tp-header-right-action">
                            <ul class="d-flex align-items-center justify-content-end">
                                <li>
                                    <div class="tp-header-search">
                                        <button class="search-click" id="searchsubmit">
                                            <i class="flaticon-search"></i>
                                        </button>
                                    </div>
                                </li>
                                <li>
                                    <div class="tp-header-btn">
                                        <?php echo do_shortcode('[gtranslate]'); ?>
                                    </div>
                                </li>
                            </ul>
                        </div>
            <div class="tpoffcanvas__contact-info">
                <div class="tpoffcanvas__contact-title"><h5>Contact us</h5></div>
                <ul>
                    <li><i class="fa-light fa-location-dot"></i> TC 81/3986, Central Telephone Exchange - Block-A, First Floor, Near Government Press, Statue, Thiruvananthapuram- 695001</li>
                    <li><i class="fas fa-envelope"></i> <a href="mailto:Ktidb123@gmail.com">Ktidb123@gmail.com</a></li>
                    <li><i class="flaticon-telephone"></i> <a href="tel:04712335028">0471 2335028</a></li>
                </ul>
            </div>
            <div class="tpoffcanvas__social">
                <div class="social-icon">
                    <a href="#"><i class="fab fa-twitter"></i></a>
                    <a href="#"><i class="fab fa-instagram"></i></a>
                    <a href="#"><i class="fab fa-facebook-f"></i></a>
                </div>
            </div>
        </div>
    </div>
    <div class="body-overlay"></div>

    <!-- Search Form -->
    <div class="tp-search-body-overlay"></div>
    <div class="tp-search-form-toggle">
        <div class="tp-search-close">
            <i class="fa-solid fa-xmark"></i>
        </div>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="tp-search-form">
                        <form role="search" method="get" class="searchform" action="<?php echo home_url('/'); ?>">
                            <input type="text" name="s" placeholder="Search..." value="<?php echo get_search_query(); ?>">
                            <div class="tp-search-form-icon">
                                <button type="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>

<?php // Continue page content here ?>
